/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.LiquidExpansionThermometerNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsResources;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.Nucleon;
import edu.colorado.phet.nuclearphysics.common.view.AbstractAtomicNucleusNode;
import edu.colorado.phet.nuclearphysics.common.view.AtomicNucleusImageNode;
import edu.colorado.phet.nuclearphysics.common.view.AtomicNucleusImageType;
import edu.colorado.phet.nuclearphysics.model.Uranium235Nucleus;
import edu.colorado.phet.nuclearphysics.model.Uranium238Nucleus;
import edu.colorado.phet.nuclearphysics.module.betadecay.LabelVisibilityModel;
import edu.colorado.phet.nuclearphysics.module.nuclearreactor.ControlRod;
import edu.colorado.phet.nuclearphysics.module.nuclearreactor.NuclearReactorModel;
import edu.colorado.phet.nuclearphysics.view.ControlRodAdjusterNode;
import edu.colorado.phet.nuclearphysics.view.ControlRodNode;
import edu.colorado.phet.nuclearphysics.view.NucleonNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Timer;

public class NuclearReactorNode
extends PNode {
    private static final Color REACTOR_WALL_COLOR = Color.BLACK;
    private static final Color COOL_REACTOR_CHAMBER_COLOR = new Color(0xBBCCCC);
    private static final Color HOT_REACTOR_CHAMBER_COLOR = new Color(0xFFBB44);
    private static final Timer BUTTON_PRESS_TIMER = new Timer(400, null);
    private NuclearReactorModel _nuclearReactorModel;
    PhetPCanvas _canvas;
    PPath _reactorWall;
    PNode _nucleiAndFreeParticleNode;
    HashMap _modelElementToNodeMap;
    LiquidExpansionThermometerNode _thermometerNode;

    public NuclearReactorNode(NuclearReactorModel nuclearReactorModel, PhetPCanvas phetPCanvas) {
        this._nuclearReactorModel = nuclearReactorModel;
        this._canvas = phetPCanvas;
        this._modelElementToNodeMap = new HashMap();
        this._nuclearReactorModel.addListener(new NuclearReactorModel.Adapter(){

            public void modelElementAdded(Object object) {
                NuclearReactorNode.this.handleModelElementAdded(object);
            }

            public void modelElementRemoved(Object object) {
                NuclearReactorNode.this.handleModelElementRemoved(object);
            }

            public void resetOccurred() {
                NuclearReactorNode.this.handleReactorReset();
            }

            public void temperatureChanged() {
                NuclearReactorNode.this.setInternalReactorColor();
            }
        });
        Rectangle2D rectangle2D = this._nuclearReactorModel.getReactorRect();
        FireNeutronsNode fireNeutronsNode = new FireNeutronsNode(rectangle2D.getHeight() * 0.15);
        fireNeutronsNode.setOffset(rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - fireNeutronsNode.getFullBoundsReference().width / 2.0, rectangle2D.getY() - fireNeutronsNode.getFullBoundsReference().height * 0.9);
        this.addChild(fireNeutronsNode);
        double d = this._nuclearReactorModel.getReactorWallWidth();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() + d / 2.0, rectangle2D.getY() + d / 2.0, rectangle2D.getWidth() - d, rectangle2D.getHeight() - d);
        this._reactorWall = new PPath(double_);
        this._reactorWall.setStroke(new BasicStroke((float)d));
        this._reactorWall.setStrokePaint(REACTOR_WALL_COLOR);
        this.addChild(this._reactorWall);
        this.setInternalReactorColor();
        ArrayList arrayList = this._nuclearReactorModel.getChamberRectsReference();
        for (int i = 0; i < arrayList.size(); ++i) {
            PPath pPath = new PPath((Rectangle2D)arrayList.get(i));
            this.addChild(pPath);
        }
        ArrayList arrayList2 = this._nuclearReactorModel.getControlRodsReference();
        for (int i = 0; i < arrayList2.size(); ++i) {
            ControlRodNode controlRodNode = new ControlRodNode((ControlRod)arrayList2.get(i));
            this.addChild(controlRodNode);
        }
        this.addChild(new ControlRodAdjusterNode(this._nuclearReactorModel));
        this._nucleiAndFreeParticleNode = new PNode();
        this.addChild(this._nucleiAndFreeParticleNode);
        this.addNucleusNodes();
        this._thermometerNode = new LiquidExpansionThermometerNode(new PDimension(rectangle2D.getWidth() * 0.05, rectangle2D.getHeight() * 0.4));
        this.addChild(this._thermometerNode);
        this._thermometerNode.setOffset(rectangle2D.getX() + rectangle2D.getWidth() * 0.88, rectangle2D.getY() - rectangle2D.getHeight() * 0.18);
        this.updateThermometerTemperature();
        this._nuclearReactorModel.addListener(new NuclearReactorModel.Adapter(){

            public void temperatureChanged() {
                NuclearReactorNode.this.updateThermometerTemperature();
            }
        });
    }

    private void handleReactorReset() {
        if (this._nucleiAndFreeParticleNode.getChildrenCount() > 0) {
            System.err.println("Error: Particle and/or nuclei nodes still exist after reset.");
            assert (false);
            this._nucleiAndFreeParticleNode.removeAllChildren();
        }
        this.setInternalReactorColor();
        this.addNucleusNodes();
    }

    private void setInternalReactorColor() {
        double d = this._nuclearReactorModel.getTemperature();
        if (d > 75.0) {
            d = 75.0;
        }
        double d2 = (75.0 - d) / 75.0;
        int n = (int)Math.round((double)COOL_REACTOR_CHAMBER_COLOR.getRed() * d2 + (double)HOT_REACTOR_CHAMBER_COLOR.getRed() * (1.0 - d2));
        int n2 = (int)Math.round((double)COOL_REACTOR_CHAMBER_COLOR.getGreen() * d2 + (double)HOT_REACTOR_CHAMBER_COLOR.getGreen() * (1.0 - d2));
        int n3 = (int)Math.round((double)COOL_REACTOR_CHAMBER_COLOR.getBlue() * d2 + (double)HOT_REACTOR_CHAMBER_COLOR.getBlue() * (1.0 - d2));
        if (n3 > 255) {
            System.err.println("Holy jeez, what's going on?");
        }
        this._reactorWall.setPaint(new Color(n, n2, n3));
    }

    private void addNucleusNodes() {
        ArrayList arrayList = this._nuclearReactorModel.getNuclei();
        for (int i = 0; i < arrayList.size(); ++i) {
            AtomicNucleus atomicNucleus = (AtomicNucleus)arrayList.get(i);
            if (!(atomicNucleus instanceof Uranium235Nucleus)) continue;
            AtomicNucleusImageNode atomicNucleusImageNode = new AtomicNucleusImageNode(atomicNucleus, AtomicNucleusImageType.NUCLEONS_VISIBLE, new LabelVisibilityModel());
            this._nucleiAndFreeParticleNode.addChild(atomicNucleusImageNode);
            this._modelElementToNodeMap.put(atomicNucleus, atomicNucleusImageNode);
        }
    }

    public void handleModelElementAdded(Object object) {
        if (object instanceof AtomicNucleus) {
            AtomicNucleusImageNode atomicNucleusImageNode = new AtomicNucleusImageNode((AtomicNucleus)object, AtomicNucleusImageType.NUCLEONS_VISIBLE, new LabelVisibilityModel());
            this._nucleiAndFreeParticleNode.addChild(atomicNucleusImageNode);
            this._modelElementToNodeMap.put(object, atomicNucleusImageNode);
        } else if (object instanceof Nucleon) {
            NucleonNode nucleonNode = new NucleonNode((Nucleon)object);
            this._nucleiAndFreeParticleNode.addChild(nucleonNode);
            this._modelElementToNodeMap.put(object, nucleonNode);
        } else {
            System.err.println("Error: Unable to find appropriate node for model element.");
            assert (false);
        }
    }

    public void handleModelElementRemoved(Object object) {
        Object v = this._modelElementToNodeMap.get(object);
        if (v != null && v instanceof PNode) {
            if (object instanceof AtomicNucleus) {
                this._nucleiAndFreeParticleNode.removeChild((PNode)v);
                AbstractAtomicNucleusNode abstractAtomicNucleusNode = (AbstractAtomicNucleusNode)this._modelElementToNodeMap.remove(object);
                abstractAtomicNucleusNode.cleanup();
            } else {
                this._nucleiAndFreeParticleNode.removeChild((PNode)v);
                this._modelElementToNodeMap.remove(object);
            }
        } else if (!(object instanceof Uranium238Nucleus)) {
            System.err.println("Error: Problem encountered removing node from canvas.");
        }
    }

    private void updateThermometerTemperature() {
        this._thermometerNode.setLiquidHeight(MathUtil.clamp(0.0, this._nuclearReactorModel.getTemperature() / 75.0, 1.0));
    }

    static /* synthetic */ Color access$300() {
        return COOL_REACTOR_CHAMBER_COLOR;
    }

    private class FireNeutronsNode
    extends PNode {
        private final Color BACKGROUND_COLOR = NuclearReactorNode.access$300();
        private final float EDGE_STROKE_SIZE = 3.0f;
        private final Stroke EDGE_STROKE = new BasicStroke(3.0f);
        private PNode _fireButtonUp;

        public FireNeutronsNode(double d) {
            BufferedImage bufferedImage = NuclearPhysicsResources.getImage("fire-button-pressed.png");
            double d2 = d * 0.85 / (double)bufferedImage.getWidth();
            bufferedImage = BufferedImageUtils.multiScale(bufferedImage, d2);
            PImage pImage = new PImage(bufferedImage);
            pImage.setOffset(6.0, d / 2.0 - pImage.getFullBoundsReference().height / 2.0);
            bufferedImage = NuclearPhysicsResources.getImage("fire-button-unpressed.png");
            bufferedImage = BufferedImageUtils.multiScale(bufferedImage, d2);
            this._fireButtonUp = new PImage(bufferedImage);
            this._fireButtonUp.setOffset(6.0, d / 2.0 - this._fireButtonUp.getFullBoundsReference().height / 2.0);
            this._fireButtonUp.addInputEventListener(new CursorHandler());
            this._fireButtonUp.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    FireNeutronsNode.this._fireButtonUp.setVisible(false);
                    FireNeutronsNode.this._fireButtonUp.setPickable(false);
                    NuclearReactorNode.this._nuclearReactorModel.fireNeutrons();
                    BUTTON_PRESS_TIMER.restart();
                }
            });
            BUTTON_PRESS_TIMER.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FireNeutronsNode.this._fireButtonUp.setVisible(true);
                    FireNeutronsNode.this._fireButtonUp.setPickable(true);
                    BUTTON_PRESS_TIMER.stop();
                }
            });
            PText pText = new PText(NuclearPhysicsStrings.FIRE_NEUTRONS);
            pText.setFont(new PhetFont());
            pText.setScale(d * 0.9 / pText.getFullBoundsReference().height);
            pText.setOffset(this._fireButtonUp.getFullBoundsReference().getMaxX() + 3.0, d / 2.0 - pText.getFullBoundsReference().height / 2.0);
            double d3 = 6.0 + this._fireButtonUp.getFullBoundsReference().width + 3.0 + pText.getFullBoundsReference().width + 6.0;
            PPath pPath = new PPath(new RoundRectangle2D.Double(0.0, 0.0, d3, d, 4.0, 4.0));
            pPath.setPaint(this.BACKGROUND_COLOR);
            pPath.setStroke(this.EDGE_STROKE);
            this.addChild(pPath);
            pPath.addChild(pImage);
            pPath.addChild(this._fireButtonUp);
            pPath.addChild(pText);
        }
    }
}

