/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.view;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsResources;
import edu.colorado.phet.nuclearphysics.model.NeutronSource;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Timer;

public class NeutronSourceNode
extends PNode {
    private static final Timer BUTTON_PRESS_TIMER = new Timer(400, null);
    private NeutronSource _neutronSource;
    private PNode _displayImage;
    private PNode _fireButtonUp;
    private PNode _fireButtonDown;
    private double _relativeRotationPointX;
    private double _relativeRotationPointY;
    private double _absoluteRotationPointX;
    private double _absoluteRotationPointY;
    private double _origWidth;
    private double _origHeight;
    private double _currentOrientation;
    private PPath _rotationGrabberNode;

    public NeutronSourceNode(NeutronSource neutronSource, double d) {
        this._neutronSource = neutronSource;
        this._currentOrientation = 0.0;
        this._neutronSource.addListener(new NeutronSource.Adapter(){

            public void orientationChanged() {
                NeutronSourceNode.this.rotateToMatchNeutronSource();
            }

            public void positionChanged() {
                NeutronSourceNode.this.translateToMatchNeutronSource();
            }
        });
        BufferedImage bufferedImage = NuclearPhysicsResources.getImage("ray-gun.png");
        this._displayImage = new PImage(bufferedImage);
        this.addChild(this._displayImage);
        bufferedImage = NuclearPhysicsResources.getImage("fire-button-pressed.png");
        double d2 = this.getFullBoundsReference().width * 0.275 / (double)bufferedImage.getWidth();
        bufferedImage = BufferedImageUtils.multiScale(bufferedImage, d2);
        this._fireButtonDown = new PImage(bufferedImage);
        this._fireButtonDown.setPickable(false);
        this.addChild(this._fireButtonDown);
        this._fireButtonDown.setOffset(this._displayImage.getFullBoundsReference().width * 0.29, this._displayImage.getFullBoundsReference().width * 0.055);
        bufferedImage = NuclearPhysicsResources.getImage("fire-button-unpressed.png");
        bufferedImage = BufferedImageUtils.multiScale(bufferedImage, d2);
        this._fireButtonUp = new PImage(bufferedImage);
        this._fireButtonUp.setPickable(true);
        this.addChild(this._fireButtonUp);
        this._fireButtonUp.setOffset(this._displayImage.getFullBoundsReference().width * 0.29, this._displayImage.getFullBoundsReference().width * 0.055);
        this._fireButtonUp.addInputEventListener(new CursorHandler());
        this._fireButtonUp.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                NeutronSourceNode.this._fireButtonUp.setVisible(false);
                NeutronSourceNode.this._fireButtonUp.setPickable(false);
                NeutronSourceNode.this._neutronSource.generateNeutron();
                BUTTON_PRESS_TIMER.restart();
            }
        });
        BUTTON_PRESS_TIMER.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NeutronSourceNode.this._fireButtonUp.setVisible(true);
                NeutronSourceNode.this._fireButtonUp.setPickable(true);
                BUTTON_PRESS_TIMER.stop();
            }
        });
        this._rotationGrabberNode = new PPath(new Rectangle2D.Double(0.0, 0.0, this._displayImage.getWidth() * 0.2, this._displayImage.getHeight() * 0.3));
        this._rotationGrabberNode.setOffset(this._displayImage.getWidth() - this._rotationGrabberNode.getWidth(), this._displayImage.getHeight() * 0.33 - this._rotationGrabberNode.getHeight() / 2.0);
        this._rotationGrabberNode.setPaint(new Color(0, 0, 0, 0));
        this._rotationGrabberNode.setStroke(null);
        this._rotationGrabberNode.addInputEventListener(new CursorHandler(8));
        this._rotationGrabberNode.addInputEventListener(new PDragEventHandler(){
            double _previousMouseAngle;

            public void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                this._previousMouseAngle = NeutronSourceNode.this.calculateEventAngle(pInputEvent);
            }

            public void drag(PInputEvent pInputEvent) {
                double d = NeutronSourceNode.this.calculateEventAngle(pInputEvent);
                double d2 = d - this._previousMouseAngle;
                NeutronSourceNode.this._neutronSource.setFiringAngle(NeutronSourceNode.this._currentOrientation + d2);
                double d3 = NeutronSourceNode.this._absoluteRotationPointX + Math.cos(NeutronSourceNode.this._currentOrientation) * NeutronSourceNode.this._origWidth / 2.0;
                double d4 = NeutronSourceNode.this._absoluteRotationPointY + Math.sin(NeutronSourceNode.this._currentOrientation) * NeutronSourceNode.this._origWidth / 2.0;
                NeutronSourceNode.this._neutronSource.setPosition(d3, d4);
                this._previousMouseAngle = d;
            }
        });
        this._displayImage.addChild(this._rotationGrabberNode);
        this.scale(d / this.getFullBoundsReference().width);
        this._relativeRotationPointX = this.getFullBounds().width / 2.0;
        this._relativeRotationPointY = this.getFullBounds().height * 0.33;
        this._origWidth = this.getFullBounds().width;
        this._origHeight = this.getFullBounds().height;
        this._absoluteRotationPointX = this._neutronSource.getPosition().getX() - this._origWidth / 2.0 * Math.cos(this._neutronSource.getFiringAngle());
        this._absoluteRotationPointY = this._neutronSource.getPosition().getY() - this._origWidth / 2.0 * Math.sin(this._neutronSource.getFiringAngle());
        this.rotateToMatchNeutronSource();
        this.translateToMatchNeutronSource();
    }

    public void setRotationEnabled(boolean bl) {
        this._rotationGrabberNode.setPickable(bl);
    }

    private void translateToMatchNeutronSource() {
        double d = this._neutronSource.getPosition().getX() - Math.cos(this._currentOrientation) * this._origWidth + Math.sin(this._currentOrientation) * (this._origHeight * 0.33);
        double d2 = this._neutronSource.getPosition().getY() - Math.sin(this._currentOrientation) * this._origWidth - Math.cos(this._currentOrientation) * (this._origHeight * 0.33);
        this.setOffset(d, d2);
    }

    private void rotateToMatchNeutronSource() {
        this.rotateAboutPoint(this._neutronSource.getFiringAngle() - this._currentOrientation, this._relativeRotationPointX, this._relativeRotationPointY);
        this._currentOrientation = this._neutronSource.getFiringAngle();
    }

    double calculateEventAngle(PInputEvent pInputEvent) {
        double d = pInputEvent.getPositionRelativeTo(this.getParent()).getX();
        double d2 = pInputEvent.getPositionRelativeTo(this.getParent()).getY();
        return Math.atan2(d2 - this._absoluteRotationPointY, d - this._absoluteRotationPointX);
    }
}

