/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.view;

import edu.colorado.phet.common.piccolophet.nodes.ShadowHTMLNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsResources;
import edu.colorado.phet.nuclearphysics.common.NucleusDisplayInfo;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.view.LabeledNucleusNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class LabeledNucleusImageNode
extends LabeledNucleusNode {
    public LabeledNucleusImageNode(String string, String string2, String string3, Color color) {
        super(string2, string3, color);
        BufferedImage bufferedImage = NuclearPhysicsResources.getImage(string);
        PImage pImage = new PImage(bufferedImage);
        pImage.setScale(50.0 / pImage.getWidth());
        this.getRepresentationLayer().addChild(pImage);
        double d = pImage.getFullBoundsReference().getWidth();
        double d2 = pImage.getFullBoundsReference().getHeight();
        ShadowHTMLNode shadowHTMLNode = this.getLabel();
        double d3 = Math.min(d / shadowHTMLNode.getFullBoundsReference().getWidth() * 0.9, d2 / shadowHTMLNode.getFullBoundsReference().getHeight());
        shadowHTMLNode.setScale(d3);
        shadowHTMLNode.setOffset((d - shadowHTMLNode.getFullBoundsReference().getWidth()) / 2.0, (d2 - shadowHTMLNode.getFullBoundsReference().getHeight()) / 2.0);
    }

    public LabeledNucleusImageNode(NucleusDisplayInfo nucleusDisplayInfo) {
        this(nucleusDisplayInfo.getImageName(), nucleusDisplayInfo.getIsotopeNumberString(), nucleusDisplayInfo.getChemicalSymbol(), nucleusDisplayInfo.getLabelColor());
    }

    public LabeledNucleusImageNode(NucleusType nucleusType) {
        this(NucleusDisplayInfo.getDisplayInfoForNucleusType(nucleusType));
    }
}

