/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.view;

import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HandleNode;
import edu.colorado.phet.nuclearphysics.model.ContainmentVessel;
import edu.colorado.phet.nuclearphysics.util.MovingImageNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Random;

public class ContainmentVesselNode
extends PNode {
    private static final BasicStroke HANDLE_STROKE = new BasicStroke(1.2f);
    private static final Color HANDLE_COLOR = Color.LIGHT_GRAY;
    private ContainmentVessel _containmentVessel;
    private Ellipse2D _mainVesselOuterEllipse;
    private Ellipse2D _mainVesselInnerEllipse;
    private PPath _mainVesselNode;
    private HandleNode _lowerRightHandle;
    private HandleNode _upperRightHandle;
    boolean _resizing;
    PhetPCanvas _canvas;
    SwingClock _clock;
    Random _rand;
    ArrayList _fragments;

    public ContainmentVesselNode(ContainmentVessel containmentVessel, PhetPCanvas phetPCanvas, SwingClock swingClock) {
        this._containmentVessel = containmentVessel;
        this._canvas = phetPCanvas;
        this._clock = swingClock;
        this._resizing = false;
        this._rand = new Random();
        this._fragments = new ArrayList();
        this._containmentVessel.addListener(new ContainmentVessel.Adapter(){

            public void radiusChanged(double d) {
                ContainmentVesselNode.this.setVesselNodeSizeAndPosition();
                ContainmentVesselNode.this._canvas.repaint();
            }

            public void enableStateChanged(boolean bl) {
                ContainmentVesselNode.this._mainVesselNode.setVisible(bl);
                ContainmentVesselNode.this._lowerRightHandle.setVisible(bl);
                ContainmentVesselNode.this._upperRightHandle.setVisible(bl);
            }

            public void explosionOccurred() {
                ContainmentVesselNode.this.handleContainmentVesselExplosion();
            }

            public void resetOccurred() {
                ContainmentVesselNode.this.handleResetOccurred();
            }
        });
        this._upperRightHandle = new HandleNode(12.0, 15.0, 3.0, 4.0, HANDLE_COLOR, Color.BLACK, HANDLE_STROKE);
        this._upperRightHandle.setVisible(this._containmentVessel.getIsEnabled());
        this._upperRightHandle.rotate(2.356194490192345);
        this._upperRightHandle.addInputEventListener(new CursorHandler());
        this._upperRightHandle.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                ContainmentVesselNode.this.handleMouseDraggedEvent(pInputEvent);
            }
        });
        this.addChild(this._upperRightHandle);
        this._lowerRightHandle = new HandleNode(12.0, 15.0, 3.0, 4.0, HANDLE_COLOR, Color.BLACK, HANDLE_STROKE);
        this._lowerRightHandle.setVisible(this._containmentVessel.getIsEnabled());
        this._lowerRightHandle.rotate(3.9269908169872414);
        this._lowerRightHandle.addInputEventListener(new CursorHandler());
        this._lowerRightHandle.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                ContainmentVesselNode.this.handleMouseDraggedEvent(pInputEvent);
            }
        });
        this.addChild(this._lowerRightHandle);
        this._mainVesselOuterEllipse = new Ellipse2D.Double();
        this._mainVesselInnerEllipse = new Ellipse2D.Double();
        this._mainVesselNode = new PPath(this._mainVesselOuterEllipse);
        this._mainVesselNode.addInputEventListener(new CursorHandler());
        this._mainVesselNode.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                ContainmentVesselNode.this.handleMouseDraggedEvent(pInputEvent);
            }
        });
        this._mainVesselNode.setVisible(this._containmentVessel.getIsEnabled());
        this._mainVesselNode.setPickable(true);
        this.addChild(this._mainVesselNode);
        this.setVesselNodeSizeAndPosition();
    }

    private void setVesselNodeSizeAndPosition() {
        double d = this._containmentVessel.getRadius();
        Rectangle2D rectangle2D = this._containmentVessel.getAperatureRectReference();
        this._mainVesselInnerEllipse.setFrameFromDiagonal(-d, -d, d, d);
        this._mainVesselOuterEllipse.setFrameFromDiagonal(-d - 8.0, -d - 8.0, d + 8.0, d + 8.0);
        Area area = new Area(this._mainVesselOuterEllipse);
        area.subtract(new Area(this._mainVesselInnerEllipse));
        area.subtract(new Area(rectangle2D));
        this._mainVesselNode.setPathTo(area);
        this._mainVesselNode.setPaint(Color.BLACK);
        double d2 = d + 12.0 + 4.0;
        double d3 = 0.7853981633974483 - Math.atan(7.5 / (d + 12.0));
        double d4 = d2 * Math.cos(d3);
        double d5 = -d2 * Math.sin(d3);
        this._upperRightHandle.setOffset(d4, d5);
        d3 = -0.7853981633974483 - Math.atan(7.5 / (d + 12.0));
        d4 = d2 * Math.cos(d3);
        d5 = -d2 * Math.sin(d3);
        this._lowerRightHandle.setOffset(d4, d5);
    }

    private void handleContainmentVesselExplosion() {
        int n;
        BufferedImage bufferedImage = BufferedImageUtils.toBufferedImage(this._mainVesselNode.toImage());
        int n2 = n = 4;
        int n3 = bufferedImage.getWidth() / n;
        int n4 = bufferedImage.getHeight() / n2;
        double d = this._mainVesselNode.getOffset().getX() - (double)n / 2.0 * (double)n3;
        double d2 = this._mainVesselNode.getOffset().getY() - (double)n2 / 2.0 * (double)n4;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d3 = d + (double)(i * n3);
                double d4 = d2 + (double)(j * n4);
                double d5 = this._rand.nextDouble() * 5.0;
                if (d3 < 0.0) {
                    d5 = -d5;
                }
                double d6 = this._rand.nextDouble() * 5.0;
                if (d4 < 0.0) {
                    d6 = -d6;
                }
                double d7 = this._rand.nextDouble() * 0.02;
                MovingImageNode movingImageNode = new MovingImageNode(bufferedImage.getSubimage(i * n3, j * n4, n3, n4), d5, d6, d7, this._clock);
                movingImageNode.setOffset(d + (double)(i * n3), d2 + (double)(j * n4));
                this.addChild(movingImageNode);
                this._fragments.add(movingImageNode);
            }
        }
        this._mainVesselNode.setVisible(false);
        this._lowerRightHandle.setVisible(false);
        this._upperRightHandle.setVisible(false);
    }

    private void handleResetOccurred() {
        for (MovingImageNode movingImageNode : this._fragments) {
            this.removeChild(movingImageNode);
            movingImageNode.cleanup();
        }
        this._fragments.clear();
        this.setVesselNodeSizeAndPosition();
    }

    private void handleMouseDraggedEvent(PInputEvent pInputEvent) {
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        ((Point2D)double_).setLocation(this._canvas.getWidth() / 2, this._canvas.getHeight() / 2);
        ((Point2D)double_2).setLocation(pInputEvent.getPosition().getX() - pInputEvent.getDelta().width, pInputEvent.getPosition().getY() - pInputEvent.getDelta().height);
        double d = double_.distance(pInputEvent.getPosition()) - double_.distance(double_2);
        PDimension pDimension = new PDimension(1.0, 1.0);
        this._canvas.getPhetRootNode().screenToWorld(pDimension);
        double d2 = pDimension.getWidth();
        this._containmentVessel.setRadius(this._containmentVessel.getRadius() + d * d2);
    }
}

