/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.view;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsResources;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.model.ContainmentVessel;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;
import java.awt.Font;

public class AtomicBombGraphicNode
extends PhetPNode {
    private static final Font LABEL_FONT = new PhetFont(32, true, true);
    private static final Color LABEL_COLOR = Color.RED;
    private SwingClock _clock;
    private ClockAdapter _clockAdapter;
    private ShadowPText _explosionLabel;
    private PImage _explosionGraphic;
    private int _explodingState;
    double _containerWidth;
    double _containerHeight;

    public AtomicBombGraphicNode(ContainmentVessel containmentVessel, SwingClock swingClock) {
        this._clock = swingClock;
        this._explodingState = 0;
        this._clockAdapter = new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                AtomicBombGraphicNode.this.handleClockTicked(clockEvent);
            }
        };
        this._clock.addClockListener(this._clockAdapter);
        containmentVessel.addListener(new ContainmentVessel.Adapter(){

            public void explosionOccurred() {
                AtomicBombGraphicNode.this._explosionGraphic.setScale(1.0);
                AtomicBombGraphicNode.this._explosionGraphic.setScale(20.0 / ((AtomicBombGraphicNode)AtomicBombGraphicNode.this)._explosionGraphic.getFullBoundsReference().width);
                AtomicBombGraphicNode.this._explodingState = 1;
                AtomicBombGraphicNode.this.setVisible(true);
            }

            public void resetOccurred() {
                AtomicBombGraphicNode.this.handleResetOccurred();
            }
        });
        this.setVisible(false);
        this._explosionGraphic = new PImage(NuclearPhysicsResources.getImage("castle_romeo2.jpg"));
        this.addChild(this._explosionGraphic);
        this._explosionLabel = new ShadowPText(NuclearPhysicsStrings.EXPLOSION_LABEL, LABEL_COLOR, LABEL_FONT);
        this.addChild(this._explosionLabel);
    }

    public void setContainerSize(double d, double d2) {
        this._containerWidth = d;
        this._containerHeight = d2;
        this.updateLayout();
    }

    public void updateLayout() {
        if (this._explodingState == 2) {
            this.setOffset(0.0, 0.0);
            this._explosionGraphic.setScale(1.0);
            this._explosionGraphic.setBounds(0.0, 0.0, this._containerWidth, this._containerHeight);
            PBounds pBounds = this._explosionGraphic.getFullBoundsReference();
            this._explosionLabel.setOffset(pBounds.width / 2.0 - this._explosionLabel.getFullBoundsReference().width / 2.0, pBounds.height * 0.1);
        } else {
            PBounds pBounds = this._explosionGraphic.getFullBoundsReference();
            this.setOffset(this._containerWidth / 2.0 - pBounds.width / 2.0, this._containerHeight / 2.0 - pBounds.height / 2.0);
            this._explosionGraphic.setOffset(pBounds.width / 2.0 - this._explosionGraphic.getFullBoundsReference().width / 2.0, pBounds.height / 2.0 - this._explosionGraphic.getFullBoundsReference().height / 2.0);
            this._explosionLabel.setOffset(pBounds.width / 2.0 - this._explosionLabel.getFullBoundsReference().width / 2.0, pBounds.height * 0.1);
        }
    }

    private void handleClockTicked(ClockEvent clockEvent) {
        if (this._explodingState == 1) {
            if (this._explosionGraphic.getFullBounds().getHeight() < this._containerHeight || this._explosionGraphic.getFullBounds().getWidth() < this._containerWidth) {
                this._explosionGraphic.setScale(this._explosionGraphic.getScale() + 0.05);
                this.updateLayout();
            } else {
                this._explodingState = 2;
            }
        }
    }

    private void handleResetOccurred() {
        this._explodingState = 0;
        this.setVisible(false);
        this._explosionGraphic.setScale(1.0);
        this.updateLayout();
    }
}

