/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsResources;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadiometricMeasurementModel;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadiometricMeasurementControlPanel
extends ControlPanel {
    private RadiometricMeasurementModel _model;

    public RadiometricMeasurementControlPanel(PiccoloModule piccoloModule, Frame frame, RadiometricMeasurementModel radiometricMeasurementModel) {
        this._model = radiometricMeasurementModel;
        int n = NuclearPhysicsResources.getInt("int.minControlPanelWidth", 215);
        this.setMinimumWidth(n);
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(NuclearPhysicsStrings.MEASUREMENT_CONTROL_PANEL_TITLE);
        jLabel.setFont(new PhetFont(20, true));
        jPanel.add(jLabel);
        this.addControlFullWidth(jPanel);
        this.addControlFullWidth(this.createVerticalSpacingPanel(20));
        RadioButtonWithIcon radioButtonWithIcon = new RadioButtonWithIcon(NuclearPhysicsStrings.TREE_LABEL, "tree_1.png");
        this.addControlFullWidth(radioButtonWithIcon);
        radioButtonWithIcon.getButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RadiometricMeasurementControlPanel.this._model.setSimulationMode(RadiometricMeasurementModel.SIMULATION_MODE.TREE);
            }
        });
        this.addControlFullWidth(this.createVerticalSpacingPanel(10));
        RadioButtonWithIcon radioButtonWithIcon2 = new RadioButtonWithIcon(NuclearPhysicsStrings.ROCK_LABEL, "rock_1.png");
        this.addControlFullWidth(radioButtonWithIcon2);
        radioButtonWithIcon2.getButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RadiometricMeasurementControlPanel.this._model.setSimulationMode(RadiometricMeasurementModel.SIMULATION_MODE.ROCK);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(radioButtonWithIcon.getButton());
        buttonGroup.add(radioButtonWithIcon2.getButton());
        radioButtonWithIcon.getButton().setSelected(true);
        this.addControlFullWidth(this.createVerticalSpacingPanel(30));
        JButton jButton = new JButton(NuclearPhysicsStrings.RESET_BUTTON_LABEL);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RadiometricMeasurementControlPanel.this._model.resetOperation();
            }
        });
        this.addControl(jButton);
    }

    private JPanel createVerticalSpacingPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(n));
        return jPanel;
    }

    private static class RadioButtonWithIcon
    extends HorizontalLayoutPanel {
        private static final Font LABEL_FONT = new PhetFont(18);
        private JRadioButton _button;

        public RadioButtonWithIcon(String string, String string2) {
            this._button = new JRadioButton(string);
            this._button.setFont(LABEL_FONT);
            this.add(this._button);
            BufferedImage bufferedImage = NuclearPhysicsResources.getImage(string2);
            double d = 90.0 / (double)bufferedImage.getHeight();
            bufferedImage = BufferedImageUtils.rescaleFractional(bufferedImage, d, d);
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            JLabel jLabel = new JLabel(imageIcon);
            this.add(jLabel);
            jLabel.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    RadioButtonWithIcon.this._button.doClick();
                }
            });
        }

        public JRadioButton getButton() {
            return this._button;
        }
    }
}

