/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.audio.AudioResourcePlayer;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsResources;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadioactiveDatingGameCanvas;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadioactiveDatingGameModel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class RadioactiveDatingGameModule
extends PiccoloModule {
    private RadioactiveDatingGameModel _model;
    private RadioactiveDatingGameCanvas _canvas;
    private AudioResourcePlayer audioResourcePlayer = new AudioResourcePlayer(NuclearPhysicsResources.getResourceLoader(), true);
    private PiccoloClockControlPanel _clockControlPanel;

    public RadioactiveDatingGameModule(Frame frame) {
        super(NuclearPhysicsStrings.TITLE_RADIOACTIVE_DATING_GAME, new NuclearPhysicsClock(25, 40.0));
        this.audioResourcePlayer.setEnabled(true);
        final JCheckBox jCheckBox = new JCheckBox(NuclearPhysicsStrings.SOUND_ENABLED, this.audioResourcePlayer.isEnabled());
        jCheckBox.setOpaque(false);
        this._clockControlPanel.addToLeft(jCheckBox);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RadioactiveDatingGameModule.this.audioResourcePlayer.setEnabled(jCheckBox.isSelected());
            }
        });
        this._model = new RadioactiveDatingGameModel();
        this._canvas = new RadioactiveDatingGameCanvas(this._model, this.audioResourcePlayer);
        this.setSimulationPanel(this._canvas);
        if (this.hasHelp()) {
            // empty if block
        }
        this.reset();
    }

    protected JComponent createClockControlPanel(IClock iClock) {
        this._clockControlPanel = new PiccoloClockControlPanel(iClock);
        return this._clockControlPanel;
    }
}

