/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.DatableItem;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.ModelContainingDatableItems;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadiometricDatingMeter;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.Stratum;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioactiveDatingGameModel
implements ModelContainingDatableItems {
    private ArrayList<DatableItem> _datableObjects = new ArrayList();
    private ArrayList<Stratum> _strata = new ArrayList();
    private RadiometricDatingMeter _meter;

    public RadioactiveDatingGameModel() {
        Stratum stratum = new Stratum(new Stratum.LayerLine(0.0), new Stratum.LayerLine(3.1666666666666665));
        this._strata.add(stratum);
        int n = 1;
        while ((double)n < 6.0) {
            stratum = new Stratum(stratum.getBottomLine(), new Stratum.LayerLine((double)(n + 1) * 3.1666666666666665));
            this._strata.add(stratum);
            ++n;
        }
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_HOUSE, "house.png", (Point2D)new Point2D.Double(8.0, 4.0), 6.0, 0.0, HalfLifeInfo.convertYearsToMs(75.0), true));
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_TRILOBYTE, "trilobyte_fossil.png", (Point2D)new Point2D.Double(6.0, -11.25), 2.5, 0.0, HalfLifeInfo.convertYearsToMs(3.096E8), true));
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_ANIMAL_SKULL, "skull_animal.png", (Point2D)new Point2D.Double(-26.0, 2.0), 3.0, 0.7853981633974483, HalfLifeInfo.convertYearsToMs(150.0), true));
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_LIVING_TREE, "tree_1.png", (Point2D)new Point2D.Double(-21.0, 5.0), 5.5, 0.0, 0.0, true));
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_DISTANT_LIVING_TREE, "tree_1.png", (Point2D)new Point2D.Double(0.0, 3.5), 2.0, 0.0, 0.0, true));
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_FISH_FOSSIL_1, "fish_fossil.png", (Point2D)new Point2D.Double(-20.0, -8.0), 7.0, 0.0, HalfLifeInfo.convertYearsToMs(2.8E7), true));
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_DEAD_TREE, "tree_dead_no_space.png", (Point2D)new Point2D.Double(23.0, 2.5), 3.0, 1.5707963267948966, HalfLifeInfo.convertYearsToMs(220.0), true));
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_FISH_FOSSIL_2, "fish_bones.png", (Point2D)new Point2D.Double(10.0, -4.5), 5.0, 0.0, HalfLifeInfo.convertYearsToMs(16000.0), true));
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_ROCK1, "rock_1.png", (Point2D)new Point2D.Double(-4.0, -8.0), 3.0, 0.0, HalfLifeInfo.convertYearsToMs(1.37E8), false));
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_ROCK2, "rock_2.png", (Point2D)new Point2D.Double(-15.0, -11.0), 1.5, 0.0, HalfLifeInfo.convertYearsToMs(2.61E8), false));
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_ROCK3, "rock_3.png", (Point2D)new Point2D.Double(-20.0, -14.5), 2.25, 0.0, HalfLifeInfo.convertYearsToMs(4.485E8), false));
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_ROCK4, "rock_4.png", (Point2D)new Point2D.Double(-5.0, -14.5), 1.5, 0.0, HalfLifeInfo.convertYearsToMs(7.23E8), false));
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_ROCK5, "rock_6.png", (Point2D)new Point2D.Double(16.0, -14.5), 2.0, 0.0, HalfLifeInfo.convertYearsToMs(1.25E9), false));
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_DINOSAUR_SKULL, "dinosaur_skull.png", (Point2D)new Point2D.Double(14.0, -7.5), 4.0, 0.0, HalfLifeInfo.convertYearsToMs(1.55E8), true));
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_HUMAN_SKULL, "skull_human.png", (Point2D)new Point2D.Double(20.0, -1.5), 2.4, 0.0, HalfLifeInfo.convertYearsToMs(2200.0), true));
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_WOODEN_CUP, "cup.png", (Point2D)new Point2D.Double(3.0, -1.85), 1.7, -1.0471975511965976, HalfLifeInfo.convertYearsToMs(1035.0), true));
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_BONE, "bone.png", (Point2D)new Point2D.Double(-18.0, -1.5), 3.5, 0.0, HalfLifeInfo.convertYearsToMs(1450.0), true));
        this._datableObjects.add(new DatableItem(NuclearPhysicsStrings.DATABLE_ITEM_HUMAN_SKULL, "skull_human.png", (Point2D)new Point2D.Double(-10.0, -4.5), 2.0, 1.0, HalfLifeInfo.convertYearsToMs(40000.0), true));
        this._meter = new RadiometricDatingMeter(this);
        this._meter.getProbeModel().addObserver(new SimpleObserver(){

            public void update() {
                RadioactiveDatingGameModel.this.getDatableItemAtLocation(RadioactiveDatingGameModel.this._meter.getProbeModel().getTipLocation());
            }
        });
    }

    public Iterable<DatableItem> getItemIterable() {
        return this._datableObjects;
    }

    public Iterable<Stratum> getStratumIterable() {
        return this._strata;
    }

    public int getLayerCount() {
        return this._strata.size();
    }

    public Stratum getLayer(int n) {
        return this._strata.get(n);
    }

    public RadiometricDatingMeter getMeter() {
        return this._meter;
    }

    @Override
    public ConstantDtClock getClock() {
        return null;
    }

    public double getBottomOfStrata() {
        double d = 0.0;
        for (Stratum stratum : this._strata) {
            if (!(stratum.getBottomOfStratumY() < d)) continue;
            d = stratum.getBottomOfStratumY();
        }
        return d;
    }

    public double getTopOfStrata() {
        double d = Double.NEGATIVE_INFINITY;
        for (Stratum stratum : this._strata) {
            if (!(stratum.getTopOfStratumY() > d)) continue;
            d = stratum.getTopOfStratumY();
        }
        return d;
    }

    @Override
    public DatableItem getDatableItemAtLocation(Point2D point2D) {
        DatableItem datableItem = null;
        for (DatableItem datableItem2 : this._datableObjects) {
            if (!datableItem2.contains(point2D)) continue;
            datableItem = datableItem2;
        }
        return datableItem;
    }

    @Override
    public DatableItem getDatableAir() {
        return DatableItem.DATABLE_AIR;
    }
}

