/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.AnimatedDatableItem;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.AnimationSequence;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.ModelAnimationDelta;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadiometricClosureState;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.StaticAnimatedDatableItem;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.StaticAnimationSequence;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class EruptingVolcano
extends StaticAnimatedDatableItem {
    private static final double PRE_ERUPTION_INITIAL_AGE = HalfLifeInfo.convertYearsToMs(1.0E9);

    public EruptingVolcano(ConstantDtClock constantDtClock, Point2D point2D, double d, double d2) {
        super("Volcano", Arrays.asList("volcano_cool.png", "volcano_hot.png"), point2D, d, 0.0, 0.0, constantDtClock, d2, false);
    }

    protected AnimationSequence createAnimationSequence() {
        double d;
        double d2;
        int n;
        double d3;
        int n2;
        AnimatedDatableItem.TimeUpdater timeUpdater = new AnimatedDatableItem.TimeUpdater(0.0, HalfLifeInfo.convertHoursToMs(10.0));
        ArrayList<ModelAnimationDelta> arrayList = new ArrayList<ModelAnimationDelta>();
        Random random = new Random();
        double d4 = 0.3;
        double d5 = 0.1;
        Point2D.Double double_ = new Point2D.Double();
        int n3 = 10;
        for (n2 = 0; n2 < n3 / 2; ++n2) {
            d3 = d4 * random.nextDouble();
            double d6 = d5 * random.nextDouble();
            double_.setLocation(d3, d6);
            arrayList.add(new ModelAnimationDelta(timeUpdater.updateTime(), double_, 0.0, 1.0, 0, 0, 0.0, null));
            double_.setLocation(-d3, -d6);
            arrayList.add(new ModelAnimationDelta(timeUpdater.updateTime(), double_, 0.0, 1.0, 0, 0, 0.0, null));
        }
        arrayList.add(new ModelAnimationDelta(timeUpdater.updateTime(), null, 0.0, 1.0, 0, 0, 0.0, new AnimatedDatableItem.RadiometricClosureEvent(this, RadiometricClosureState.CLOSURE_POSSIBLE)));
        n2 = 60;
        d3 = 1.0 / (double)n2;
        for (n = 0; n < n2; n += 2) {
            d2 = d4 * random.nextDouble();
            d = d5 * random.nextDouble();
            double_.setLocation(d2, d);
            arrayList.add(new ModelAnimationDelta(timeUpdater.updateTime(), double_, 0.0, 1.0, 0, 0, d3, null));
            double_.setLocation(-d2, -d);
            arrayList.add(new ModelAnimationDelta(timeUpdater.updateTime(), double_, 0.0, 1.0, 0, 0, d3, null));
        }
        n3 = 90;
        for (n = 0; n < n3 / 2; ++n) {
            d2 = d4 * random.nextDouble();
            d = d5 * random.nextDouble();
            double_.setLocation(d2, d);
            arrayList.add(new ModelAnimationDelta(timeUpdater.updateTime(), double_, 0.0, 1.0, 0, 0, 0.0, null));
            double_.setLocation(-d2, -d);
            arrayList.add(new ModelAnimationDelta(timeUpdater.updateTime(), double_, 0.0, 1.0, 0, 0, 0.0, null));
        }
        n2 = 70;
        d3 = -1.0 / (double)n2;
        for (n = 0; n < n2; ++n) {
            arrayList.add(new ModelAnimationDelta(timeUpdater.updateTime(), null, 0.0, 1.0, 0, 0, d3, null));
        }
        arrayList.add(new ModelAnimationDelta(timeUpdater.updateTime(), null, 0.0, 1.0, 0, 0, 0.0, new AnimatedDatableItem.RadiometricClosureEvent(this, RadiometricClosureState.CLOSED)));
        return new StaticAnimationSequence(arrayList);
    }

    public double getRadiometricAge() {
        double d = this.getClosureState() == RadiometricClosureState.CLOSURE_NOT_POSSIBLE ? PRE_ERUPTION_INITIAL_AGE + this.getTotalAge() : (this.getClosureState() == RadiometricClosureState.CLOSURE_POSSIBLE ? 0.0 : super.getRadiometricAge());
        return d;
    }
}

