/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.DatableItem;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadiometricClosureState;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnimatedDatableItem
extends DatableItem {
    private final ConstantDtClock _clock;
    private final ClockAdapter _clockAdapter;
    private final double _birthTime;
    private final ArrayList<ClosureListener> _closureListeners = new ArrayList();
    private double _timeConversionFactor;
    private double _age = 0.0;
    private RadiometricClosureState _closureState = RadiometricClosureState.CLOSURE_NOT_POSSIBLE;
    private double _closureAge = 0.0;

    public AnimatedDatableItem(String string, List<String> list, Point2D point2D, double d, double d2, double d3, ConstantDtClock constantDtClock, double d4, boolean bl) {
        super(string, list, point2D, d, d2, d3, bl);
        this._clock = constantDtClock;
        this._birthTime = this._clock.getSimulationTime() * d4;
        this._timeConversionFactor = d4;
        this._clockAdapter = new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                AnimatedDatableItem.this.handleClockTicked(clockEvent);
            }

            public void simulationTimeReset(ClockEvent clockEvent) {
                AnimatedDatableItem.this.handleSimulationTimeReset();
            }
        };
        this._clock.addClockListener(this._clockAdapter);
    }

    protected void handleAnimationEvent(EventObject eventObject) {
        if (eventObject instanceof RadiometricClosureEvent) {
            this.setClosureState(((RadiometricClosureEvent)eventObject).getClosureState());
        }
    }

    public void forceClosure() {
        this.setClosureState(RadiometricClosureState.CLOSED);
    }

    public RadiometricClosureState getClosureState() {
        return this._closureState;
    }

    protected void setClosureState(RadiometricClosureState radiometricClosureState) {
        if (this._closureState != radiometricClosureState) {
            this._closureState = radiometricClosureState;
            if (radiometricClosureState == RadiometricClosureState.CLOSED) {
                this._closureAge = this._age;
            }
            this.notifyClosureStateChanged();
        }
    }

    public void addClosureListener(ClosureListener closureListener) {
        if (!this._closureListeners.contains(closureListener)) {
            this._closureListeners.add(closureListener);
        }
    }

    public void removeClosureListener(ClosureListener closureListener) {
        this._closureListeners.remove(closureListener);
    }

    public void setTimeConversionFactor(double d) {
        this._timeConversionFactor = d;
    }

    public double getTimeConversionFactor() {
        return this._timeConversionFactor;
    }

    private void notifyClosureStateChanged() {
        for (ClosureListener closureListener : this._closureListeners) {
            closureListener.closureStateChanged(this);
        }
    }

    protected void handleClockTicked(ClockEvent clockEvent) {
        this._age += clockEvent.getSimulationTimeChange() * this._timeConversionFactor;
    }

    protected ConstantDtClock getClock() {
        return this._clock;
    }

    protected double getBirthTime() {
        return this._birthTime;
    }

    protected void handleSimulationTimeReset() {
        this._age = 0.0;
    }

    @Override
    public double getRadiometricAge() {
        if (this._closureState != RadiometricClosureState.CLOSED) {
            return 0.0;
        }
        if (this._age < this._closureAge) {
            System.err.println(this.getClass().getName() + " - Error: Age is less than closure age.");
            assert (false);
        }
        return this._age - this._closureAge;
    }

    public double getTotalAge() {
        return this._age;
    }

    public static interface ClosureListener {
        public void closureStateChanged(AnimatedDatableItem var1);
    }

    public static class RadiometricClosureEvent
    extends EventObject {
        private final RadiometricClosureState closureState;

        public RadiometricClosureEvent(Object object, RadiometricClosureState radiometricClosureState) {
            super(object);
            this.closureState = radiometricClosureState;
        }

        public RadiometricClosureState getClosureState() {
            return this.closureState;
        }
    }

    public static class TimeUpdater {
        private double time;
        private double dt;

        public TimeUpdater(double d, double d2) {
            this.time = d;
            this.dt = d2;
        }

        double updateTime() {
            this.time += this.dt;
            return this.time;
        }
    }
}

