/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsResources;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;

public class AgeGuessResultNode
extends PNode {
    private static final Font TEXT_FONT = new PhetFont(20);
    private static final Color FILL_COLOR_BAD_GUESS = Color.RED;
    private static final Color FILL_COLOR_GOOD_GUESS = Color.GREEN;
    private final boolean _guessIsGood;
    private final PPath _backgoundRect;
    private final PImage _icon;
    private final ArrayList<Listener> _listeners = new ArrayList();

    public AgeGuessResultNode(double d, boolean bl) {
        this._guessIsGood = bl;
        PText pText = new PText();
        pText.setFont(TEXT_FONT);
        pText.setText(NumberFormat.getNumberInstance().format(d) + " " + NuclearPhysicsStrings.READOUT_UNITS_YRS);
        this._backgoundRect = new PPath(new Rectangle2D.Double(0.0, 0.0, pText.getFullBoundsReference().width * 1.2, pText.getFullBoundsReference().height * 1.3));
        this._backgoundRect.setPaint(this._guessIsGood ? FILL_COLOR_GOOD_GUESS : FILL_COLOR_BAD_GUESS);
        this.addChild(this._backgoundRect);
        this.addChild(pText);
        pText.setOffset(this._backgoundRect.getFullBoundsReference().width / 2.0 - pText.getFullBoundsReference().width / 2.0, this._backgoundRect.getFullBoundsReference().height / 2.0 - pText.getFullBoundsReference().height / 2.0);
        this._icon = this._guessIsGood ? NuclearPhysicsResources.getImageNode("happy_face.png") : NuclearPhysicsResources.getImageNode("frowny_face.png");
        this._icon.setScale(this._backgoundRect.getFullBoundsReference().height / this._icon.getFullBoundsReference().height);
        this._icon.setOffset(this._backgoundRect.getFullBoundsReference().getMaxX() + 3.0, 0.0);
        this.addChild(this._icon);
        this.setPickable(true);
        this.setChildrenPickable(true);
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseReleased(PInputEvent pInputEvent) {
                AgeGuessResultNode.this.notifyCleared();
            }
        });
        this.addInputEventListener(new CursorHandler(CursorHandler.HAND));
    }

    public boolean isGuessGood() {
        return this._guessIsGood;
    }

    private void notifyCleared() {
        for (Listener listener : this._listeners) {
            listener.userCleared(this);
        }
    }

    public void addListener(Listener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public static interface Listener {
        public void userCleared(AgeGuessResultNode var1);
    }
}

