/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.nuclearreactor;

import edu.colorado.phet.nuclearphysics.common.model.Nucleon;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class ControlRod {
    Rectangle2D _rect;
    ArrayList _listeners = new ArrayList();

    ControlRod(double d, double d2, double d3, double d4) {
        this._rect = new Rectangle2D.Double(d, d2, d3, d4);
    }

    public Rectangle2D getRectangleReference() {
        return this._rect;
    }

    public void setPosition(double d) {
        if (d != this._rect.getY()) {
            this._rect.setRect(this._rect.getX(), d, this._rect.getWidth(), this._rect.getHeight());
            this.notifyPositionChanged();
        }
    }

    public Point2D getPosition() {
        return new Point2D.Double(this._rect.getX(), this._rect.getY());
    }

    public boolean particleAbsorbed(Nucleon nucleon) {
        return this._rect.contains(nucleon.getPosition());
    }

    public void addListener(Listener listener) {
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
    }

    private void notifyPositionChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).positionChanged();
        }
    }

    public static interface Listener {
        public void positionChanged();
    }
}

