/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.decayrates;

import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.module.decayrates.DecayRatesCanvas;
import edu.colorado.phet.nuclearphysics.module.decayrates.DecayRatesModel;
import edu.colorado.phet.nuclearphysics.module.halflife.IsotopeSelectionControlPanel;
import java.awt.Frame;

public class DecayRatesModule
extends PiccoloModule {
    private DecayRatesModel _model;
    private DecayRatesCanvas _canvas;
    private IsotopeSelectionControlPanel _controlPanel;

    public DecayRatesModule(Frame frame) {
        super(NuclearPhysicsStrings.TITLE_LOTS_OF_NUCLEI_DECAYING, new NuclearPhysicsClock(25, 40.0));
        NuclearPhysicsClock nuclearPhysicsClock = (NuclearPhysicsClock)this.getClock();
        this._model = new DecayRatesModel(nuclearPhysicsClock);
        this._canvas = new DecayRatesCanvas(this._model);
        this.setSimulationPanel(this._canvas);
        this._controlPanel = new IsotopeSelectionControlPanel(this, frame, this._model, false);
        this.setControlPanel(this._controlPanel);
        if (this.hasHelp()) {
            // empty if block
        }
        this.reset();
    }

    public void reset() {
        this._model.getClock().resetSimulationTime();
        this._model.reset();
        this.setClockRunningWhenActive(true);
    }
}

