/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.chainreaction;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.Nucleon;
import edu.colorado.phet.nuclearphysics.common.model.SubatomicParticle;
import edu.colorado.phet.nuclearphysics.model.ContainmentVessel;
import edu.colorado.phet.nuclearphysics.model.DaughterNucleus;
import edu.colorado.phet.nuclearphysics.model.NeutronSource;
import edu.colorado.phet.nuclearphysics.model.Uranium235Nucleus;
import edu.colorado.phet.nuclearphysics.model.Uranium238Nucleus;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class ChainReactionModel {
    private static final Rectangle2D NEUTRON_SOURCE_OFF_LIMITS_RECT = new Rectangle2D.Double(-120.0, -20.0, 80.0, 50.0);
    private static final MutableVector2D ZERO_ACCELERATION = new MutableVector2D(0.0, 0.0);
    private NuclearPhysicsClock _clock;
    private ArrayList _listeners = new ArrayList();
    private ArrayList _u235Nuclei = new ArrayList();
    private ArrayList _u238Nuclei = new ArrayList();
    private ArrayList _daughterNuclei = new ArrayList();
    private ArrayList _u239Nuclei = new ArrayList();
    private ArrayList<Nucleon> _freeNeutrons = new ArrayList();
    private ArrayList _containedElements = new ArrayList();
    private Random _rand = new Random();
    private NeutronSource _neutronSource;
    private ContainmentVessel _containmentVessel;
    private int _ghostDaughterNuclei = 0;

    public ChainReactionModel(NuclearPhysicsClock nuclearPhysicsClock) {
        this._clock = nuclearPhysicsClock;
        nuclearPhysicsClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                ChainReactionModel.this.handleClockTicked(clockEvent);
            }

            public void simulationTimeReset(ClockEvent clockEvent) {
                ChainReactionModel.this.reset();
            }
        });
        this._neutronSource = new NeutronSource(-50.0, 0.0);
        this._neutronSource.addListener(new NeutronSource.Adapter(){

            public void neutronGenerated(Nucleon nucleon) {
                ChainReactionModel.this._freeNeutrons.add(nucleon);
                ChainReactionModel.this.notifyModelElementAdded(nucleon);
            }

            public void positionChanged() {
            }
        });
        this._neutronSource.setFiringAngle(-0.07);
        this._containmentVessel = new ContainmentVessel(66.66666666666667);
        this._containmentVessel.addListener(new ContainmentVessel.Adapter(){

            public void explosionOccurred() {
                ChainReactionModel.this.handleContainmentVesselExplosion();
            }

            public void enableStateChanged(boolean bl) {
                ChainReactionModel.this.handleContainmentVesselStateChange(bl);
            }

            public void radiusChanged(double d) {
                ChainReactionModel.this.handleContainmentVesselRadiusChanged(d);
            }
        });
    }

    public ConstantDtClock getClock() {
        return this._clock;
    }

    public NeutronSource getNeutronSource() {
        return this._neutronSource;
    }

    public ContainmentVessel getContainmentVessel() {
        return this._containmentVessel;
    }

    public int getNumU235Nuclei() {
        return this._u235Nuclei.size();
    }

    public int getNumU238Nuclei() {
        int n = 0;
        int n2 = this._u238Nuclei.size();
        for (int i = 0; i < n2; ++i) {
            Uranium238Nucleus uranium238Nucleus = (Uranium238Nucleus)this._u238Nuclei.get(i);
            if (uranium238Nucleus.getNumNeutrons() != 146) continue;
            ++n;
        }
        return n;
    }

    public ArrayList getNuclei() {
        ArrayList arrayList = new ArrayList(this._u235Nuclei.size() + this._u238Nuclei.size() + this._daughterNuclei.size() + this._u239Nuclei.size());
        arrayList.addAll(this._u235Nuclei);
        arrayList.addAll(this._u238Nuclei);
        arrayList.addAll(this._daughterNuclei);
        arrayList.addAll(this._u239Nuclei);
        return arrayList;
    }

    public double getPercentageU235Fissioned() {
        double d = 0.0;
        double d2 = 0.0;
        Iterator iterator = this._u235Nuclei.iterator();
        while (iterator.hasNext()) {
            d += 1.0;
            AtomicNucleus atomicNucleus = (Uranium235Nucleus)iterator.next();
            if (atomicNucleus.getNumNeutrons() >= 143) continue;
            d2 += 1.0;
        }
        for (AtomicNucleus atomicNucleus : this._daughterNuclei) {
            if (!(atomicNucleus instanceof Uranium235Nucleus) || atomicNucleus.getNumNeutrons() >= 143) continue;
            d2 += 1.0;
        }
        if (d + (d2 += (double)(this._ghostDaughterNuclei / 2)) == 0.0) {
            return 0.0;
        }
        return 100.0 * (d2 / (d + d2));
    }

    public boolean getChangedNucleiExist() {
        return this._daughterNuclei.size() > 0 || this._u239Nuclei.size() > 0 || this._ghostDaughterNuclei > 0;
    }

    public void addListener(Listener listener) {
        assert (!this._listeners.contains(listener));
        this._listeners.add(listener);
    }

    public void reset() {
        this.removeAllParticles();
        this._containmentVessel.reset();
        this.setNumU235Nuclei(1);
        this._neutronSource.setFiringAngle(-0.07);
        this._neutronSource.setPosition(-50.0, 0.0);
        this.notifyPercentFissionedChanged();
        this.notifyResetOccurred();
    }

    public void resetNuclei() {
        int n;
        int n2 = (this._daughterNuclei.size() + this._ghostDaughterNuclei) / 2;
        this.setNumU235Nuclei(this.getNumU235Nuclei() + n2);
        if (this._daughterNuclei.size() > 0) {
            for (n = 0; n < this._daughterNuclei.size(); ++n) {
                this.notifyModelElementRemoved(this._daughterNuclei.get(n));
                ((AtomicNucleus)this._daughterNuclei.get(n)).removedFromModel();
            }
            this._daughterNuclei.clear();
            this.notifyReativeNucleiNumberChanged();
        }
        if (this._ghostDaughterNuclei > 0) {
            this._ghostDaughterNuclei = 0;
            this.notifyReativeNucleiNumberChanged();
        }
        this.notifyPercentFissionedChanged();
        for (n = 0; n < this._freeNeutrons.size(); ++n) {
            this.notifyModelElementRemoved(this._freeNeutrons.get(n));
        }
        this._freeNeutrons.clear();
        if (this._u239Nuclei.size() > 0) {
            for (n = 0; n < this._u239Nuclei.size(); ++n) {
                Uranium238Nucleus uranium238Nucleus = (Uranium238Nucleus)this._u239Nuclei.get(n);
                uranium238Nucleus.reset();
                this._u238Nuclei.add(uranium238Nucleus);
            }
            this._u239Nuclei.clear();
            this.notifyReativeNucleiNumberChanged();
        }
        this._containedElements.clear();
    }

    public int setNumU235Nuclei(int n) {
        if (n != this._u235Nuclei.size()) {
            if (n > this._u235Nuclei.size()) {
                int n2 = this._u235Nuclei.size();
                for (int i = 0; i < n - n2; ++i) {
                    Point2D point2D = null;
                    point2D = this._u235Nuclei.size() == 0 ? new Point2D.Double(0.0, 0.0) : this.findOpenNucleusLocation();
                    if (point2D == null) continue;
                    Uranium235Nucleus uranium235Nucleus = new Uranium235Nucleus(this._clock, point2D, 0.0);
                    this._u235Nuclei.add(uranium235Nucleus);
                    this.notifyModelElementAdded(uranium235Nucleus);
                    uranium235Nucleus.addListener(new AtomicNucleus.Adapter(){

                        public void nucleusChangeEvent(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
                            ChainReactionModel.this.handleAtomicWeightChange(atomicNucleus, n, n2, arrayList);
                        }
                    });
                    this.notifyReativeNucleiNumberChanged();
                }
                this._containmentVessel.resetImpactAccumulation();
            } else {
                int n3 = this._u235Nuclei.size() - n;
                for (int i = 0; i < n3; ++i) {
                    if (this._u235Nuclei.size() <= 0) continue;
                    Object e = this._u235Nuclei.get(this._u235Nuclei.size() - 1);
                    this._u235Nuclei.remove(e);
                    this.notifyModelElementRemoved(e);
                    this.notifyReativeNucleiNumberChanged();
                }
            }
        }
        this.notifyPercentFissionedChanged();
        return this._u235Nuclei.size();
    }

    public int setNumU238Nuclei(int n) {
        block4: {
            if (n == this._u238Nuclei.size()) break block4;
            if (n > this._u238Nuclei.size()) {
                for (int i = 0; i < n - this._u238Nuclei.size(); ++i) {
                    Point2D point2D = this.findOpenNucleusLocation();
                    if (point2D == null) continue;
                    Uranium238Nucleus uranium238Nucleus = new Uranium238Nucleus(this._clock, point2D);
                    this._u238Nuclei.add(uranium238Nucleus);
                    this.notifyModelElementAdded(uranium238Nucleus);
                    uranium238Nucleus.addListener(new AtomicNucleus.Adapter(){

                        public void nucleusChangeEvent(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
                            ChainReactionModel.this.handleAtomicWeightChange(atomicNucleus, n, n2, arrayList);
                        }
                    });
                    this.notifyReativeNucleiNumberChanged();
                }
            } else {
                int n2 = this._u238Nuclei.size() - n;
                for (int i = 0; i < n2; ++i) {
                    if (this._u238Nuclei.size() <= 0) continue;
                    Object e = this._u238Nuclei.get(this._u238Nuclei.size() - 1);
                    this._u238Nuclei.remove(e);
                    this.notifyModelElementRemoved(e);
                    this.notifyReativeNucleiNumberChanged();
                }
            }
        }
        return this._u238Nuclei.size();
    }

    public void removeDecayedU235Nuclei() {
        if (this._daughterNuclei.size() > 0) {
            Iterator iterator = this._daughterNuclei.iterator();
            while (iterator.hasNext()) {
                AtomicNucleus atomicNucleus = (AtomicNucleus)iterator.next();
                iterator.remove();
                this.notifyModelElementRemoved(atomicNucleus);
                if (!this._containedElements.contains(atomicNucleus)) continue;
                this._containedElements.remove(atomicNucleus);
            }
            this.notifyReativeNucleiNumberChanged();
        }
        if (this._ghostDaughterNuclei > 0) {
            this._ghostDaughterNuclei = 0;
            this.notifyReativeNucleiNumberChanged();
        }
    }

    private void handleClockTicked(ClockEvent clockEvent) {
        int n = this._freeNeutrons.size();
        for (int i = n - 1; i >= 0; --i) {
            AtomicNucleus atomicNucleus;
            int n2;
            Nucleon nucleon = this._freeNeutrons.get(i);
            assert (nucleon instanceof Nucleon);
            nucleon.translate();
            boolean bl = false;
            int n3 = this._u235Nuclei.size();
            for (n2 = 0; n2 < n3 && !bl; ++n2) {
                atomicNucleus = (AtomicNucleus)this._u235Nuclei.get(n2);
                if (!(nucleon.getPositionReference().distance(atomicNucleus.getPositionReference()) <= atomicNucleus.getDiameter() / 2.0)) continue;
                bl = atomicNucleus.captureParticle(nucleon);
            }
            n3 = this._u238Nuclei.size();
            for (n2 = 0; n2 < n3 && !bl; ++n2) {
                atomicNucleus = (AtomicNucleus)this._u238Nuclei.get(n2);
                if (!(nucleon.getPositionReference().distance(atomicNucleus.getPositionReference()) <= atomicNucleus.getDiameter() / 2.0)) continue;
                bl = atomicNucleus.captureParticle(nucleon);
            }
            if (bl) {
                this._freeNeutrons.remove(i);
                this.notifyModelElementRemoved(nucleon);
                continue;
            }
            if (this._containedElements.contains(nucleon) || !this._containmentVessel.isPositionContained(nucleon.getPositionReference())) continue;
            this._containmentVessel.recordImpact(1.0);
            this._freeNeutrons.remove(i);
            this.notifyModelElementRemoved(nucleon);
        }
        if (this._containmentVessel.getIsEnabled()) {
            this.checkContainment(this._u235Nuclei);
            this.checkContainment(this._daughterNuclei);
        }
        this.removeOutOfRangeElements();
    }

    private void removeAllParticles() {
        int n;
        for (n = 0; n < this._freeNeutrons.size(); ++n) {
            this.notifyModelElementRemoved(this._freeNeutrons.get(n));
        }
        this._freeNeutrons.clear();
        for (n = 0; n < this._u235Nuclei.size(); ++n) {
            this.notifyModelElementRemoved(this._u235Nuclei.get(n));
            ((AtomicNucleus)this._u235Nuclei.get(n)).removedFromModel();
        }
        this._u235Nuclei.clear();
        for (n = 0; n < this._u238Nuclei.size(); ++n) {
            this.notifyModelElementRemoved(this._u238Nuclei.get(n));
            ((AtomicNucleus)this._u238Nuclei.get(n)).removedFromModel();
        }
        this._u238Nuclei.clear();
        for (n = 0; n < this._daughterNuclei.size(); ++n) {
            this.notifyModelElementRemoved(this._daughterNuclei.get(n));
            ((AtomicNucleus)this._daughterNuclei.get(n)).removedFromModel();
        }
        this._daughterNuclei.clear();
        for (n = 0; n < this._u239Nuclei.size(); ++n) {
            this.notifyModelElementRemoved(this._u239Nuclei.get(n));
            ((AtomicNucleus)this._u239Nuclei.get(n)).removedFromModel();
        }
        this._u239Nuclei.clear();
        this._ghostDaughterNuclei = 0;
        this._containedElements.clear();
    }

    private Point2D findOpenNucleusLocation() {
        for (int i = 0; i < 100; ++i) {
            int n;
            double d = 200.0 * (this._rand.nextDouble() - 0.5);
            double d2 = 150.0 * (this._rand.nextDouble() - 0.5);
            Point2D.Double double_ = new Point2D.Double(d, d2);
            boolean bl = true;
            if (this._containmentVessel.getIsEnabled() && Point2D.distance(d, d2, 0.0, 0.0) > this._containmentVessel.getRadius() - 12.0) {
                bl = false;
            }
            if (NEUTRON_SOURCE_OFF_LIMITS_RECT.contains(double_)) {
                bl = false;
            }
            for (n = 0; n < this._u235Nuclei.size() && bl; ++n) {
                if (!(double_.distance(((AtomicNucleus)this._u235Nuclei.get(n)).getPositionReference()) < 12.0)) continue;
                bl = false;
            }
            for (n = 0; n < this._u238Nuclei.size() && bl; ++n) {
                if (!(double_.distance(((AtomicNucleus)this._u238Nuclei.get(n)).getPositionReference()) < 12.0)) continue;
                bl = false;
            }
            for (n = 0; n < this._u239Nuclei.size() && bl; ++n) {
                if (!(double_.distance(((AtomicNucleus)this._u239Nuclei.get(n)).getPositionReference()) < 12.0)) continue;
                bl = false;
            }
            if (!bl) continue;
            return double_;
        }
        return null;
    }

    private void checkContainment(ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            AtomicNucleus atomicNucleus = (AtomicNucleus)arrayList.get(i);
            if (atomicNucleus.getVelocity().magnitude() == 0.0 || !this._containmentVessel.isPositionContained(atomicNucleus.getPositionReference())) continue;
            atomicNucleus.setAcceleration(ZERO_ACCELERATION);
            atomicNucleus.setVelocity(0.0, 0.0);
            atomicNucleus.setPosition(this._containmentVessel.getNearestContainmentPoint(atomicNucleus.getPositionReference()));
            this._containedElements.add(atomicNucleus);
            this._containmentVessel.recordImpact(10.0);
            if (this._containmentVessel.getIsExploded()) break;
        }
    }

    private void removeOutOfRangeElements() {
        Object object;
        int n;
        int n2 = this._freeNeutrons.size();
        for (n = n2 - 1; n >= 0; --n) {
            object = this._freeNeutrons.get(n);
            if (!(Math.abs(((SubatomicParticle)object).getPositionReference().getX()) > 200.0) && !(Math.abs(((SubatomicParticle)object).getPositionReference().getY()) > 150.0)) continue;
            this._freeNeutrons.remove(n);
            this.notifyModelElementRemoved(object);
        }
        n2 = this._daughterNuclei.size();
        for (n = n2 - 1; n >= 0; --n) {
            object = (AtomicNucleus)this._daughterNuclei.get(n);
            if (!(Math.abs(((AtomicNucleus)object).getPositionReference().getX()) > 200.0) && !(Math.abs(((AtomicNucleus)object).getPositionReference().getY()) > 150.0)) continue;
            this._daughterNuclei.remove(n);
            ((AtomicNucleus)object).removedFromModel();
            this.notifyModelElementRemoved(object);
            ++this._ghostDaughterNuclei;
        }
    }

    private void handleContainmentVesselExplosion() {
        this.removeContainedParticles();
    }

    private void handleContainmentVesselStateChange(boolean bl) {
        if (bl) {
            this.removeAllParticles();
            this.setNumU235Nuclei(1);
        } else {
            this.removeContainedParticles();
        }
    }

    private void handleContainmentVesselRadiusChanged(double d) {
        this.removeNucleiOutsideContainmentVessel(this._u235Nuclei);
        this.removeNucleiOutsideContainmentVessel(this._u238Nuclei);
        this.removeContainedParticles();
    }

    private void removeNucleiOutsideContainmentVessel(ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = n - 1; i >= 0; --i) {
            AtomicNucleus atomicNucleus = (AtomicNucleus)arrayList.get(i);
            if (!(atomicNucleus.getPositionReference().distance(0.0, 0.0) > this._containmentVessel.getRadius() - 12.0)) continue;
            atomicNucleus.removedFromModel();
            arrayList.remove(i);
            this.notifyModelElementRemoved(atomicNucleus);
            this.notifyReativeNucleiNumberChanged();
        }
    }

    private void removeContainedParticles() {
        int n = this._containedElements.size();
        for (int i = n - 1; i >= 0; --i) {
            Object e = this._containedElements.get(i);
            this._containedElements.remove(i);
            this.notifyModelElementRemoved(e);
            if (e instanceof Uranium235Nucleus) {
                if (!this._u235Nuclei.remove(e)) {
                    this._daughterNuclei.remove(e);
                }
                ++this._ghostDaughterNuclei;
                continue;
            }
            if (e instanceof DaughterNucleus) {
                this._daughterNuclei.remove(e);
                ++this._ghostDaughterNuclei;
                continue;
            }
            System.err.println("Error: Unexpected model element type contained by containment vessel.");
            assert (false);
        }
    }

    private void notifyModelElementRemoved(Object object) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).modelElementRemoved(object);
        }
    }

    private void notifyModelElementAdded(Object object) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).modelElementAdded(object);
        }
    }

    private void notifyPercentFissionedChanged() {
        double d = this.getPercentageU235Fissioned();
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).percentageU235FissionedChanged(d);
        }
    }

    private void notifyReativeNucleiNumberChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).reactiveNucleiNumberChanged();
        }
    }

    private void notifyResetOccurred() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).resetOccurred();
        }
    }

    private void handleAtomicWeightChange(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Object e = arrayList.get(i);
                if (e instanceof Nucleon) {
                    this.notifyModelElementAdded(e);
                    double d = this._rand.nextDouble() * Math.PI * 2.0;
                    double d2 = Math.sin(d) * 3.0;
                    double d3 = Math.cos(d) * 3.0;
                    ((Nucleon)e).setVelocity(d2, d3);
                    this._freeNeutrons.add((Nucleon)e);
                    continue;
                }
                if (e instanceof AtomicNucleus) {
                    AtomicNucleus atomicNucleus2 = (AtomicNucleus)e;
                    this._daughterNuclei.add(atomicNucleus2);
                    this.notifyModelElementAdded(atomicNucleus2);
                    double d = this._rand.nextDouble() * Math.PI * 2.0;
                    double d4 = Math.sin(d) * 0.0;
                    double d5 = Math.cos(d) * 0.0;
                    double d6 = Math.sin(d) * 0.2;
                    double d7 = Math.cos(d) * 0.2;
                    atomicNucleus.setVelocity(d4, d5);
                    atomicNucleus.setAcceleration(d6, d7);
                    atomicNucleus2.setVelocity(-d4, -d5);
                    atomicNucleus2.setAcceleration(-d6, -d7);
                    assert (atomicNucleus instanceof Uranium235Nucleus);
                    this._u235Nuclei.remove(atomicNucleus);
                    this._daughterNuclei.add(atomicNucleus);
                    this.notifyPercentFissionedChanged();
                    this.notifyReativeNucleiNumberChanged();
                    continue;
                }
                System.err.println("Error: Unexpected byproduct of decay event.");
                assert (false);
            }
        } else if (atomicNucleus instanceof Uranium238Nucleus && atomicNucleus.getNumNeutrons() == 147) {
            this._u238Nuclei.remove(atomicNucleus);
            this._u239Nuclei.add(atomicNucleus);
            this.notifyReativeNucleiNumberChanged();
        }
    }

    public static class Adapter
    implements Listener {
        public void modelElementAdded(Object object) {
        }

        public void modelElementRemoved(Object object) {
        }

        public void reactiveNucleiNumberChanged() {
        }

        public void percentageU235FissionedChanged(double d) {
        }

        public void resetOccurred() {
        }
    }

    public static interface Listener {
        public void modelElementAdded(Object var1);

        public void modelElementRemoved(Object var1);

        public void reactiveNucleiNumberChanged();

        public void resetOccurred();

        public void percentageU235FissionedChanged(double var1);
    }
}

