/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.betadecay.singlenucleus;

import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.Antineutrino;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.Electron;
import edu.colorado.phet.nuclearphysics.common.model.Nucleon;
import edu.colorado.phet.nuclearphysics.common.model.SubatomicParticle;
import edu.colorado.phet.nuclearphysics.common.view.AbstractAtomicNucleusNode;
import edu.colorado.phet.nuclearphysics.common.view.LabeledExplodingAtomicNucleusNode;
import edu.colorado.phet.nuclearphysics.model.AlphaParticle;
import edu.colorado.phet.nuclearphysics.model.CompositeAtomicNucleus;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import edu.colorado.phet.nuclearphysics.model.NuclearDecayListenerAdapter;
import edu.colorado.phet.nuclearphysics.module.betadecay.singlenucleus.SingleNucleusBetaDecayModel;
import edu.colorado.phet.nuclearphysics.view.AlphaParticleModelNode;
import edu.colorado.phet.nuclearphysics.view.AntineutrinoNode;
import edu.colorado.phet.nuclearphysics.view.AutoPressButtonNode;
import edu.colorado.phet.nuclearphysics.view.ElectronNode;
import edu.colorado.phet.nuclearphysics.view.NucleonNode;
import edu.colorado.phet.nuclearphysics.view.SingleNucleusDecayTimeChart;
import edu.colorado.phet.nuclearphysics.view.SubatomicParticleNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;

public class SingleNucleusBetaDecayCanvas
extends PhetPCanvas {
    private final double CANVAS_WIDTH = 30.0;
    private final double CANVAS_HEIGHT = 22.5;
    private final double WIDTH_TRANSLATION_FACTOR = 0.5;
    private final double HEIGHT_TRANSLATION_FACTOR = 0.6;
    private final double TIME_CHART_VERTICAL_FRACTION = 0.22;
    private final double TIME_CHART_HORIZONTAL_FRACTION = 0.95;
    private SingleNucleusBetaDecayModel _singleNucleusBetaDecayModel;
    private AbstractAtomicNucleusNode _nucleusNode;
    private SingleNucleusDecayTimeChart _betaDecayTimeChart;
    private AutoPressButtonNode _resetButtonNode;
    private PNode _nucleusLayer;
    private PNode _labelLayer;
    private HashMap<SubatomicParticle, SubatomicParticleNode> _mapParticlesToNodes = new HashMap();
    private HashMap<AtomicNucleus, PNode> _mapNucleiToNodes = new HashMap();

    public SingleNucleusBetaDecayCanvas(SingleNucleusBetaDecayModel singleNucleusBetaDecayModel) {
        this._singleNucleusBetaDecayModel = singleNucleusBetaDecayModel;
        this.setWorldTransformStrategy(new PhetPCanvas.RenderingSizeStrategy(this, new PDimension(30.0, 22.5)){

            protected AffineTransform getPreprocessedTransform() {
                return AffineTransform.getTranslateInstance((double)SingleNucleusBetaDecayCanvas.this.getWidth() * 0.5, (double)SingleNucleusBetaDecayCanvas.this.getHeight() * 0.6);
            }
        });
        this._singleNucleusBetaDecayModel.addListener(new NuclearDecayListenerAdapter(){

            public void modelElementAdded(Object object) {
                SingleNucleusBetaDecayCanvas.this.handleModelElementAdded(object);
            }

            public void modelElementRemoved(Object object) {
                SingleNucleusBetaDecayCanvas.this.handleModelElementRemoved(object);
            }

            public void nucleusTypeChanged() {
                SingleNucleusBetaDecayCanvas.this.updateTimeSpanOfChart();
            }
        });
        this._nucleusLayer = new PNode();
        this._nucleusLayer.setPickable(false);
        this._nucleusLayer.setChildrenPickable(false);
        this._nucleusLayer.setVisible(true);
        this.addWorldChild(this._nucleusLayer);
        this._labelLayer = new PNode();
        this.addWorldChild(this._labelLayer);
        this.setBackground(NuclearPhysicsConstants.CANVAS_BACKGROUND);
        this._resetButtonNode = new AutoPressButtonNode(NuclearPhysicsStrings.RESET_NUCLEUS, 22, NuclearPhysicsConstants.CANVAS_RESET_BUTTON_COLOR);
        this.addScreenChild(this._resetButtonNode);
        this._resetButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleNucleusBetaDecayCanvas.this._singleNucleusBetaDecayModel.resetNucleus();
            }
        });
        this._betaDecayTimeChart = new SingleNucleusDecayTimeChart(this._singleNucleusBetaDecayModel);
        this.updateTimeSpanOfChart();
        this.addScreenChild(this._betaDecayTimeChart);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                SingleNucleusBetaDecayCanvas.this._betaDecayTimeChart.componentResized(new PDimension((double)SingleNucleusBetaDecayCanvas.this.getWidth() * 0.95, (double)SingleNucleusBetaDecayCanvas.this.getHeight() * 0.22));
                SingleNucleusBetaDecayCanvas.this._betaDecayTimeChart.setOffset((double)(SingleNucleusBetaDecayCanvas.this.getWidth() / 2) - SingleNucleusBetaDecayCanvas.this._betaDecayTimeChart.getFullBoundsReference().getWidth() / 2.0 - 3.0, 0.0);
                SingleNucleusBetaDecayCanvas.this._resetButtonNode.setOffset(0.82 * (double)SingleNucleusBetaDecayCanvas.this.getWidth() - ((SingleNucleusBetaDecayCanvas)SingleNucleusBetaDecayCanvas.this)._resetButtonNode.getFullBoundsReference().width / 2.0, 0.3 * (double)SingleNucleusBetaDecayCanvas.this.getHeight());
            }
        });
    }

    private void updateTimeSpanOfChart() {
        if (this._singleNucleusBetaDecayModel.getNucleusType() == NucleusType.CARBON_14) {
            this._betaDecayTimeChart.setTimeSpan(HalfLifeInfo.getHalfLifeForNucleusType(this._singleNucleusBetaDecayModel.getNucleusType()) * 2.6);
        } else if (this._singleNucleusBetaDecayModel.getNucleusType() == NucleusType.HYDROGEN_3) {
            this._betaDecayTimeChart.setTimeSpan(HalfLifeInfo.getHalfLifeForNucleusType(this._singleNucleusBetaDecayModel.getNucleusType()) * 3.2);
        } else {
            this._betaDecayTimeChart.setTimeSpan(HalfLifeInfo.getHalfLifeForNucleusType(this._singleNucleusBetaDecayModel.getNucleusType()) * 2.5);
        }
    }

    private void handleModelElementAdded(Object object) {
        if (object instanceof AtomicNucleus) {
            CompositeAtomicNucleus compositeAtomicNucleus = this._singleNucleusBetaDecayModel.getAtomNucleus();
            ArrayList arrayList = compositeAtomicNucleus.getConstituents();
            for (int i = 0; i < arrayList.size(); ++i) {
                PNode pNode;
                Object e = arrayList.get(i);
                if (e instanceof Nucleon) {
                    pNode = new NucleonNode((Nucleon)e);
                    pNode.setVisible(true);
                    this._nucleusLayer.addChild(pNode);
                    continue;
                }
                if (e instanceof AlphaParticle) {
                    pNode = new AlphaParticleModelNode((AlphaParticle)e);
                    pNode.setVisible(true);
                    this._nucleusLayer.addChild(pNode);
                    continue;
                }
                assert (false);
            }
            this._nucleusNode = new LabeledExplodingAtomicNucleusNode(compositeAtomicNucleus, this._singleNucleusBetaDecayModel.getLabelVisibilityModel());
            this._labelLayer.addChild(this._nucleusNode);
            this._mapNucleiToNodes.put(compositeAtomicNucleus, this._nucleusNode);
        } else if (object instanceof Electron) {
            ElectronNode electronNode = new ElectronNode((Electron)object);
            this._mapParticlesToNodes.put((SubatomicParticle)object, electronNode);
            this._nucleusLayer.addChild(electronNode);
        } else if (object instanceof Antineutrino) {
            AntineutrinoNode antineutrinoNode = new AntineutrinoNode((Antineutrino)object);
            this._mapParticlesToNodes.put((SubatomicParticle)object, antineutrinoNode);
            this._nucleusLayer.addChild(antineutrinoNode);
        } else {
            System.err.println(this.getClass().getName() + " - Warning: Unrecognized model element added, unable to create node for canvas.");
        }
    }

    private void handleModelElementRemoved(Object object) {
        if (object instanceof AtomicNucleus) {
            Object object2;
            if (!this._mapNucleiToNodes.containsKey(object)) {
                System.err.println(this.getClass().getName() + " - Error: Removed nucleus not found.");
                assert (false);
            }
            ListIterator listIterator = this._nucleusLayer.getChildrenIterator();
            ArrayList arrayList = new ArrayList();
            while (listIterator.hasNext()) {
                object2 = listIterator.next();
                if (object2 instanceof NucleonNode) {
                    ((NucleonNode)object2).cleanup();
                    arrayList.add(object2);
                    continue;
                }
                if (!(object2 instanceof AlphaParticleModelNode)) continue;
                ((AlphaParticleModelNode)object2).cleanup();
                arrayList.add(object2);
            }
            this._nucleusLayer.removeChildren(arrayList);
            object2 = this._mapNucleiToNodes.get(object);
            if (object2 instanceof LabeledExplodingAtomicNucleusNode) {
                ((AbstractAtomicNucleusNode)object2).cleanup();
            }
            this._labelLayer.removeChild((PNode)object2);
            this._mapNucleiToNodes.remove(object);
        } else if (object instanceof SubatomicParticle) {
            SubatomicParticle subatomicParticle = (SubatomicParticle)object;
            SubatomicParticleNode subatomicParticleNode = this._mapParticlesToNodes.get(subatomicParticle);
            subatomicParticleNode.cleanup();
            this._nucleusLayer.removeChild(subatomicParticleNode);
        } else {
            System.err.println(this.getClass().getName() + " - Error: Unexpected model element type removed from model.");
            assert (false);
        }
    }
}

