/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.betadecay.multinucleus;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.MultiNucleusDecayModel;
import edu.colorado.phet.nuclearphysics.common.model.SubatomicParticle;
import edu.colorado.phet.nuclearphysics.model.Carbon14Nucleus;
import edu.colorado.phet.nuclearphysics.model.HeavyAdjustableHalfLifeNucleus;
import edu.colorado.phet.nuclearphysics.model.Hydrogen3Nucleus;
import edu.colorado.phet.nuclearphysics.model.LightAdjustableHalfLifeNucleus;
import edu.colorado.phet.nuclearphysics.module.betadecay.LabelVisibilityModel;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class MultiNucleusBetaDecayModel
extends MultiNucleusDecayModel {
    static final NucleusType DEFAULT_NUCLEUS_TYPE = NucleusType.HYDROGEN_3;
    private static final Rectangle2D BUCKET_RECT = new Rectangle2D.Double(16.0, 18.0, 18.0, 11.700000000000001);
    protected ArrayList<SubatomicParticle> _emittedParticles = new ArrayList();

    public MultiNucleusBetaDecayModel(NuclearPhysicsClock nuclearPhysicsClock) {
        super(nuclearPhysicsClock, 99, DEFAULT_NUCLEUS_TYPE, true, new LabelVisibilityModel());
    }

    public Rectangle2D getBucketRectRef() {
        return BUCKET_RECT;
    }

    protected void handleClockTicked(ClockEvent clockEvent) {
        super.handleClockTicked(clockEvent);
        for (SubatomicParticle subatomicParticle : this._emittedParticles) {
            subatomicParticle.translate();
        }
    }

    protected void addMaxNuclei() {
        double d = 25.0;
        double d2 = 23.85;
        for (int i = 0; i < this._maxNuclei; ++i) {
            AtomicNucleus atomicNucleus;
            if (this._currentNucleusType == NucleusType.HYDROGEN_3) {
                atomicNucleus = new Hydrogen3Nucleus(this._clock);
            } else if (this._currentNucleusType == NucleusType.CARBON_14) {
                atomicNucleus = new Carbon14Nucleus(this._clock);
            } else if (this._currentNucleusType == NucleusType.LIGHT_CUSTOM) {
                atomicNucleus = new LightAdjustableHalfLifeNucleus(this._clock);
            } else {
                System.err.println(this.getClass().getName() + "Other nuclei not yet implemented.");
                atomicNucleus = new HeavyAdjustableHalfLifeNucleus(this._clock);
            }
            this._atomicNuclei.add(atomicNucleus);
            atomicNucleus.setPosition(d, d2);
            this.notifyModelElementAdded(atomicNucleus);
            this._jitterOffsets[i] = new Point2D.Double();
            atomicNucleus.addListener(this._nucleusListener);
        }
    }

    protected void initializeNucleusListener() {
        this._nucleusListener = new AtomicNucleus.Adapter(){

            public void nucleusChangeEvent(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
                if (arrayList != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Object e = arrayList.get(i);
                        if (e instanceof SubatomicParticle) {
                            MultiNucleusBetaDecayModel.this._emittedParticles.add((SubatomicParticle)e);
                            MultiNucleusBetaDecayModel.this.notifyModelElementAdded(e);
                            continue;
                        }
                        System.err.println("Error: Unexpected byproduct of decay event.");
                        assert (false);
                    }
                }
            }
        };
    }

    protected void removeAllNuclei() {
        super.removeAllNuclei();
        for (int i = 0; i < this._emittedParticles.size(); ++i) {
            this.notifyModelElementRemoved(this._emittedParticles.get(i));
        }
        this._emittedParticles.clear();
    }
}

