/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.betadecay.multinucleus;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.Antineutrino;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.Electron;
import edu.colorado.phet.nuclearphysics.common.model.NuclearDecayControl;
import edu.colorado.phet.nuclearphysics.common.model.SubatomicParticle;
import edu.colorado.phet.nuclearphysics.common.view.AbstractAtomicNucleusNode;
import edu.colorado.phet.nuclearphysics.common.view.AtomicNucleusImageType;
import edu.colorado.phet.nuclearphysics.common.view.GrabbableNucleusImageNode;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import edu.colorado.phet.nuclearphysics.model.NuclearDecayListenerAdapter;
import edu.colorado.phet.nuclearphysics.module.betadecay.multinucleus.MultiNucleusBetaDecayModel;
import edu.colorado.phet.nuclearphysics.module.halflife.AutopressResetButton;
import edu.colorado.phet.nuclearphysics.view.AntineutrinoNode;
import edu.colorado.phet.nuclearphysics.view.AutoPressButtonNode;
import edu.colorado.phet.nuclearphysics.view.BucketOfNucleiNode;
import edu.colorado.phet.nuclearphysics.view.ElectronNode;
import edu.colorado.phet.nuclearphysics.view.MultiNucleusDecayLinearTimeChart;
import edu.colorado.phet.nuclearphysics.view.NucleusImageFactory;
import edu.colorado.phet.nuclearphysics.view.SubatomicParticleNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class MultiNucleusBetaDecayCanvas
extends PhetPCanvas
implements AutopressResetButton {
    private final double CANVAS_WIDTH = 80.0;
    private final double CANVAS_HEIGHT = 60.0;
    private final double WIDTH_TRANSLATION_FACTOR = 0.5;
    private final double HEIGHT_TRANSLATION_FACTOR = 0.45;
    private final double TIME_CHART_VERTICAL_FRACTION = 0.23;
    private final double TIME_CHART_HORIZONTAL_FRACTION = 0.95;
    private static final Color BUCKET_AND_BUTTON_COLOR = new Color(255, 160, 122);
    private MultiNucleusDecayLinearTimeChart _decayTimeChart;
    private AutoPressButtonNode _resetButtonNode;
    private HTMLImageButtonNode _addTenButtonNode;
    private MultiNucleusBetaDecayModel _model;
    private Rectangle2D _bucketRect;
    private BucketOfNucleiNode _bucketNode;
    private HashMap<SubatomicParticle, SubatomicParticleNode> _mapParticlesToNodes = new HashMap();
    private HashMap _mapNucleiToNodes = new HashMap();
    private GrabbableNucleusImageNode.Listener _grabbableNodeListener;
    private Random _rand = new Random();
    private AtomicNucleus.Listener _listenerAdapter;
    private PNode _nucleiLayer;
    private PNode _chartLayer;
    private PhetPPath _nucleusPlacementRect = new PhetPPath(new BasicStroke(0.5f), (Paint)Color.RED);
    private Rectangle2D _nucleusPlacementAreaRect = new Rectangle2D.Double();
    private Rectangle2D _paddedBucketRect = new Rectangle2D.Double();
    private Rectangle2D _paddedResetButtonRect = new Rectangle2D.Double();

    public MultiNucleusBetaDecayCanvas(MultiNucleusBetaDecayModel multiNucleusBetaDecayModel) {
        this._model = multiNucleusBetaDecayModel;
        this.setWorldTransformStrategy(new PhetPCanvas.RenderingSizeStrategy(this, new PDimension(80.0, 60.0)){

            protected AffineTransform getPreprocessedTransform() {
                return AffineTransform.getTranslateInstance((double)MultiNucleusBetaDecayCanvas.this.getWidth() * 0.5, (double)MultiNucleusBetaDecayCanvas.this.getHeight() * 0.45);
            }
        });
        this.setBackground(NuclearPhysicsConstants.CANVAS_BACKGROUND);
        this._model.addListener(new NuclearDecayListenerAdapter(){

            public void modelElementAdded(Object object) {
                MultiNucleusBetaDecayCanvas.this.handleModelElementAdded(object);
            }

            public void modelElementRemoved(Object object) {
                MultiNucleusBetaDecayCanvas.this.handleModelElementRemoved(object);
            }

            public void nucleusTypeChanged() {
                MultiNucleusBetaDecayCanvas.this.handleNucleusTypeChanged();
            }
        });
        this._nucleiLayer = new PNode();
        this.addWorldChild(this._nucleiLayer);
        this._chartLayer = new PNode();
        this.addScreenChild(this._chartLayer);
        this._resetButtonNode = new AutoPressButtonNode(NuclearPhysicsStrings.RESET_ALL_NUCLEI, 22, BUCKET_AND_BUTTON_COLOR);
        this._chartLayer.addChild(this._resetButtonNode);
        this._resetButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiNucleusBetaDecayCanvas.this.resetAllNuclei();
            }
        });
        this._decayTimeChart = new MultiNucleusDecayLinearTimeChart(this._model, this, AtomicNucleusImageType.NUCLEONS_VISIBLE, MultiNucleusDecayLinearTimeChart.YAxisLabelMode.ISOTOPE_SYMBOL);
        this._chartLayer.addChild(this._decayTimeChart);
        this.setTimeSpanForChart();
        this._bucketRect = this._model.getBucketRectRef();
        this._bucketNode = new BucketOfNucleiNode(this._bucketRect.getWidth(), this._bucketRect.getHeight(), BUCKET_AND_BUTTON_COLOR);
        this._nucleiLayer.addChild(this._bucketNode);
        this._bucketNode.setOffset(this._bucketRect.getX(), this._bucketRect.getY());
        this._nucleiLayer.addChild(this._nucleusPlacementRect);
        this._nucleusPlacementRect.setVisible(false);
        this._addTenButtonNode = new HTMLImageButtonNode(NuclearPhysicsStrings.ADD_TEN, new PhetFont(1, 12), BUCKET_AND_BUTTON_COLOR);
        double d = this._bucketRect.getWidth() / this._addTenButtonNode.getFullBoundsReference().width * 0.4;
        this._addTenButtonNode.scale(d);
        this._addTenButtonNode.setOffset(this._bucketRect.getCenterX() - this._addTenButtonNode.getFullBoundsReference().width / 2.0, this._bucketRect.getMaxY());
        this._nucleiLayer.addChild(this._addTenButtonNode);
        this._addTenButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiNucleusBetaDecayCanvas.this.addMultipleNucleiFromBucket(10);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MultiNucleusBetaDecayCanvas.this.update();
            }
        });
        this._grabbableNodeListener = new GrabbableNucleusImageNode.Listener(){

            public void nodeGrabbed(GrabbableNucleusImageNode grabbableNucleusImageNode) {
                MultiNucleusBetaDecayCanvas.this.handleNodeGrabbed(grabbableNucleusImageNode);
            }

            public void nodeReleased(GrabbableNucleusImageNode grabbableNucleusImageNode) {
                MultiNucleusBetaDecayCanvas.this.handleNodeReleased(grabbableNucleusImageNode);
            }
        };
        NucleusImageFactory.getInstance().preGenerateNucleusImages(1, 2, 25.0);
        NucleusImageFactory.getInstance().preGenerateNucleusImages(2, 1, 25.0);
        NucleusImageFactory.getInstance().preGenerateNucleusImages(6, 8, 25.0);
        NucleusImageFactory.getInstance().preGenerateNucleusImages(7, 7, 25.0);
        NucleusImageFactory.getInstance().preGenerateNucleusImages(8, 8, 25.0);
        NucleusImageFactory.getInstance().preGenerateNucleusImages(9, 7, 25.0);
    }

    public void update() {
        super.update();
        this._decayTimeChart.componentResized(new PDimension((double)this.getWidth() * 0.95, (double)this.getHeight() * 0.23));
        this._decayTimeChart.setOffset(((double)this.getWidth() - this._decayTimeChart.getFullBoundsReference().getWidth()) / 2.0 - 3.0, 0.0);
        this._resetButtonNode.setOffset(0.82 * (double)this.getWidth() - this._resetButtonNode.getFullBoundsReference().width / 2.0, 0.3 * (double)this.getHeight());
        PDimension pDimension = new PDimension(this._decayTimeChart.getFullBoundsReference().width, this._decayTimeChart.getFullBoundsReference().height);
        this.getPhetRootNode().screenToWorld(pDimension);
        Dimension2D dimension2D = this.getWorldSize();
        double d = -dimension2D.getWidth() * 0.5 + 2.0;
        double d2 = dimension2D.getWidth() - 4.0;
        double d3 = -dimension2D.getHeight() * 0.45 + ((Dimension2D)pDimension).getHeight() + 2.0;
        double d4 = dimension2D.getHeight() - ((Dimension2D)pDimension).getHeight() - 4.0;
        this._nucleusPlacementAreaRect.setRect(d, d3, d2, d4);
        this._nucleusPlacementRect.setPathTo(this._nucleusPlacementAreaRect);
        PDimension pDimension2 = new PDimension(this._resetButtonNode.getFullBoundsReference().width, this._resetButtonNode.getFullBoundsReference().height);
        this.getPhetRootNode().screenToWorld(pDimension2);
        Point2D point2D = this._resetButtonNode.getOffset();
        this.getPhetRootNode().screenToWorld(point2D);
        d = point2D.getX() - 2.0;
        d2 = ((Dimension2D)pDimension2).getWidth() + 4.0;
        d3 = point2D.getY() - 2.0;
        d4 = ((Dimension2D)pDimension2).getHeight() + 4.0;
        this._paddedResetButtonRect.setRect(d, d3, d2, d4);
        d = this._bucketRect.getX() - 2.0;
        d2 = this._bucketRect.getWidth() + 4.0;
        d3 = this._bucketRect.getY() - 2.0;
        d4 = this._bucketRect.getHeight() + 6.0;
        this._paddedBucketRect.setRect(d, d3, d2, d4);
    }

    public void autoPressResetNucleiButton() {
        this._resetButtonNode.autoPress();
    }

    private void handleModelElementAdded(Object object) {
        if (object instanceof AtomicNucleus) {
            GrabbableNucleusImageNode grabbableNucleusImageNode = new GrabbableNucleusImageNode((AtomicNucleus)object, AtomicNucleusImageType.NUCLEONS_VISIBLE, this._model.getLabelVisibilityModel());
            this._mapNucleiToNodes.put(object, grabbableNucleusImageNode);
            if (this.isNucleusPosInBucketRectangle((AtomicNucleus)object)) {
                grabbableNucleusImageNode.scale(0.6);
                this._bucketNode.addNucleus(grabbableNucleusImageNode);
            }
            grabbableNucleusImageNode.addListener(this._grabbableNodeListener);
        } else if (object instanceof Electron) {
            ElectronNode electronNode = new ElectronNode((Electron)object);
            this._mapParticlesToNodes.put((SubatomicParticle)object, electronNode);
            this._nucleiLayer.addChild(electronNode);
        } else if (object instanceof Antineutrino) {
            AntineutrinoNode antineutrinoNode = new AntineutrinoNode((Antineutrino)object);
            this._mapParticlesToNodes.put((SubatomicParticle)object, antineutrinoNode);
            this._nucleiLayer.addChild(antineutrinoNode);
        } else {
            System.err.println(this.getClass().getName() + " - Warning: Unrecognized model element added, unable to create node for canvas.");
        }
    }

    private void handleModelElementRemoved(Object object) {
        if (object instanceof AtomicNucleus) {
            AbstractAtomicNucleusNode abstractAtomicNucleusNode = (AbstractAtomicNucleusNode)this._mapNucleiToNodes.get(object);
            if (abstractAtomicNucleusNode == null) {
                System.err.println("Error: Could not find node for removed model element.");
            } else {
                ((AtomicNucleus)object).removeListener(this._listenerAdapter);
                if (this._bucketNode.isNodeInBucket(abstractAtomicNucleusNode)) {
                    this._bucketNode.removeNucleus(abstractAtomicNucleusNode);
                } else {
                    this.removeWorldChild(abstractAtomicNucleusNode);
                }
            }
            this._mapNucleiToNodes.remove(object);
        } else if (object instanceof SubatomicParticle) {
            this._nucleiLayer.removeChild(this._mapParticlesToNodes.get(object));
            this._mapParticlesToNodes.remove(object);
        } else {
            System.err.println(this.getClass().getName() + " - Warning: Unrecognized model element removed.");
        }
    }

    private void handleNucleusTypeChanged() {
        this._bucketNode.setNucleusType(this._model.getNucleusType());
        this.setTimeSpanForChart();
    }

    private void resetAllNuclei() {
        Set set = this._mapNucleiToNodes.entrySet();
        for (Map.Entry entry : set) {
            AtomicNucleus atomicNucleus = (AtomicNucleus)entry.getKey();
            atomicNucleus.reset();
            if (this._bucketNode.isNodeInBucket((AbstractAtomicNucleusNode)this._mapNucleiToNodes.get(atomicNucleus)) || !(atomicNucleus instanceof NuclearDecayControl)) continue;
            atomicNucleus.activateDecay();
        }
    }

    public void reset() {
        this._decayTimeChart.reset();
    }

    private boolean isNucleusPosInBucketRectangle(AtomicNucleus atomicNucleus) {
        return this._bucketRect.contains(atomicNucleus.getPositionReference());
    }

    private void transferNodeFromBucketToCanvas(AbstractAtomicNucleusNode abstractAtomicNucleusNode) {
        this._nucleiLayer.addChild(abstractAtomicNucleusNode);
        abstractAtomicNucleusNode.setScale(1.0);
    }

    private void transferNodeFromCanvasToBucket(AbstractAtomicNucleusNode abstractAtomicNucleusNode) {
        abstractAtomicNucleusNode.getNucleusRef().reset();
        this._bucketNode.addNucleusAnimated(abstractAtomicNucleusNode);
    }

    private void handleNodeGrabbed(GrabbableNucleusImageNode grabbableNucleusImageNode) {
        if (this._bucketNode.isNodeInBucket(grabbableNucleusImageNode)) {
            this._bucketNode.removeNucleus(grabbableNucleusImageNode);
            this.transferNodeFromBucketToCanvas(grabbableNucleusImageNode);
        } else {
            grabbableNucleusImageNode.getNucleusRef().setPaused(true);
        }
    }

    private void handleNodeReleased(GrabbableNucleusImageNode grabbableNucleusImageNode) {
        if (this.isNucleusPosInBucketRectangle(grabbableNucleusImageNode.getNucleusRef())) {
            this.transferNodeFromCanvasToBucket(grabbableNucleusImageNode);
        } else {
            AtomicNucleus atomicNucleus = grabbableNucleusImageNode.getNucleusRef();
            if (atomicNucleus.isPaused()) {
                atomicNucleus.setPaused(false);
            } else {
                atomicNucleus.activateDecay();
            }
        }
    }

    private Point2D findOpenSpotForNucleus(AbstractAtomicNucleusNode abstractAtomicNucleusNode) {
        boolean bl = false;
        Point2D.Double double_ = new Point2D.Double();
        for (int i = 0; i < 3 && !bl; ++i) {
            double d = 7.0;
            if (i == 1) {
                d = 3.5;
            } else if (i == 3) {
                d = 0.0;
                System.err.println("WARNING: Allowing nucleus to overlap with others.");
            }
            int n = 0;
            while (n < 100 & !bl) {
                double d2 = this._nucleusPlacementAreaRect.getX() + this._rand.nextDouble() * this._nucleusPlacementAreaRect.getWidth();
                double d3 = this._nucleusPlacementAreaRect.getY() + this._rand.nextDouble() * this._nucleusPlacementAreaRect.getHeight();
                ((Point2D)double_).setLocation(d2, d3);
                bl = true;
                if (this._paddedResetButtonRect.contains(double_)) {
                    bl = false;
                } else if (this._paddedBucketRect.contains(double_)) {
                    bl = false;
                } else {
                    AtomicNucleus atomicNucleus = abstractAtomicNucleusNode.getNucleusRef();
                    Set set = this._mapNucleiToNodes.entrySet();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext() && bl) {
                        Map.Entry entry = iterator.next();
                        AtomicNucleus atomicNucleus2 = (AtomicNucleus)entry.getKey();
                        if (this._bucketNode.isNodeInBucket((AbstractAtomicNucleusNode)this._mapNucleiToNodes.get(atomicNucleus2)) || atomicNucleus == atomicNucleus2 || !(double_.distance(atomicNucleus2.getPositionReference()) < d)) continue;
                        bl = false;
                        break;
                    }
                }
                ++n;
            }
        }
        return double_;
    }

    private int addMultipleNucleiFromBucket(int n) {
        AbstractAtomicNucleusNode abstractAtomicNucleusNode;
        int n2;
        for (n2 = 0; n2 < n && (abstractAtomicNucleusNode = this._bucketNode.extractAnyNucleusFromBucket()) != null; ++n2) {
            this.transferNodeFromBucketToCanvas(abstractAtomicNucleusNode);
            abstractAtomicNucleusNode.getNucleusRef().setPosition(this.findOpenSpotForNucleus(abstractAtomicNucleusNode));
            AtomicNucleus atomicNucleus = abstractAtomicNucleusNode.getNucleusRef();
            if (!(atomicNucleus instanceof NuclearDecayControl)) continue;
            atomicNucleus.activateDecay();
        }
        return n2;
    }

    private void setTimeSpanForChart() {
        if (this._model.getNucleusType() == NucleusType.HEAVY_CUSTOM) {
            this._decayTimeChart.setTimeSpan(5000.0);
        } else {
            this._decayTimeChart.setTimeSpan(3.2 * HalfLifeInfo.getHalfLifeForNucleusType(this._model.getNucleusType()));
        }
    }
}

