/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.Nucleon;
import edu.colorado.phet.nuclearphysics.model.DaughterNucleus;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class Uranium235Nucleus
extends AtomicNucleus {
    private double _fissionInterval;
    private double _fissionTime = 0.0;

    public Uranium235Nucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D, double d) {
        super(nuclearPhysicsClock, point2D, 92, 143);
        this._fissionInterval = d;
    }

    public boolean captureParticle(Nucleon nucleon) {
        boolean bl = false;
        if (nucleon instanceof Nucleon && nucleon.getNucleonType() == Nucleon.NucleonType.NEUTRON && this._numNeutrons == 143) {
            ++this._numNeutrons;
            this.notifyNucleusChangeEvent(null);
            this._fissionTime = this._clock.getSimulationTime() + this._fissionInterval;
            bl = true;
        }
        return bl;
    }

    public void reset() {
        this._fissionTime = 0.0;
        if (this._numNeutrons != 143 || this._numProtons != 92) {
            this._numNeutrons = 143;
            this._numProtons = 92;
            this.notifyNucleusChangeEvent(null);
        }
    }

    protected void handleClockTicked(ClockEvent clockEvent) {
        super.handleClockTicked(clockEvent);
        if (this._fissionTime != 0.0 && clockEvent.getSimulationTime() >= this._fissionTime) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < 3; ++i) {
                arrayList.add(new Nucleon(Nucleon.NucleonType.NEUTRON, this._position.getX(), this._position.getY(), false));
            }
            this._numNeutrons -= 3;
            Point2D.Double double_ = new Point2D.Double();
            double_.setLocation(this._position);
            DaughterNucleus daughterNucleus = new DaughterNucleus(this._clock, double_, 36, 56);
            arrayList.add(daughterNucleus);
            this._numProtons -= 36;
            this._numNeutrons -= 56;
            this.notifyNucleusChangeEvent(arrayList);
            this._fissionTime = 0.0;
        }
    }
}

