/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.Nucleon;
import edu.colorado.phet.nuclearphysics.common.model.SubatomicParticle;
import edu.colorado.phet.nuclearphysics.model.AlphaParticle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeAtomicNucleus
extends AtomicNucleus {
    protected ArrayList<SubatomicParticle> _constituents;
    private int _agitationCount = 0;
    protected int _agitationFactor = 5;
    protected Random _rand = new Random();
    protected int _numAlphas = 0;
    protected boolean _paused = false;
    private int currentPlacementZoneIndex = 0;
    private static PlacementZoneAngle[] _placementZoneAngles;

    public CompositeAtomicNucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D, int n, int n2, double d) {
        super(nuclearPhysicsClock, point2D, n, n2, d);
        if (this._numProtons + this._numNeutrons > 50) {
            this._numAlphas = (n + n2) / 2 / 4;
        }
        this._constituents = new ArrayList();
        int n3 = this._numProtons - this._numAlphas * 2;
        int n4 = this._numNeutrons - this._numAlphas * 2;
        int n5 = Math.max(n3, n4);
        n5 = Math.max(n5, this._numAlphas);
        for (int i = n5 - 1; i >= 0; --i) {
            if (i < this._numAlphas) {
                this._constituents.add(new AlphaParticle(0.0, 0.0));
            }
            if (i < n3) {
                this._constituents.add(new Nucleon(Nucleon.NucleonType.PROTON, 0.0, 0.0, true));
            }
            if (i >= n4) continue;
            this._constituents.add(new Nucleon(Nucleon.NucleonType.NEUTRON, 0.0, 0.0, true));
        }
        this.setInitialNucleonPositions();
        this.updateAgitationFactor();
    }

    public CompositeAtomicNucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D, ArrayList<SubatomicParticle> arrayList) {
        this(nuclearPhysicsClock, point2D, 0, 0, 1.0);
        this._numAlphas = 0;
        this._numProtons = 0;
        this._numNeutrons = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) instanceof AlphaParticle) {
                ++this._numAlphas;
                this._numNeutrons += 2;
                this._numProtons += 2;
                continue;
            }
            if (arrayList.get(i) instanceof Nucleon) {
                Nucleon nucleon = (Nucleon)arrayList.get(i);
                if (nucleon.getNucleonType() == Nucleon.NucleonType.PROTON) {
                    ++this._numNeutrons;
                    continue;
                }
                ++this._numProtons;
                continue;
            }
            assert (false);
            System.err.println("Error: Unexpected nucleus constituent type.");
        }
        this._constituents = arrayList;
        this.updateDiameter();
        this.updateAgitationFactor();
    }

    public ArrayList getConstituents() {
        return this._constituents;
    }

    @Override
    public void setPaused(boolean bl) {
        this._paused = bl;
    }

    public boolean getPaused() {
        return this._paused;
    }

    protected abstract void updateAgitationFactor();

    @Override
    protected void handleClockTicked(ClockEvent clockEvent) {
        if (!this._paused) {
            int n;
            super.handleClockTicked(clockEvent);
            if (this._xVelocity != 0.0 || this._yVelocity != 0.0) {
                n = this._constituents.size();
                SubatomicParticle subatomicParticle = null;
                for (int i = 0; i < n; ++i) {
                    subatomicParticle = this._constituents.get(i);
                    double d = subatomicParticle.getPositionReference().x + this._xVelocity;
                    double d2 = subatomicParticle.getPositionReference().y + this._yVelocity;
                    subatomicParticle.setPosition(d, d2);
                }
            }
            if (this._agitationFactor > 0) {
                if (this._numNeutrons + this._numProtons > 20) {
                    n = 20 - 2 * this._agitationFactor;
                    assert (n > 0);
                    if (n <= 0) {
                        n = 5;
                    }
                    double d = Math.min(this._tunnelingRegionRadius, this.getDiameter() * 1.5);
                    for (int i = this._agitationCount; i < this._constituents.size(); i += n) {
                        SubatomicParticle subatomicParticle = this._constituents.get(i);
                        subatomicParticle.tunnel(this._position, 0.0, this.getDiameter() / 2.0, d);
                    }
                    this._agitationCount = (this._agitationCount + 1) % n;
                } else if (this._agitationFactor > 0) {
                    n = 9 - this._agitationFactor + 1;
                    for (int i = this._agitationCount; i < this._constituents.size(); i += n) {
                        SubatomicParticle subatomicParticle = this._constituents.get(i);
                        subatomicParticle.jitter();
                    }
                    this._agitationCount = (this._agitationCount + 1) % n;
                }
            }
        }
    }

    private void setInitialNucleonPositions() {
        if (this._constituents.size() == 3) {
            double d = Math.PI;
            double d2 = 0.8 / Math.cos(0.5235987755982988);
            for (int i = 0; i < 3; ++i) {
                double d3 = 2.0943951023931953 * (double)i + d;
                double d4 = Math.sin(d3) * d2;
                double d5 = Math.cos(d3) * d2;
                this._constituents.get(i).setPosition(this.getPositionReference().getX() + d4, this.getPositionReference().getY() + d5);
            }
        } else if (this._constituents.size() < 28) {
            double d = 0.4;
            double d6 = 0.8;
            double d7 = 0.32;
            int n = 2;
            int n2 = 0;
            while (n2 < this._constituents.size()) {
                for (int i = 0; i < n; ++i) {
                    SubatomicParticle subatomicParticle = this._constituents.get(this._constituents.size() - 1 - n2);
                    this.placeNucleon(subatomicParticle, this._position, d, d6, _placementZoneAngles[this.chooseNextPlacementZoneIndex()]);
                    if (++n2 >= this._constituents.size()) break;
                }
                d += d7;
                d6 += d7;
                n += 6;
            }
        } else {
            double d = Math.min(this._tunnelingRegionRadius, this.getDiameter() * 1.5);
            for (SubatomicParticle subatomicParticle : this._constituents) {
                subatomicParticle.tunnel(this._position, 0.0, this.getDiameter() / 2.0, d);
            }
        }
    }

    private void placeNucleon(SubatomicParticle subatomicParticle, Point2D point2D, double d, double d2, PlacementZoneAngle placementZoneAngle) {
        double d3 = d + RAND.nextDouble() * (d2 - d);
        double d4 = placementZoneAngle.getMinAngle() + RAND.nextDouble() * (placementZoneAngle.getMaxAngle() - placementZoneAngle.getMinAngle());
        double d5 = point2D.getX() + Math.cos(d4) * d3;
        double d6 = point2D.getY() + Math.sin(d4) * d3;
        subatomicParticle.setPosition(d5, d6);
    }

    private int chooseNextPlacementZoneIndex() {
        this.currentPlacementZoneIndex = (this.currentPlacementZoneIndex + 1 + _placementZoneAngles.length / 2) % _placementZoneAngles.length;
        return this.currentPlacementZoneIndex;
    }

    static {
        int n = 8;
        assert (n % 2 == 0);
        _placementZoneAngles = new PlacementZoneAngle[n];
        double d = Math.PI * 2 / (double)n;
        for (int i = 0; i < n; ++i) {
            CompositeAtomicNucleus._placementZoneAngles[i] = new PlacementZoneAngle((double)i * d, (double)(i + 1) * d);
        }
    }

    private static class PlacementZoneAngle {
        private final double minAngle;
        private final double maxAngle;

        public PlacementZoneAngle(double d, double d2) {
            this.minAngle = d;
            this.maxAngle = d2;
        }

        public double getMinAngle() {
            return this.minAngle;
        }

        public double getMaxAngle() {
            return this.maxAngle;
        }

        public String toString() {
            return "min = " + this.minAngle + ", max = " + this.maxAngle;
        }
    }
}

