/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.model.Antineutrino;
import edu.colorado.phet.nuclearphysics.common.model.Electron;
import edu.colorado.phet.nuclearphysics.common.model.Nucleon;
import edu.colorado.phet.nuclearphysics.common.model.SubatomicParticle;
import edu.colorado.phet.nuclearphysics.model.CompositeAtomicNucleus;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;

public abstract class BetaDecayCompositeNucleus
extends CompositeAtomicNucleus {
    private static final Random RAND = new Random();

    public BetaDecayCompositeNucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D, int n, int n2, double d) {
        super(nuclearPhysicsClock, point2D, n, n2, d);
    }

    public void reset() {
        super.reset();
        if (this._numNeutrons != this._origNumNeutrons || this._numProtons != this._origNumProtons) {
            this._numNeutrons = this._origNumNeutrons;
            this._numProtons = this._origNumProtons;
            for (int i = this._constituents.size() - 1; i >= 0; --i) {
                SubatomicParticle subatomicParticle = (SubatomicParticle)this._constituents.get(i);
                if (!(subatomicParticle instanceof Nucleon) || ((Nucleon)subatomicParticle).getNucleonType() != Nucleon.NucleonType.PROTON) continue;
                ((Nucleon)subatomicParticle).setNucleonType(Nucleon.NucleonType.NEUTRON);
                break;
            }
            this.updateAgitationFactor();
            this.notifyNucleusChangeEvent(null);
        }
    }

    protected void decay(ClockEvent clockEvent) {
        super.decay(clockEvent);
        --this._numNeutrons;
        ++this._numProtons;
        for (int i = this._constituents.size() - 1; i >= 0; --i) {
            SubatomicParticle subatomicParticle = (SubatomicParticle)this._constituents.get(i);
            if (!(subatomicParticle instanceof Nucleon) || ((Nucleon)subatomicParticle).getNucleonType() != Nucleon.NucleonType.NEUTRON) continue;
            ((Nucleon)subatomicParticle).setNucleonType(Nucleon.NucleonType.PROTON);
            break;
        }
        double d = RAND.nextDouble() * Math.PI * 2.0;
        double d2 = Math.cos(d) * 0.4;
        double d3 = Math.sin(d) * 0.4;
        ArrayList<SubatomicParticle> arrayList = new ArrayList<SubatomicParticle>();
        Electron electron = new Electron(this.getPositionReference().getX(), this.getPositionReference().getY());
        electron.setVelocity(d2, d3);
        arrayList.add(electron);
        d = RAND.nextDouble() * Math.PI * 2.0;
        d2 = Math.cos(d) * 0.8;
        d3 = Math.sin(d) * 0.8;
        Antineutrino antineutrino = new Antineutrino(this.getPositionReference().getX(), this.getPositionReference().getY());
        antineutrino.setVelocity(d2, d3);
        arrayList.add(antineutrino);
        this.updateAgitationFactor();
        this.notifyNucleusChangeEvent(arrayList);
    }
}

