/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.model.AlphaParticle;
import edu.colorado.phet.nuclearphysics.model.CompositeAtomicNucleus;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public abstract class AlphaDecayCompositeNucleus
extends CompositeAtomicNucleus {
    public AlphaDecayCompositeNucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D, int n, int n2) {
        super(nuclearPhysicsClock, point2D, n, n2, 1.0);
    }

    public void reset(AlphaParticle alphaParticle) {
        super.reset();
        if (alphaParticle != null) {
            this._constituents.add(0, alphaParticle);
            ++this._numAlphas;
            this._numNeutrons += 2;
            this._numProtons += 2;
            alphaParticle.resetTunneling();
            this.updateAgitationFactor();
            this.notifyNucleusChangeEvent(null);
        }
        this.activateDecay();
    }

    protected void decay(ClockEvent clockEvent) {
        super.decay(clockEvent);
        for (int i = 0; i < this._constituents.size(); ++i) {
            if (!(this._constituents.get(i) instanceof AlphaParticle)) continue;
            AlphaParticle alphaParticle = (AlphaParticle)this._constituents.get(i);
            this._constituents.remove(i);
            --this._numAlphas;
            this._numProtons -= 2;
            this._numNeutrons -= 2;
            alphaParticle.tunnelOut(this._position, this._tunnelingRegionRadius + 1.0);
            this.updateAgitationFactor();
            ArrayList<AlphaParticle> arrayList = new ArrayList<AlphaParticle>(1);
            arrayList.add(alphaParticle);
            this.notifyNucleusChangeEvent(arrayList);
            break;
        }
    }
}

