/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.common.view;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.common.NucleusDisplayInfo;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.view.AbstractAtomicNucleusNode;
import edu.colorado.phet.nuclearphysics.module.betadecay.LabelVisibilityModel;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;

public class LabeledExplodingAtomicNucleusNode
extends AbstractAtomicNucleusNode {
    private static final Font ISOTOPE_NUMBER_FONT = new Font(NuclearPhysicsConstants.DEFAULT_FONT_NAME, 1, 10);
    private static final Font ISOTOPE_CHEM_SYMBOL_FONT = new Font(NuclearPhysicsConstants.DEFAULT_FONT_NAME, 1, 16);
    private static final Color EXPLOSION_STROKE_COLOR = new Color(0xFFFF33);
    private static final Color EXPLOSION_FILL_COLOR = new Color(0xFFFF33);
    int _explosionCounter = 0;
    PPath _explosion;
    private Ellipse2D _explosionShape;
    private PText _isotopeNumber;
    private PText _isotopeNumberShadow;
    private PText _isotopeChemSymbol;
    private PText _isotopeChemSymbolShadow;
    ClockAdapter _clockAdapter = new ClockAdapter(){

        public void clockTicked(ClockEvent clockEvent) {
            LabeledExplodingAtomicNucleusNode.this.handleClockTicked(clockEvent);
        }
    };
    private LabelVisibilityModel _labelVisibilityModel;

    public LabeledExplodingAtomicNucleusNode(AtomicNucleus atomicNucleus) {
        this(atomicNucleus, new LabelVisibilityModel());
    }

    public LabeledExplodingAtomicNucleusNode(AtomicNucleus atomicNucleus, LabelVisibilityModel labelVisibilityModel) {
        super(atomicNucleus);
        this._labelVisibilityModel = labelVisibilityModel;
        this._currentAtomicWeight = this._atomicNucleus.getAtomicWeight();
        this._labelVisibilityModel.addObserver(new SimpleObserver(){

            public void update() {
                LabeledExplodingAtomicNucleusNode.this.updateLabel();
            }
        });
        this._explosion = new PPath();
        this._explosion.setStrokePaint(EXPLOSION_STROKE_COLOR);
        this._explosion.setPaint(EXPLOSION_FILL_COLOR);
        this.addChild(this._explosion);
        this._explosionShape = new Ellipse2D.Double();
        this._isotopeNumberShadow = new PText();
        this._isotopeNumberShadow.setFont(ISOTOPE_NUMBER_FONT);
        this._isotopeNumberShadow.setScale(0.3);
        this.addChild(this._isotopeNumberShadow);
        this._isotopeNumber = new PText();
        this._isotopeNumber.setFont(ISOTOPE_NUMBER_FONT);
        this._isotopeNumber.setScale(0.3);
        this.addChild(this._isotopeNumber);
        this._isotopeChemSymbolShadow = new PText();
        this._isotopeChemSymbolShadow.setFont(ISOTOPE_CHEM_SYMBOL_FONT);
        this._isotopeChemSymbolShadow.setScale(0.3);
        this.addChild(this._isotopeChemSymbolShadow);
        this._isotopeChemSymbol = new PText();
        this._isotopeChemSymbol.setFont(ISOTOPE_CHEM_SYMBOL_FONT);
        this._isotopeChemSymbol.setScale(0.3);
        this.addChild(this._isotopeChemSymbol);
        this._atomicNucleus.addListener(this._atomicNucleusAdapter);
        this._atomicNucleus.getClock().addClockListener(this._clockAdapter);
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.updateLabel();
        this.updatePosition();
    }

    private void updateLabel() {
        int n;
        int n2 = this._atomicNucleus.getNumProtons();
        NucleusDisplayInfo nucleusDisplayInfo = NucleusDisplayInfo.getDisplayInfoForNucleusConfig(n2, n = this._atomicNucleus.getNumNeutrons());
        if (nucleusDisplayInfo == null || !this._labelVisibilityModel.isVisible()) {
            this._isotopeChemSymbol.setText("");
            this._isotopeChemSymbolShadow.setText("");
            this._isotopeNumber.setText("");
            this._isotopeNumberShadow.setText("");
            return;
        }
        String string = nucleusDisplayInfo.getChemicalSymbol();
        String string2 = nucleusDisplayInfo.getIsotopeNumberString();
        Color color = nucleusDisplayInfo.getLabelColor();
        this._isotopeChemSymbol.setTextPaint(color);
        this._isotopeNumber.setTextPaint(color);
        if (color == Color.BLACK) {
            this._isotopeChemSymbolShadow.setTextPaint(Color.WHITE);
            this._isotopeNumberShadow.setTextPaint(Color.WHITE);
        } else {
            this._isotopeChemSymbolShadow.setTextPaint(Color.BLACK);
            this._isotopeNumberShadow.setTextPaint(Color.BLACK);
        }
        this._isotopeChemSymbol.setText(string);
        this._isotopeChemSymbolShadow.setText(string);
        this._isotopeNumber.setText(string2);
        this._isotopeNumberShadow.setText(string2);
        this._isotopeChemSymbol.setScale(1.0);
        this._isotopeChemSymbolShadow.setScale(1.0);
        this._isotopeNumber.setScale(1.0);
        this._isotopeNumberShadow.setScale(1.0);
        double d = 1.0;
        if (string2 == "" && string != "") {
            d = Math.min(this._atomicNucleus.getDiameter() / this._isotopeChemSymbol.getFullBoundsReference().getWidth() * 0.9, this._atomicNucleus.getDiameter() / this._isotopeChemSymbol.getFullBoundsReference().getHeight() * 0.8);
        } else if (string != "") {
            d = this._isotopeNumber.getText().length() >= 2 ? this._atomicNucleus.getDiameter() / (this._isotopeChemSymbol.getFullBoundsReference().getWidth() + this._isotopeNumber.getFullBoundsReference().getWidth()) : this._atomicNucleus.getDiameter() / (this._isotopeChemSymbol.getFullBoundsReference().getWidth() + this._isotopeNumber.getFullBoundsReference().getWidth()) * 0.7;
        }
        this._isotopeChemSymbol.setScale(d);
        this._isotopeChemSymbolShadow.setScale(d);
        this._isotopeNumber.setScale(d);
        this._isotopeNumberShadow.setScale(d);
        this.updateLabelPositions();
    }

    private void updateLabelPositions() {
        double d = this._isotopeNumber.getFullBoundsReference().getWidth() + this._isotopeChemSymbol.getFullBoundsReference().getWidth();
        double d2 = this._isotopeChemSymbol.getFullBoundsReference().getHeight();
        double d3 = -d / 2.0;
        double d4 = -d2 / 2.0;
        if (this._isotopeNumber.getText().length() == 0) {
            this._isotopeChemSymbol.setOffset(d3, d4);
        } else {
            this._isotopeNumber.setOffset(d3, d4);
            this._isotopeNumberShadow.setOffset(this._isotopeNumber.getOffset().getX() + 0.5 * this._isotopeChemSymbol.getScale(), this._isotopeNumber.getOffset().getY() + 0.5 * this._isotopeChemSymbol.getScale());
            this._isotopeChemSymbol.setOffset(this._isotopeNumber.getFullBoundsReference().getMaxX(), d4);
        }
        this._isotopeChemSymbolShadow.setOffset(this._isotopeChemSymbol.getOffset().getX() + 0.5 * this._isotopeChemSymbol.getScale(), this._isotopeChemSymbol.getOffset().getY() + 0.5 * this._isotopeChemSymbol.getScale());
    }

    private void handleClockTicked(ClockEvent clockEvent) {
        if (this._explosionCounter > 0) {
            double d = (double)(10 - this._explosionCounter + 1) * this._atomicNucleus.getDiameter() / 2.0;
            this._explosionShape.setFrameFromCenter(0.0, 0.0, d, d);
            this._explosion.setPathTo(this._explosionShape);
            this._explosion.setTransparency(0.4f * (float)this._explosionCounter / 10.0f);
            --this._explosionCounter;
        } else {
            this._explosion.setVisible(false);
        }
    }

    protected void handleNucleusChangedEvent(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
        if (atomicNucleus.hasDecayed()) {
            this._explosionCounter = 10;
            this._explosion.setVisible(true);
            this._explosion.setPickable(false);
        } else {
            this._explosion.setVisible(false);
            this._explosion.setPathTo(new Ellipse2D.Double(0.0, 0.0, 0.0, 0.0));
        }
        this._currentAtomicWeight = n + n2;
        this.updateLabel();
    }

    public void cleanup() {
        super.cleanup();
        this._atomicNucleus.getClock().removeClockListener(this._clockAdapter);
    }
}

