/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.common.model;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.NuclearDecayControl;
import edu.colorado.phet.nuclearphysics.common.model.Nucleon;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomicNucleus
implements NuclearDecayControl {
    public static final Random RAND = new Random();
    protected NuclearPhysicsClock _clock;
    protected ArrayList<Listener> _listeners = new ArrayList();
    protected Point2D _position = new Point2D.Double();
    protected Point2D _origPosition = new Point2D.Double();
    protected double _xVelocity = 0.0;
    protected double _yVelocity = 0.0;
    protected double _xAcceleration = 0.0;
    protected double _yAcceleration = 0.0;
    protected int _numNeutrons;
    protected int _numProtons;
    protected final int _origNumNeutrons;
    protected final int _origNumProtons;
    protected double _tunnelingRegionRadius = 15.0;
    private double _diameter;
    protected double _decayTime = 0.0;
    protected double _activatedLifetime = 0.0;
    protected double _totalUndecayedLifetime = 0.0;
    protected double _halfLife = 0.0;
    protected boolean _paused = false;
    protected final double _decayTimeScalingFactor;
    private ClockAdapter _ca = new ClockAdapter(){

        public void clockTicked(ClockEvent clockEvent) {
            AtomicNucleus.this.handleClockTicked(clockEvent);
        }
    };

    public AtomicNucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D, int n, int n2, double d) {
        this._clock = nuclearPhysicsClock;
        this._numProtons = n;
        this._numNeutrons = n2;
        this._origNumProtons = n;
        this._origNumNeutrons = n2;
        this._decayTimeScalingFactor = d;
        this.addClockListener();
        this._origPosition.setLocation(point2D);
        this._position.setLocation(point2D);
        this.updateDiameter();
        this._halfLife = HalfLifeInfo.getHalfLifeForNucleusConfig(this._numProtons, this._numNeutrons);
    }

    public AtomicNucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D, int n, int n2) {
        this(nuclearPhysicsClock, point2D, n, n2, 1.0);
    }

    public Point2D getPositionReference() {
        return this._position;
    }

    public void setPosition(Point2D point2D) {
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public void setPosition(double d, double d2) {
        this._position.setLocation(d, d2);
        this.notifyPositionChanged();
    }

    public void setVelocity(double d, double d2) {
        this._xVelocity = d;
        this._yVelocity = d2;
    }

    public void setAcceleration(double d, double d2) {
        this._xAcceleration = d;
        this._yAcceleration = d2;
    }

    public void setAcceleration(MutableVector2D mutableVector2D) {
        this._xAcceleration = mutableVector2D.getX();
        this._yAcceleration = mutableVector2D.getY();
    }

    public MutableVector2D getVelocity() {
        return new MutableVector2D(this._xVelocity, this._yVelocity);
    }

    public int getAtomicWeight() {
        return this._numNeutrons + this._numProtons;
    }

    public int getNumProtons() {
        return this._numProtons;
    }

    public int getNumNeutrons() {
        return this._numNeutrons;
    }

    public double getDiameter() {
        return this._diameter;
    }

    public double getHalfLife() {
        return this._halfLife;
    }

    public double getDecayTimeScalingFactor() {
        return this._decayTimeScalingFactor;
    }

    public void setHalfLife(double d) {
        this._halfLife = d;
    }

    protected void updateDiameter() {
        switch (this._numProtons + this._numNeutrons) {
            case 1: {
                this._diameter = 1.6;
                break;
            }
            case 2: {
                this._diameter = 3.2;
                break;
            }
            case 3: {
                this._diameter = 3.2;
                break;
            }
            case 4: {
                this._diameter = 5.6000000000000005;
                break;
            }
            default: {
                this._diameter = 1.6 * Math.pow(this.getAtomicWeight(), 0.362);
            }
        }
    }

    public ConstantDtClock getClock() {
        return this._clock;
    }

    public void setTunnelingRegionRadius(double d) {
        if (d != this._tunnelingRegionRadius && d >= this.getDiameter() / 2.0) {
            this._tunnelingRegionRadius = d = Math.min(d, 200.0);
            this.notifyTunnelingRadiusChanged();
        }
    }

    public double getTunnelingRegionRadius() {
        return this._tunnelingRegionRadius;
    }

    public boolean isPaused() {
        return this._paused;
    }

    public void setPaused(boolean bl) {
        this._paused = bl;
    }

    @Override
    public void activateDecay() {
        if (this._numNeutrons == this._origNumNeutrons) {
            this._totalUndecayedLifetime = this.calcDecayTime();
            this._decayTime = this._clock.getSimulationTime() + this._totalUndecayedLifetime * this._decayTimeScalingFactor;
        }
    }

    public boolean hasDecayed() {
        return this._numProtons != this._origNumProtons;
    }

    public boolean isDecayActive() {
        return this._decayTime != 0.0;
    }

    public double getActivatedSimTime() {
        return this._activatedLifetime;
    }

    public double getAdjustedActivatedTime() {
        return this._activatedLifetime / this._decayTimeScalingFactor;
    }

    public void addListener(Listener listener) {
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this._listeners.remove(listener);
    }

    public void reset() {
        this._decayTime = 0.0;
        this._activatedLifetime = 0.0;
        this._paused = false;
    }

    public boolean captureParticle(Nucleon nucleon) {
        return false;
    }

    public static ArrayList<NucleusType> getPostDecayNuclei(NucleusType nucleusType) {
        ArrayList<NucleusType> arrayList = new ArrayList<NucleusType>();
        switch (nucleusType) {
            case HYDROGEN_3: {
                arrayList.add(NucleusType.HELIUM_3);
                break;
            }
            case CARBON_14: {
                arrayList.add(NucleusType.NITROGEN_14);
                break;
            }
            case URANIUM_238: {
                arrayList.add(NucleusType.LEAD_206);
                break;
            }
            case POLONIUM_211: {
                arrayList.add(NucleusType.LEAD_207);
                break;
            }
            case LIGHT_CUSTOM: {
                arrayList.add(NucleusType.LIGHT_CUSTOM_POST_DECAY);
                break;
            }
            case HEAVY_CUSTOM: {
                arrayList.add(NucleusType.HEAVY_CUSTOM_POST_DECAY);
                break;
            }
            default: {
                System.out.println("Warning: No decay product information available for requested nucleus, returning original value, nucleus = " + (Object)((Object)nucleusType));
                arrayList.add(nucleusType);
            }
        }
        return arrayList;
    }

    public static NucleusType identifyNucleus(int n, int n2) {
        NucleusType nucleusType = null;
        block0 : switch (n) {
            case 1: {
                nucleusType = NucleusType.HYDROGEN_3;
                break;
            }
            case 2: {
                nucleusType = NucleusType.HELIUM_3;
                break;
            }
            case 6: {
                nucleusType = NucleusType.CARBON_14;
                break;
            }
            case 7: {
                nucleusType = NucleusType.NITROGEN_14;
                break;
            }
            case 8: {
                nucleusType = NucleusType.LIGHT_CUSTOM;
                break;
            }
            case 9: {
                nucleusType = NucleusType.LIGHT_CUSTOM_POST_DECAY;
                break;
            }
            case 81: {
                nucleusType = NucleusType.HEAVY_CUSTOM_POST_DECAY;
                break;
            }
            case 82: {
                if (n2 == 124) {
                    nucleusType = NucleusType.LEAD_206;
                    break;
                }
                if (n2 == 125) {
                    nucleusType = NucleusType.LEAD_207;
                    break;
                }
                System.err.println("Error: Unrecognized isotope for Lead, using Lead 207.");
                assert (false);
                nucleusType = NucleusType.LEAD_207;
                break;
            }
            case 83: {
                nucleusType = NucleusType.HEAVY_CUSTOM;
                break;
            }
            case 84: {
                nucleusType = NucleusType.POLONIUM_211;
                break;
            }
            case 92: {
                switch (n2) {
                    case 143: {
                        nucleusType = NucleusType.URANIUM_235;
                        break block0;
                    }
                    case 144: {
                        nucleusType = NucleusType.URANIUM_236;
                        break block0;
                    }
                    case 146: {
                        nucleusType = NucleusType.URANIUM_238;
                        break block0;
                    }
                    case 147: {
                        nucleusType = NucleusType.URANIUM_239;
                        break block0;
                    }
                }
                System.err.println("Error: Unrecognized uranium isotop, using U238.");
                assert (false);
                nucleusType = NucleusType.URANIUM_238;
                break;
            }
            default: {
                nucleusType = null;
            }
        }
        return nucleusType;
    }

    protected void handleClockTicked(ClockEvent clockEvent) {
        this._xVelocity += this._xAcceleration;
        this._yVelocity += this._yAcceleration;
        if (this._xVelocity != 0.0 || this._yVelocity != 0.0) {
            double d = this._position.getX() + this._xVelocity;
            double d2 = this._position.getY() + this._yVelocity;
            this._position.setLocation(d, d2);
            this.notifyPositionChanged();
        }
        if (this._decayTime != 0.0) {
            if (!this._paused) {
                if (this.isTimeToDecay(clockEvent)) {
                    this.decay(clockEvent);
                } else {
                    this._activatedLifetime += clockEvent.getSimulationTimeChange();
                }
            } else {
                this._decayTime += clockEvent.getSimulationTimeChange();
            }
        }
    }

    protected void decay(ClockEvent clockEvent) {
        this._activatedLifetime += clockEvent.getSimulationTimeChange();
        this._decayTime = 0.0;
    }

    protected double calcDecayTime() {
        double d;
        if (this._halfLife <= 0.0) {
            d = 0.0;
        } else if (this._halfLife == Double.POSITIVE_INFINITY) {
            d = Double.POSITIVE_INFINITY;
        } else {
            double d2 = 0.693 / this._halfLife;
            double d3 = RAND.nextDouble();
            if (d3 > 0.999) {
                d3 = 0.999;
            }
            d = -(Math.log(1.0 - d3) / d2);
        }
        return d;
    }

    protected double getTotalUndecayedLifetime() {
        return this._totalUndecayedLifetime;
    }

    protected boolean isTimeToDecay(ClockEvent clockEvent) {
        return clockEvent.getSimulationTime() >= this._decayTime;
    }

    private void addClockListener() {
        this._clock.addClockListener(this._ca);
    }

    public void removedFromModel() {
        this._clock.removeClockListener(this._ca);
    }

    protected void notifyNucleusChangeEvent(ArrayList arrayList) {
        this.updateDiameter();
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).nucleusChangeEvent(this, this._numProtons, this._numNeutrons, arrayList);
        }
    }

    protected void notifyPositionChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).positionChanged();
        }
    }

    protected void notifyTunnelingRadiusChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).tunnelingRadiusChanged();
        }
    }

    public static class Adapter
    implements Listener {
        public void positionChanged() {
        }

        public void nucleusChangeEvent(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
        }

        public void tunnelingRadiusChanged() {
        }
    }

    public static interface Listener {
        public void positionChanged();

        public void nucleusChangeEvent(AtomicNucleus var1, int var2, int var3, ArrayList var4);

        public void tunnelingRadiusChanged();
    }
}

