/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util;

import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;

public class DefaultDecimalFormat
extends DecimalFormat {
    private NumberFormat decimalFormat;

    public DefaultDecimalFormat(String string) {
        this(DecimalFormat.getNumberInstance(PhetResources.readLocale()));
        if (this.decimalFormat instanceof DecimalFormat) {
            ((DecimalFormat)this.decimalFormat).applyPattern(string);
        }
    }

    public DefaultDecimalFormat(NumberFormat numberFormat) {
        this.decimalFormat = numberFormat;
    }

    private double roundNearestNeighbor(double d) {
        int n = this.decimalFormat.getMaximumFractionDigits();
        BigDecimal bigDecimal = new BigDecimal(d, new MathContext(n, RoundingMode.HALF_UP));
        BigDecimal bigDecimal2 = bigDecimal.setScale(n, RoundingMode.HALF_UP);
        return bigDecimal2.doubleValue();
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        StringBuffer stringBuffer2 = this.decimalFormat.format(this.roundNearestNeighbor(d), new StringBuffer(), fieldPosition);
        double d2 = 0.0;
        try {
            d2 = this.decimalFormat.parse(stringBuffer2.toString()).doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            return this.decimalFormat.format(d, stringBuffer, fieldPosition);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        if (d2 == 0.0 && stringBuffer2.indexOf("-") == 0) {
            stringBuffer.append(stringBuffer2.substring(1));
        } else {
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer;
    }
}

