/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.microwaves.MicrowavesResources;
import edu.colorado.phet.microwaves.common.graphics.ApparatusPanel;
import edu.colorado.phet.microwaves.common.graphics.ModelViewTransform2D;
import edu.colorado.phet.microwaves.coreadditions.BufferedApparatusPanel;
import edu.colorado.phet.microwaves.coreadditions.ModelViewTx1D;
import edu.colorado.phet.microwaves.coreadditions.collision.Box2D;
import edu.colorado.phet.microwaves.model.Microwave;
import edu.colorado.phet.microwaves.model.MicrowavesClock;
import edu.colorado.phet.microwaves.model.MicrowavesModel;
import edu.colorado.phet.microwaves.model.Thermometer;
import edu.colorado.phet.microwaves.model.WaterMolecule;
import edu.colorado.phet.microwaves.model.waves.WaveMedium;
import edu.colorado.phet.microwaves.view.FieldLatticeView;
import edu.colorado.phet.microwaves.view.FieldVector;
import edu.colorado.phet.microwaves.view.FlipperAffineTransformFactory;
import edu.colorado.phet.microwaves.view.MicrowaveControlPanel;
import edu.colorado.phet.microwaves.view.OvenGraphic;
import edu.colorado.phet.microwaves.view.ThermometerView;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class MicrowaveModule
extends Module {
    protected Microwave muWave;
    private MicrowavesModel microwaveModel;
    private Rectangle2D.Double modelBounds;
    private Rectangle viewBounds;
    private float savedFreq = 0.0015f;
    private float savedAmp = 0.25f;
    private ModelViewTransform2D modelViewTransform;
    private int latticeSpace = 40;
    private Box2D oven;
    private FieldLatticeView fieldLattiveView;
    private boolean isMicrowaveOn = false;
    private ApparatusPanel apparatusPanel;
    private MicrowaveControlPanel controlPanel;

    public MicrowaveModule(String string) {
        super(string, new MicrowavesClock());
        this.microwaveModel = new MicrowavesModel(string);
        this.setModel(this.microwaveModel);
        this.createApparatusPanel();
        this.init();
    }

    protected ApparatusPanel getApparatusPanel() {
        return this.apparatusPanel;
    }

    protected void init() {
        this.muWave = new Microwave(0.0f, 0.0f);
        this.microwaveModel.addMicrowave(this.muWave);
        this.apparatusPanel.setBackground(new Color(250, 250, 220));
        this.createOven();
        this.createFieldView();
        Thermometer thermometer = new Thermometer(this.microwaveModel);
        thermometer.setLocation(new Point2D.Double(50.0, 50.0));
        this.microwaveModel.addModelElement(thermometer);
        ThermometerView thermometerView = new ThermometerView(thermometer);
        this.apparatusPanel.addGraphic(thermometerView, 100.0);
        if (this.getModulePanel().getControlPanel() == null) {
            this.controlPanel = new MicrowaveControlPanel(this, this.microwaveModel);
            this.setControlPanel(this.controlPanel);
        }
        this.controlPanel.reset();
    }

    public void reset() {
        this.microwaveModel.clear();
        this.apparatusPanel.removeAllGraphics();
        this.isMicrowaveOn = false;
        this.init();
    }

    public void updateGraphics(ClockEvent clockEvent) {
        this.apparatusPanel.update(null, null);
    }

    private void createApparatusPanel() {
        this.modelBounds = new Rectangle2D.Double(0.0, 0.0, 600.0, 500.0);
        this.viewBounds = new Rectangle(0, 0, 600, 500);
        this.modelViewTransform = new ModelViewTransform2D(this.modelBounds, this.viewBounds);
        this.apparatusPanel = new BufferedApparatusPanel(new FlipperAffineTransformFactory(this.modelBounds));
        this.setSimulationPanel(this.apparatusPanel);
        this.apparatusPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
            }
        });
    }

    private void createOven() {
        this.oven = new Box2D(new Point2D.Double(100.0, 100.0), new Point2D.Double(500.0, 400.0));
        this.microwaveModel.addModelElement(this.oven);
        this.microwaveModel.setOven(this.oven);
        OvenGraphic ovenGraphic = new OvenGraphic(this.oven, this.modelViewTransform);
        ovenGraphic.update(null, null);
        double d = 1.0;
        this.apparatusPanel.addGraphic(ovenGraphic, d);
    }

    private void createFieldView() {
        WaveMedium waveMedium = this.getMicrowaveModel().getWaveMedium();
        FieldVector.setLength(this.latticeSpace - 5);
        if (this.fieldLattiveView == null) {
            this.fieldLattiveView = new FieldLatticeView(waveMedium, new Point2D.Double(this.oven.getMinX() + (double)this.latticeSpace, this.oven.getMinY() + (double)this.latticeSpace), this.oven.getMaxX() - this.oven.getMinX() - (double)this.latticeSpace, this.oven.getMaxY() - this.oven.getMinY() - (double)this.latticeSpace, this.latticeSpace, this.latticeSpace, this.apparatusPanel, this.getModelViewTransform());
        }
        this.apparatusPanel.addGraphic(this.fieldLattiveView, 5.0);
    }

    public MicrowavesModel getMicrowaveModel() {
        return this.microwaveModel;
    }

    public void setMicrowaveFrequency(double d) {
        if (this.isMicrowaveOn) {
            this.microwaveModel.setMicrowaveFrequency(d);
        } else {
            this.savedFreq = (float)d;
        }
    }

    public void setMicrowaveAmplitude(double d) {
        if (this.isMicrowaveOn) {
            this.microwaveModel.setMicrowaveAmplitude(d);
        } else {
            this.savedAmp = (float)d;
        }
    }

    public void toggleMicrowave() {
        boolean bl = this.isMicrowaveOn = !this.isMicrowaveOn;
        if (this.isMicrowaveOn) {
            this.turnMicrowaveOn(this.savedFreq, this.savedAmp);
        } else {
            this.turnMicrowaveOff();
        }
    }

    public void turnMicrowaveOn(double d, double d2) {
        this.microwaveModel.setMicrowaveFrequency(d);
        this.microwaveModel.setMicrowaveAmplitude(d2);
    }

    public void turnMicrowaveOff() {
        this.savedFreq = (float)this.microwaveModel.getFrequency();
        this.savedAmp = (float)this.microwaveModel.getAmplitude();
        this.microwaveModel.setMicrowaveFrequency(0.0);
        this.microwaveModel.setMicrowaveAmplitude(0.0);
        this.muWave.setFrequency(0.0f);
        this.muWave.setMaxAmplitude(0.0f);
    }

    public ModelViewTransform2D getModelViewTransform() {
        return this.modelViewTransform;
    }

    public void setFieldViewOff() {
        this.fieldLattiveView.setViewOff();
    }

    public void setFieldViewFull() {
        this.fieldLattiveView.setViewFull();
    }

    public void setFieldViewSingle() {
        this.fieldLattiveView.setViewSingle();
    }

    public void setFiledViewSpline() {
        this.fieldLattiveView.setViewSpline();
    }

    public double getMicrowaveFrequency() {
        return this.microwaveModel.getFrequency();
    }

    public double getMicrowaveAmplitude() {
        return this.microwaveModel.getAmplitude();
    }

    public static class ControlMenu
    extends JMenu {
        public ControlMenu() {
            super(MicrowavesResources.getString("MicrowaveModule.ControlMenu"));
            JMenuItem jMenuItem = new JMenuItem(MicrowavesResources.getString("MicrowaveModule.PhysicalParametersMenuItem"));
            this.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PhysicalParamsDlg physicalParamsDlg = new PhysicalParamsDlg();
                    physicalParamsDlg.setVisible(true);
                }
            });
        }
    }

    static class PhysicalParamsDlg
    extends PaintImmediateDialog {
        private JTextField cTF;
        private JTextField dTF;

        PhysicalParamsDlg() {
            super(PhetApplication.getInstance().getPhetFrame());
            SwingUtils.centerDialogInParent(this);
            final JSlider jSlider = new JSlider(0, 0, 100, 50);
            final ModelViewTx1D modelViewTx1D = new ModelViewTx1D(0.0, WaterMolecule.s_c, 0, 100);
            jSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    WaterMolecule.s_c = modelViewTx1D.viewToModel(jSlider.getValue());
                    PhysicalParamsDlg.this.cTF.setText(Double.toString(WaterMolecule.s_c));
                }
            });
            final JSlider jSlider2 = new JSlider(0, 0, 100, 50);
            final ModelViewTx1D modelViewTx1D2 = new ModelViewTx1D(0.0, WaterMolecule.s_b, 0, 100);
            jSlider2.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    WaterMolecule.s_b = modelViewTx1D2.viewToModel(jSlider2.getValue());
                    PhysicalParamsDlg.this.dTF.setText(Double.toString(WaterMolecule.s_b));
                }
            });
            this.getContentPane().setLayout(new GridBagLayout());
            int n = 0;
            try {
                SwingUtils.addGridBagComponent(this.getContentPane(), new JLabel(MicrowavesResources.getString("MicrowaveModule.PolarSesitivityLabel")), 0, n++, 1, 1, 0, 10);
                SwingUtils.addGridBagComponent(this.getContentPane(), jSlider, 0, n++, 1, 1, 0, 10);
                this.cTF = new JTextField(Double.toString(modelViewTx1D.viewToModel(jSlider.getValue())), 10);
                SwingUtils.addGridBagComponent(this.getContentPane(), this.cTF, 0, n++, 1, 1, 0, 10);
                SwingUtils.addGridBagComponent(this.getContentPane(), new JLabel(MicrowavesResources.getString("MicrowaveModule.DampingLabel")), 0, n++, 1, 1, 0, 10);
                SwingUtils.addGridBagComponent(this.getContentPane(), jSlider2, 0, n++, 1, 1, 0, 10);
                this.dTF = new JTextField(Double.toString(modelViewTx1D2.viewToModel(jSlider2.getValue())), 10);
                SwingUtils.addGridBagComponent(this.getContentPane(), this.dTF, 0, n++, 1, 1, 0, 10);
            }
            catch (AWTException aWTException) {
                aWTException.printStackTrace();
            }
            this.pack();
        }
    }
}

