/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.view;

import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.microwaves.MicrowaveModule;
import edu.colorado.phet.microwaves.MicrowavesResources;
import edu.colorado.phet.microwaves.coreadditions.MeasuringTape;
import edu.colorado.phet.microwaves.model.MicrowavesModel;
import edu.colorado.phet.microwaves.view.MicrowaveLegend;
import java.awt.AWTException;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MicrowaveControlPanel
extends JPanel {
    MicrowavesModel model;
    MicrowaveModule module;
    private JRadioButton noFieldViewRB;
    private JRadioButton fullViewRB;
    private JRadioButton singleViewRB;
    private ButtonGroup fieldViewBtnGrp;
    private JRadioButton splineViewRB;
    private LinearValueControl frequencyControl;
    private LinearValueControl amplitudeControl;
    private ActionListener fieldViewActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton jRadioButton = SwingUtils.getSelection(MicrowaveControlPanel.this.fieldViewBtnGrp);
            if (jRadioButton == MicrowaveControlPanel.this.noFieldViewRB) {
                MicrowaveControlPanel.this.module.setFieldViewOff();
            }
            if (jRadioButton == MicrowaveControlPanel.this.fullViewRB) {
                MicrowaveControlPanel.this.module.setFieldViewFull();
            }
            if (jRadioButton == MicrowaveControlPanel.this.singleViewRB) {
                MicrowaveControlPanel.this.module.setFieldViewSingle();
            }
            if (jRadioButton == MicrowaveControlPanel.this.splineViewRB) {
                MicrowaveControlPanel.this.module.setFieldViewSingle();
                MicrowaveControlPanel.this.module.setFiledViewSpline();
            }
        }
    };

    public MicrowaveControlPanel(MicrowaveModule microwaveModule, MicrowavesModel microwavesModel) {
        this.module = microwaveModule;
        this.model = microwavesModel;
        this.layoutPanel();
    }

    private void layoutPanel() {
        this.frequencyControl = new LinearValueControl(0.0, 0.003, this.module.getMicrowaveFrequency(), MicrowavesResources.getString("MicrowaveControlPanel.FrequencyLabel"), "0.00000", "");
        this.amplitudeControl = new LinearValueControl(0.0, 0.5, this.module.getMicrowaveAmplitude(), MicrowavesResources.getString("MicrowaveControlPanel.AmplitudeLabel"), "0.00", "");
        this.frequencyControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MicrowaveControlPanel.this.module.setMicrowaveFrequency(MicrowaveControlPanel.this.frequencyControl.getValue());
            }
        });
        this.amplitudeControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MicrowaveControlPanel.this.module.setMicrowaveAmplitude(MicrowaveControlPanel.this.amplitudeControl.getValue());
            }
        });
        JButton jButton = new JButton(MicrowavesResources.getString("MicrowaveControlPanel.MicrowaveOnOffButton"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MicrowaveControlPanel.this.module.toggleMicrowave();
            }
        });
        this.noFieldViewRB = new JRadioButton(MicrowavesResources.getString("MicrowaveControlPanel.NoneRadioButton"));
        this.noFieldViewRB.addActionListener(this.fieldViewActionListener);
        this.fullViewRB = new JRadioButton(MicrowavesResources.getString("MicrowaveControlPanel.FullFieldRadioButton"));
        this.fullViewRB.addActionListener(this.fieldViewActionListener);
        this.singleViewRB = new JRadioButton(MicrowavesResources.getString("MicrowaveControlPanel.SingleLineRadioButton"));
        this.singleViewRB.addActionListener(this.fieldViewActionListener);
        this.splineViewRB = new JRadioButton(MicrowavesResources.getString("MicrowaveControlPanel.CurveRadioButton"));
        this.splineViewRB.addActionListener(this.fieldViewActionListener);
        this.fieldViewBtnGrp = new ButtonGroup();
        this.fieldViewBtnGrp.add(this.fullViewRB);
        this.fieldViewBtnGrp.add(this.singleViewRB);
        this.fieldViewBtnGrp.add(this.splineViewRB);
        this.fieldViewBtnGrp.add(this.noFieldViewRB);
        this.setDefaults();
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        try {
            SwingUtils.addGridBagComponent(jPanel, this.splineViewRB, 0, n++, 1, 1, 2, 10);
            SwingUtils.addGridBagComponent(jPanel, this.singleViewRB, 0, n++, 1, 1, 2, 10);
            SwingUtils.addGridBagComponent(jPanel, this.fullViewRB, 0, n++, 1, 1, 2, 10);
            SwingUtils.addGridBagComponent(jPanel, this.noFieldViewRB, 0, n++, 1, 1, 2, 10);
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
        }
        jPanel.setBorder(BorderFactory.createTitledBorder(MicrowavesResources.getString("MicrowaveControlPanel.FieldViewBorderTitle")));
        JToggleButton jToggleButton = new JToggleButton(MicrowavesResources.getString("MicrowaveControlPanel.MeasureToggleButton"));
        jToggleButton.addActionListener(new ActionListener(){
            MeasuringTape mt = null;

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        JButton jButton2 = new JButton(MicrowavesResources.getString("MicrowaveControlPanel.ResetButton"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MicrowaveControlPanel.this.module.reset();
                MicrowaveControlPanel.this.reset();
            }
        });
        EmptyBorder emptyBorder = (EmptyBorder)BorderFactory.createEmptyBorder();
        this.setBorder(emptyBorder);
        this.setLayout(new GridBagLayout());
        int n2 = 0;
        try {
            SwingUtils.addGridBagComponent(this, new MicrowaveLegend(), 0, n2++, 1, 1, 2, 10);
            SwingUtils.addGridBagComponent(this, jButton, 0, n2++, 1, 1, 0, 10);
            SwingUtils.addGridBagComponent(this, this.frequencyControl, 0, n2++, 1, 1, 0, 10);
            SwingUtils.addGridBagComponent(this, this.amplitudeControl, 0, n2++, 1, 1, 0, 10);
            SwingUtils.addGridBagComponent(this, jPanel, 0, n2++, 1, 1, 2, 10);
            SwingUtils.addGridBagComponent(this, jButton2, 0, n2++, 1, 1, 0, 10);
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
        }
    }

    public void reset() {
        this.setDefaults();
    }

    protected void setDefaults() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MicrowaveControlPanel.this.splineViewRB.setSelected(true);
                MicrowaveControlPanel.this.fieldViewActionListener.actionPerformed(null);
                MicrowaveControlPanel.this.frequencyControl.setValue(MicrowaveControlPanel.this.module.getMicrowaveFrequency());
                MicrowaveControlPanel.this.amplitudeControl.setValue(MicrowaveControlPanel.this.module.getMicrowaveAmplitude());
            }
        });
    }
}

