/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.model;

import edu.colorado.phet.common.phetcommon.math.MedianFilter;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.microwaves.model.MicrowavesModel;
import edu.colorado.phet.microwaves.model.WaterMolecule;
import java.awt.geom.Point2D;
import java.util.Observable;

public class Thermometer
extends Observable
implements ModelElement {
    private MicrowavesModel model;
    private Point2D.Double location = new Point2D.Double();
    private double[] history = new double[5];

    public Thermometer(MicrowavesModel microwavesModel) {
        this.model = microwavesModel;
    }

    public void stepInTime(double d) {
        int n;
        double d2 = 0.0;
        for (n = 0; n < this.model.numModelElements(); ++n) {
            ModelElement modelElement = this.model.modelElementAt(n);
            if (!(modelElement instanceof WaterMolecule)) continue;
            WaterMolecule waterMolecule = (WaterMolecule)modelElement;
            double d3 = waterMolecule.getVelocity().getLength();
            d2 += waterMolecule.getMass() * d3 * d3 / 2.0;
            d2 += waterMolecule.getMomentOfInertia() * waterMolecule.getOmega() * waterMolecule.getOmega() / 2.0;
        }
        d2 /= (double)this.model.numModelElements();
        d2 /= 3.0;
        for (n = 4; n > 0; --n) {
            this.history[n] = this.history[n - 1];
        }
        this.history[0] = d2;
        Double d4 = new Double(MedianFilter.getMedian(this.history));
        this.setChanged();
        this.notifyObservers(d4);
    }

    public void setLocation(Point2D.Double double_) {
        this.location = double_;
    }
}

