/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.coreadditions;

import edu.colorado.phet.microwaves.coreadditions.Body;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class CompositeBody
extends Body {
    private ArrayList bodies = new ArrayList();
    private Point2D.Double cm = new Point2D.Double();

    public void addBody(Body body) {
        this.bodies.add(body);
        this.setMass(this.getMass() + body.getMass());
    }

    public Point2D.Double getCM() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.bodies.size(); ++i) {
            Body body = (Body)this.bodies.get(i);
            double d4 = body.getMass();
            d += d4 * body.getCM().getX();
            d2 += d4 * body.getCM().getY();
            d3 += d4;
        }
        this.cm.setLocation(d / d3, d2 / d3);
        return this.cm;
    }

    public double getMomentOfInertia() {
        double d = 0.0;
        Point2D.Double double_ = this.getCM();
        for (int i = 0; i < this.bodies.size(); ++i) {
            Body body = (Body)this.bodies.get(i);
            double d2 = double_.distance(body.getCM());
            double d3 = body.getMomentOfInertia() + body.getMass() * d2 * d2;
            d += d3;
        }
        return d;
    }
}

