/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.coreadditions;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.microwaves.coreadditions.Vector2D;
import java.awt.geom.Point2D;
import java.util.Observable;

public abstract class Body
extends Observable
implements ModelElement {
    private double omega;
    private double alpha;
    private double mass;
    private Point2D.Double location = new Point2D.Double();
    private Vector2D velocity = new Vector2D();
    private Vector2D acceleration = new Vector2D();
    private Body lastColidedBody = null;

    protected Body() {
    }

    public Point2D.Double getLocation() {
        return this.location;
    }

    public void setLocation(double d, double d2) {
        this.location.setLocation(d, d2);
    }

    public double getOmega() {
        return this.omega;
    }

    public void setOmega(double d) {
        this.omega = d;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double d) {
        this.alpha = d;
    }

    public Vector2D getVelocity() {
        return this.velocity;
    }

    public void setVelocity(float f, float f2) {
        this.velocity.setX(f);
        this.velocity.setY(f2);
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double d) {
        this.mass = d;
    }

    public void stepInTime(double d) {
        double d2 = this.location.getX() + d * (double)this.velocity.getX() + d * d * (double)this.acceleration.getX() / 2.0;
        double d3 = this.location.getY() + d * (double)this.velocity.getY() + d * d * (double)this.acceleration.getY() / 2.0;
        this.setLocation(d2, d3);
        double d4 = (double)this.velocity.getX() + d * (double)this.acceleration.getX();
        double d5 = (double)this.velocity.getY() + d * (double)this.acceleration.getY();
    }

    public abstract Point2D.Double getCM();

    public abstract double getMomentOfInertia();

    public double getKineticEnergy() {
        return this.getMass() * (double)this.getVelocity().getMagnitudeSq() / 2.0 + this.getMomentOfInertia() * this.omega * this.omega / 2.0;
    }

    public Body getLastColidedBody() {
        return this.lastColidedBody;
    }

    public void setLastColidedBody(Body body) {
        this.lastColidedBody = body;
    }
}

