/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.recordandplayback.gui;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.ToolTipHandler;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.DefaultIconButton;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloTimeControlPanel;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PlayPauseButton;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.RewindButton;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.StepButton;
import edu.colorado.phet.recordandplayback.gui.ModePanel;
import edu.colorado.phet.recordandplayback.gui.PlaybackSpeedSlider;
import edu.colorado.phet.recordandplayback.gui.TimelineNode;
import edu.colorado.phet.recordandplayback.model.RecordAndPlaybackModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordAndPlaybackControlPanel<T>
extends PhetPCanvas {
    private RecordAndPlaybackModel<T> model;
    private JComponent simPanel;
    private PiccoloTimeControlPanel.BackgroundNode backgroundNode = new PiccoloTimeControlPanel.BackgroundNode();
    private JButton clearButton = new JButton(PhetCommonResources.getString("Common.clear"));
    private RewindButton rewind = new RewindButton(50);
    private PSwing clearButtonNode = new PSwing(this.clearButton);
    private PSwing modePanelNode;
    private PlayPauseButton playPause = new PlayPauseButton(75);
    private ToolTipHandler playPauseTooltipHandler = new ToolTipHandler(PhetCommonResources.getString("Common.ClockControlPanel.Pause"), this);
    private StepButton stepButton = new StepButton(50);
    private double stepTimeChange = 0.0;
    private PNode controlLayer;
    protected TimelineNode timelineNode;

    public RecordAndPlaybackControlPanel(RecordAndPlaybackModel<T> recordAndPlaybackModel, JComponent jComponent, double d) {
        this(recordAndPlaybackModel, jComponent, d, Color.blue);
    }

    public RecordAndPlaybackControlPanel(RecordAndPlaybackModel<T> recordAndPlaybackModel, JComponent jComponent, double d, Color color) {
        this(recordAndPlaybackModel, jComponent, color, d);
        this.addControl(new PlaybackSpeedSlider<T>(recordAndPlaybackModel));
    }

    public RecordAndPlaybackControlPanel(final RecordAndPlaybackModel<T> recordAndPlaybackModel, JComponent jComponent, Color color, double d) {
        this.model = recordAndPlaybackModel;
        this.simPanel = jComponent;
        this.timelineNode = new TimelineNode<T>(recordAndPlaybackModel, this, color, d);
        ModePanel<T> modePanel = new ModePanel<T>(recordAndPlaybackModel);
        this.modePanelNode = new PSwing(modePanel);
        this.setBorder(null);
        this.setBackground(new JPanel().getBackground());
        this.addScreenChild(this.backgroundNode);
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                recordAndPlaybackModel.clearHistory();
                recordAndPlaybackModel.setRecord(true);
            }
        });
        this.rewind.addListener(new DefaultIconButton.Listener(){

            public void buttonPressed() {
                recordAndPlaybackModel.setRecord(false);
                recordAndPlaybackModel.rewind();
                recordAndPlaybackModel.setPaused(true);
            }
        });
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                boolean bl = recordAndPlaybackModel.isPlayback() && recordAndPlaybackModel.getNumRecordedPoints() > 0 && recordAndPlaybackModel.getTime() != recordAndPlaybackModel.getMinRecordedTime();
                RecordAndPlaybackControlPanel.this.rewind.setEnabled(bl);
            }
        };
        recordAndPlaybackModel.addObserver(simpleObserver);
        simpleObserver.update();
        this.rewind.addInputEventListener(new ToolTipHandler(PhetCommonResources.getString("Common.rewind"), this));
        this.playPause.addListener(new PlayPauseButton.Listener(){

            public void playbackStateChanged() {
                recordAndPlaybackModel.setPaused(!RecordAndPlaybackControlPanel.this.playPause.isPlaying());
            }
        });
        this.playPause.addInputEventListener(this.playPauseTooltipHandler);
        SimpleObserver simpleObserver2 = new SimpleObserver(){

            public void update() {
                RecordAndPlaybackControlPanel.this.playPause.setPlaying(!recordAndPlaybackModel.isPaused());
                RecordAndPlaybackControlPanel.this.playPauseTooltipHandler.setText(recordAndPlaybackModel.isPaused() ? PhetCommonResources.getString("Common.ClockControlPanel.Play") : PhetCommonResources.getString("Common.ClockControlPanel.Pause"));
            }
        };
        recordAndPlaybackModel.addObserver(simpleObserver2);
        simpleObserver2.update();
        this.stepButton.setEnabled(false);
        this.stepButton.addInputEventListener(new ToolTipHandler(PhetCommonResources.getString("Common.ClockControlPanel.Step"), this));
        recordAndPlaybackModel.addObserver(new SimpleObserver(){

            public void update() {
                boolean bl = recordAndPlaybackModel.getTime() == recordAndPlaybackModel.getMaxRecordedTime();
                RecordAndPlaybackControlPanel.this.stepButton.setEnabled(recordAndPlaybackModel.isPaused() && !bl);
            }
        });
        this.stepButton.addListener(new DefaultIconButton.Listener(){

            public void buttonPressed() {
                recordAndPlaybackModel.step();
            }
        });
        this.addScreenChild(this.timelineNode);
        this.controlLayer = new PNode();
        this.addScreenChild(this.controlLayer);
        this.addControl(this.clearButtonNode);
        this.addControl(this.modePanelNode);
        this.addControl(this.rewind);
        this.addControl(this.playPause);
        this.addControl(this.stepButton);
        this.setPreferredSize(new Dimension((int)this.getLayer().getFullBounds().getWidth(), (int)this.getLayer().getFullBounds().getHeight()));
        jComponent.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                RecordAndPlaybackControlPanel.this.relayout();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                RecordAndPlaybackControlPanel.this.relayout();
            }
        });
        this.relayout();
    }

    public void addControl(PNode pNode) {
        this.controlLayer.addChild(pNode);
        this.relayout();
    }

    private double getControlLayerHeight() {
        double d = this.controlLayer.getChild(0).getFullBounds().getHeight();
        for (int i = 1; i < this.controlLayer.getChildrenCount(); ++i) {
            d = Math.max(d, this.controlLayer.getChild(i).getFullBounds().getHeight());
        }
        return d;
    }

    private void relayout() {
        double d = 0.0;
        for (int i = 0; i < this.controlLayer.getChildrenCount(); ++i) {
            PNode pNode = this.controlLayer.getChild(i);
            pNode.setOffset(d, this.getControlLayerHeight() / 2.0 - pNode.getFullBounds().getHeight() / 2.0);
            double d2 = 2.0;
            d = d + pNode.getFullBounds().getWidth() + d2;
        }
        double d3 = this.playPause.getFullBounds().getCenterX();
        this.controlLayer.setOffset((double)(this.simPanel.getWidth() / 2) - d3, this.timelineNode.getVisible() ? this.timelineNode.getFullBounds().getHeight() : 0.0);
        this.backgroundNode.setSize((int)this.controlLayer.getFullBounds().getWidth() + 4, (int)this.controlLayer.getFullBounds().getHeight() + 2);
        this.backgroundNode.setOffset(this.controlLayer.getOffset().getX() - 2.0, this.controlLayer.getOffset().getY() - 1.0);
        if (this.simPanel.getWidth() > 0) {
            Dimension dimension = new Dimension(this.simPanel.getWidth(), (int)this.getLayer().getFullBounds().getHeight() + 1);
            this.setPreferredSize(dimension);
            if (this.getParent() != null) {
                this.getParent().doLayout();
            }
        }
    }
}

