/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.view;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.model.Human;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;

public class HeartNode
extends PImage {
    private PImage heart;
    private Human human;
    private PhetPPath smilePath;

    public HeartNode(Human human) {
        this.human = human;
        this.heart = new PImage(EatingAndExerciseResources.getImage("heart.png"));
        this.addChild(this.heart);
        double d = 80.0;
        double d2 = 50.0;
        double d3 = 0.4;
        PImage pImage = new PImage(BufferedImageUtils.multiScale(EatingAndExerciseResources.getImage("eye.png"), d3));
        pImage.setOffset(this.heart.getFullBounds().getWidth() / 2.0 - pImage.getFullBounds().getWidth() / 2.0 - d / 2.0, d2);
        this.addChild(pImage);
        PImage pImage2 = new PImage(BufferedImageUtils.multiScale(EatingAndExerciseResources.getImage("eye.png"), d3));
        pImage2.setOffset(this.heart.getFullBounds().getWidth() / 2.0 - pImage2.getFullBounds().getWidth() / 2.0 + d / 2.0, d2);
        this.addChild(pImage2);
        this.smilePath = new PhetPPath(new BasicStroke(14.0f), (Paint)Color.black);
        this.addChild(this.smilePath);
        human.addListener(new Human.Adapter(){

            public void heartHealthChanged() {
                HeartNode.this.updateSmile();
            }
        });
        this.updateSmile();
    }

    private void updateSmile() {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        double d = 0.3;
        double d2 = 0.6;
        double d3 = new Function.LinearFunction(0.0, 1.0, -3.0, 1.0).evaluate(this.human.getHeartHealth());
        d3 = MathUtil.clamp(-0.5, d3, 1.0);
        double d4 = 50.0 * d3;
        doubleGeneralPath.moveTo(this.heart.getFullBounds().getWidth() * d, this.heart.getFullBounds().getHeight() * d2);
        doubleGeneralPath.curveTo(this.heart.getFullBounds().getWidth() * 0.4, this.heart.getFullBounds().getHeight() * d2 + d4, this.heart.getFullBounds().getWidth() * 0.6, this.heart.getFullBounds().getHeight() * d2 + d4, this.heart.getFullBounds().getWidth() * (1.0 - d), this.heart.getFullBounds().getHeight() * d2);
        this.smilePath.setOffset(0.0, d3 < 0.0 ? Math.abs(d3) * 20.0 : 0.0);
        this.smilePath.setPathTo(doubleGeneralPath.getGeneralPath());
    }
}

