/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.view;

import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.model.Human;
import edu.colorado.phet.eatingandexercise.view.IndicatorHealthBar;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;

public class HealthIndicator
extends PNode {
    private IndicatorHealthBar heartStrengthIndicator;
    private IndicatorHealthBar heartStrainIndicator;
    private Human human;

    public HealthIndicator(Human human) {
        this.human = human;
        this.heartStrengthIndicator = new HeartStrengthIndicatorBar(human);
        this.heartStrainIndicator = new HeartStrainIndicatorBar(human);
        this.addChild(this.heartStrengthIndicator);
        this.addChild(this.heartStrainIndicator);
        this.updateLayout();
    }

    private void updateLayout() {
        double d = 4.0;
        this.heartStrainIndicator.setOffset(this.heartStrengthIndicator.getFullBounds().getMaxX() + d, 0.0);
    }

    private static class HeartStrainIndicatorBar
    extends IndicatorHealthBar {
        private Human human;

        public HeartStrainIndicatorBar(Human human) {
            super("<html>" + EatingAndExerciseResources.getString("heart.strain") + "</html>", 0.0, 1.0, 0.16, 0.31, 150.0, Color.green, Color.red);
            this.human = human;
            human.addListener(new Human.Adapter(){

                public void heartStrainChanged() {
                    HeartStrainIndicatorBar.this.updateValue();
                }
            });
            this.updateValue();
        }

        private void updateValue() {
            this.setValue(this.human.getHeartStrain());
        }
    }

    private static class HeartStrengthIndicatorBar
    extends IndicatorHealthBar {
        private Human human;

        public HeartStrengthIndicatorBar(Human human) {
            super("<html>" + EatingAndExerciseResources.getString("heart.strength") + "</html>", 0.0, 1.0, 0.25, 1.0, 150.0, Color.red, Color.green);
            this.human = human;
            human.addListener(new Human.Adapter(){

                public void heartStrengthChanged() {
                    HeartStrengthIndicatorBar.this.updateValue();
                }
            });
            this.updateValue();
        }

        private void updateValue() {
            this.setValue(this.human.getHeartStrength());
        }
    }
}

