/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.module.eatingandexercise;

import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseStrings;
import edu.colorado.phet.eatingandexercise.control.CaloricItem;

public class CaloricFoodItem
extends CaloricItem {
    private double lipids;
    private double carbs;
    private double protein;
    private boolean removable;

    public CaloricFoodItem(String string, String string2, double d, double d2, double d3) {
        this(string, string2, d, d2, d3, true);
    }

    public CaloricFoodItem(String string, String string2, double d, double d2, double d3, boolean bl) {
        super(string, string2, d * 9.0 + d2 * 4.0 + d3 * 4.0);
        this.lipids = d;
        this.carbs = d2;
        this.protein = d3;
        this.removable = bl;
    }

    private double getTotalCalories() {
        return this.getLipidCalories() + this.getCarbCalories() + this.getProteinCalories();
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public double getLipidCalories() {
        return this.lipids * 9.0;
    }

    public double getCarbCalories() {
        return this.carbs * 4.0;
    }

    public double getProteinCalories() {
        return this.protein * 4.0;
    }

    public String toString() {
        return this.getName() + ", calories=" + this.getCalories() + ", lipids=" + this.lipids + ", carbs=" + this.carbs + ", proteins=" + this.protein + ", image=" + this.getImage();
    }

    public String getLabelText() {
        String string = EatingAndExerciseResources.getString("one");
        return "<html>" + string + " " + this.getName() + " <br>(" + EatingAndExerciseStrings.KCAL_PER_DAY_FORMAT.format(this.getCalories()) + " " + EatingAndExerciseStrings.KCAL_PER_DAY + ")</html>";
    }

    public void setTotalCalories(double d) {
        double d2 = d / this.getCalories();
        double d3 = this.getLipidCalories() * d2;
        double d4 = this.getCarbCalories() * d2;
        double d5 = this.getProteinCalories() * d2;
        this.lipids = d3 / 9.0;
        this.carbs = d4 / 4.0;
        this.protein = d5 / 4.0;
        super.setCalories(this.getTotalCalories());
    }

    public Object clone() {
        CaloricFoodItem caloricFoodItem = (CaloricFoodItem)super.clone();
        caloricFoodItem.lipids = this.lipids;
        caloricFoodItem.carbs = this.carbs;
        caloricFoodItem.protein = this.protein;
        caloricFoodItem.removable = this.removable;
        return caloricFoodItem;
    }
}

