/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.control;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseStrings;
import edu.colorado.phet.eatingandexercise.control.BalancedDietDialog;
import edu.colorado.phet.eatingandexercise.control.CaloricItem;
import edu.colorado.phet.eatingandexercise.control.CaloricItemLabelNode;
import edu.colorado.phet.eatingandexercise.control.TogglePClip;
import edu.colorado.phet.eatingandexercise.model.CalorieSet;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.CaloricFoodItem;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.Timer;

public class CalorieDragStrip
extends PNode {
    private static Random random = new Random();
    private ArrayList listeners = new ArrayList();
    private PNode tooltipLayer = new PNode();
    private PNode stripPanel;
    public static int ITEMS_PER_PAGE = 4;
    private int count = ITEMS_PER_PAGE + 1;
    private ArrayList panels = new ArrayList();
    private Color buttonColor = new Color(128, 128, 255);
    private TogglePClip stripPanelClip;
    private ArrayList balancedDietDialogs = new ArrayList();
    private Timer scrollTimer = null;

    public CalorieDragStrip(CalorieSet calorieSet) {
        for (int i = 0; i < calorieSet.getItemCount(); i += this.count) {
            this.panels.add(this.getPanel(calorieSet, i, Math.min(i + this.count, calorieSet.getItemCount())));
        }
        this.stripPanelClip = new TogglePClip();
        this.stripPanel = (PNode)this.panels.get(0);
        this.stripPanelClip.addChild(this.stripPanel);
        this.stripPanelClip.setPaint(new Color(200, 220, 220));
        PhetFont phetFont = new PhetFont(1, 13);
        HTMLImageButtonNode hTMLImageButtonNode = new HTMLImageButtonNode(EatingAndExerciseResources.getString("control.more.right"), phetFont, this.buttonColor);
        hTMLImageButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalorieDragStrip.this.nextPanel(1);
            }
        });
        this.addChild(hTMLImageButtonNode);
        hTMLImageButtonNode.setOffset(this.getMaxPanelWidth(), this.getMaxPanelHeight() / 2.0 - hTMLImageButtonNode.getFullBounds().getHeight() / 2.0);
        HTMLImageButtonNode hTMLImageButtonNode2 = new HTMLImageButtonNode(EatingAndExerciseResources.getString("control.more.left"), phetFont, this.buttonColor);
        hTMLImageButtonNode2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalorieDragStrip.this.nextPanel(-1);
            }
        });
        this.addChild(hTMLImageButtonNode2);
        this.addChild(this.stripPanelClip);
        hTMLImageButtonNode2.setOffset(-hTMLImageButtonNode2.getFullBounds().getWidth(), this.getMaxPanelHeight() / 2.0 - hTMLImageButtonNode2.getFullBounds().getHeight() / 2.0);
        this.centerItems();
        this.stripPanelClip.setPathTo(new Rectangle2D.Double(0.0, 0.0, this.getMaxPanelWidth(), this.getMaxPanelHeight()));
    }

    private void centerItems() {
        for (int i = 0; i < this.panels.size(); ++i) {
            PNode pNode = (PNode)this.panels.get(i);
            for (int j = 0; j < pNode.getChildrenCount(); ++j) {
                PNode pNode2 = pNode.getChild(j);
                if (!(pNode2 instanceof DefaultDragNode)) continue;
                pNode2.setOffset(this.getMaxPanelWidth() / 2.0 - pNode2.getFullBounds().getWidth() / 2.0, pNode2.getOffset().getY());
            }
        }
    }

    public double getStripPanelWidth() {
        return this.stripPanelClip.getFullBounds().getWidth();
    }

    private double getMaxPanelHeight() {
        double d = Double.NaN;
        for (int i = 0; i < this.panels.size(); ++i) {
            PNode pNode = (PNode)this.panels.get(i);
            if (!Double.isNaN(d) && !(pNode.getFullBounds().getHeight() > d)) continue;
            d = pNode.getFullBounds().getHeight();
        }
        return d;
    }

    private double getMaxPanelWidth() {
        double d = Double.NaN;
        for (int i = 0; i < this.panels.size(); ++i) {
            PNode pNode = (PNode)this.panels.get(i);
            if (!Double.isNaN(d) && !(pNode.getFullBounds().getWidth() > d)) continue;
            d = pNode.getFullBounds().getWidth();
        }
        return d;
    }

    private void nextPanel(final int n) {
        if (this.scrollTimer != null && this.scrollTimer.isRunning()) {
            return;
        }
        this.stripPanelClip.setClipEnabled(true);
        final PNode pNode = this.stripPanel;
        this.stripPanel = (PNode)this.panels.get(this.nextIndex(n));
        this.stripPanelClip.addChild(this.stripPanel);
        this.stripPanel.setOffset(100 * n, 0.0);
        this.scrollTimer = new Timer(30, null);
        this.scrollTimer.addActionListener(new ActionListener(){
            int count = 0;

            public void actionPerformed(ActionEvent actionEvent) {
                pNode.translate(-10 * n, 0.0);
                CalorieDragStrip.this.stripPanel.translate(-10 * n, 0.0);
                ++this.count;
                if (this.count >= 10) {
                    CalorieDragStrip.this.stripPanelClip.removeChild(pNode);
                    CalorieDragStrip.this.stripPanelClip.setClipEnabled(false);
                    CalorieDragStrip.this.scrollTimer.stop();
                }
            }
        });
        this.scrollTimer.start();
    }

    private int nextIndex(int n) {
        int n2 = this.panels.indexOf(this.stripPanel);
        int n3 = n2 + n;
        if (n3 >= this.panels.size()) {
            n3 = 0;
        }
        if (n3 < 0) {
            n3 = this.panels.size() - 1;
        }
        return n3;
    }

    private PNode getPanel(final CalorieSet calorieSet, int n, int n2) {
        int n3;
        int n4;
        ArrayList<DefaultDragNode> arrayList = new ArrayList<DefaultDragNode>();
        PNode pNode = new PNode();
        int n5 = n;
        while (n5 < n2) {
            final DefaultDragNode defaultDragNode = this.createNode(calorieSet.getItem(n5));
            n4 = n5++;
            defaultDragNode.addInputEventListener(new PDragSequenceEventHandler(){
                private DefaultDragNode createdNode = null;

                protected void startDrag(PInputEvent pInputEvent) {
                    super.startDrag(pInputEvent);
                    CaloricItem caloricItem = (CaloricItem)calorieSet.getItem(n4).clone();
                    this.createdNode = CalorieDragStrip.this.createNode(caloricItem);
                    this.createdNode.addDragHandler();
                    this.createdNode.getPNode().setOffset(defaultDragNode.getOffset());
                    this.createdNode.setDragging(true);
                    CalorieDragStrip.this.addChild(this.createdNode.getPNode());
                }

                public void mousePressed(PInputEvent pInputEvent) {
                    super.mousePressed(pInputEvent);
                    CalorieDragStrip.this.notifyPressed();
                }

                protected void drag(PInputEvent pInputEvent) {
                    super.drag(pInputEvent);
                    this.createdNode.getPNode().translate(pInputEvent.getDelta().getWidth(), pInputEvent.getDelta().getHeight());
                    CalorieDragStrip.this.notifyDragged(this.createdNode);
                }

                protected void endDrag(PInputEvent pInputEvent) {
                    super.endDrag(pInputEvent);
                    this.createdNode.setDragging(false);
                    CalorieDragStrip.this.notifyDropped(this.createdNode);
                }
            });
            arrayList.add(defaultDragNode);
        }
        n5 = 1;
        for (n3 = 1; n3 < arrayList.size(); ++n3) {
            n4 = n3 / n5;
            int n6 = n3 % n5;
            PNode pNode2 = (PNode)arrayList.get(n3);
            PNode pNode3 = (PNode)arrayList.get(n3 - 1);
            pNode2.setOffset(n6 == 0 ? 0.0 : pNode3.getFullBounds().getMaxX(), n4 * 45);
        }
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            pNode.addChild((PNode)arrayList.get(n3));
        }
        return pNode;
    }

    private void notifyPressed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).nodePressed();
        }
    }

    public PNode getTooltipLayer() {
        return this.tooltipLayer;
    }

    public void itemRemoved(CaloricItem caloricItem) {
        for (int i = 0; i < this.getChildrenCount(); ++i) {
            DefaultDragNode defaultDragNode;
            PNode pNode = this.getChild(i);
            if (!(pNode instanceof DefaultDragNode) || (defaultDragNode = (DefaultDragNode)pNode).isDragging() || defaultDragNode.getItem() != caloricItem) continue;
            this.removeChild(pNode);
            --i;
        }
    }

    public PNode addItemNode(CaloricItem caloricItem) {
        DefaultDragNode defaultDragNode = this.createNode(caloricItem);
        defaultDragNode.addDragHandler();
        this.addChild(defaultDragNode);
        return defaultDragNode.getPNode();
    }

    public void resetAll() {
        int n;
        for (n = 0; n < this.getChildrenCount(); ++n) {
            DefaultDragNode defaultDragNode;
            PNode pNode = this.getChild(n);
            if (!(pNode instanceof DefaultDragNode) || (defaultDragNode = (DefaultDragNode)pNode).isDragging()) continue;
            this.removeChild(pNode);
            --n;
        }
        for (n = 0; n < this.balancedDietDialogs.size(); ++n) {
            ((BalancedDietDialog)this.balancedDietDialogs.get(n)).resetAll();
        }
        this.balancedDietDialogs.clear();
    }

    private DefaultDragNode createNode(CaloricItem caloricItem) {
        if (caloricItem.getImage() != null && caloricItem.getImage().trim().length() > 0) {
            DefaultDragNode defaultDragNode = new DefaultDragNode(new PImage(BufferedImageUtils.multiScaleToHeight(EatingAndExerciseResources.getImage(caloricItem.getImage()), 45)), caloricItem);
            if (caloricItem.getImage().equals("food-pyramid.png") && caloricItem instanceof CaloricFoodItem) {
                this.decorateFoodPyramid((CaloricFoodItem)caloricItem, defaultDragNode);
            }
            return defaultDragNode;
        }
        return new DefaultDragNode(new PhetPPath((Shape)new Rectangle(0, 0, 10, 10), (Paint)new Color(random.nextInt(255), random.nextInt(255), random.nextInt(255))), caloricItem);
    }

    private void decorateFoodPyramid(CaloricFoodItem caloricFoodItem, DefaultDragNode defaultDragNode) {
        final BalancedDietDialog balancedDietDialog = new BalancedDietDialog(caloricFoodItem);
        this.balancedDietDialogs.add(balancedDietDialog);
        HTMLImageButtonNode hTMLImageButtonNode = new HTMLImageButtonNode(EatingAndExerciseResources.getString("edit.edit"), new PhetFont(1, 12), Color.red);
        hTMLImageButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                balancedDietDialog.setVisible(true);
            }
        });
        defaultDragNode.addChild(hTMLImageButtonNode);
        hTMLImageButtonNode.setOffset(defaultDragNode.getFullBounds().getMaxX() - hTMLImageButtonNode.getFullBounds().getWidth() / 2.0, defaultDragNode.getFullBounds().getY());
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyDropped(DragNode dragNode) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).nodeDropped(dragNode);
        }
    }

    public void notifyDragged(DragNode dragNode) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).nodeDragged(dragNode);
        }
    }

    public static class Adapter
    implements Listener {
        public void nodeDropped(DragNode dragNode) {
        }

        public void nodeDragged(DragNode dragNode) {
        }

        public void nodePressed() {
        }
    }

    private class DefaultDragNode
    extends PNode
    implements DragNode {
        private CaloricItem item;
        private PNode node;
        private boolean dragging = false;
        private CaloricItemLabelNode labelNode;

        public DefaultDragNode(PNode pNode, CaloricItem caloricItem) {
            this.item = caloricItem;
            this.node = pNode;
            this.addChild(pNode);
            this.addInputEventListener(new CursorHandler());
            this.labelNode = new CaloricItemLabelNode(this.getLabelText());
            caloricItem.addListener(new CaloricItem.Listener(){

                public void caloriesChanged() {
                    DefaultDragNode.this.labelNode.setText(DefaultDragNode.this.getLabelText());
                }
            });
            this.labelNode.setOffset(-this.labelNode.getFullBounds().getWidth() - 3.0, pNode.getFullBounds().getHeight() / 2.0 - this.labelNode.getFullBounds().getHeight() / 2.0);
            this.addInputEventListener(new PBasicInputEventHandler(){

                public void mouseEntered(PInputEvent pInputEvent) {
                    if (!DefaultDragNode.this.getChildrenReference().contains(DefaultDragNode.this.labelNode)) {
                        DefaultDragNode.this.addChild(DefaultDragNode.this.labelNode);
                    }
                }

                public void mouseExited(PInputEvent pInputEvent) {
                    while (DefaultDragNode.this.getChildrenReference().contains(DefaultDragNode.this.labelNode)) {
                        DefaultDragNode.this.removeChild(DefaultDragNode.this.labelNode);
                    }
                }
            });
        }

        private String getLabelText() {
            return "<html>" + this.item.getName() + " (" + EatingAndExerciseStrings.KCAL_PER_DAY_FORMAT.format(this.item.getCalories()) + " " + EatingAndExerciseResources.getString("units.cal") + ")</html>";
        }

        public void addDragHandler() {
            this.node.addInputEventListener(new PDragSequenceEventHandler(){

                protected void startDrag(PInputEvent pInputEvent) {
                    super.startDrag(pInputEvent);
                    DefaultDragNode.this.setDragging(true);
                    DefaultDragNode.this.moveToFront();
                }

                protected void drag(PInputEvent pInputEvent) {
                    super.drag(pInputEvent);
                    DefaultDragNode.this.setDragging(true);
                    DefaultDragNode.this.getPNode().translate(pInputEvent.getDelta().getWidth(), pInputEvent.getDelta().getHeight());
                    CalorieDragStrip.this.notifyDragged(DefaultDragNode.this);
                }

                protected void endDrag(PInputEvent pInputEvent) {
                    DefaultDragNode.this.setDragging(false);
                    CalorieDragStrip.this.notifyDropped(DefaultDragNode.this);
                }
            });
        }

        public boolean isDragging() {
            return this.dragging;
        }

        public PNode getPNode() {
            return this;
        }

        public CaloricItem getItem() {
            return this.item;
        }

        public PNode getPNodeIcon() {
            return this.node;
        }

        public void setDragging(boolean bl) {
            this.dragging = bl;
        }
    }

    public static interface DragNode {
        public PNode getPNode();

        public CaloricItem getItem();

        public PNode getPNodeIcon();
    }

    public static interface Listener {
        public void nodeDropped(DragNode var1);

        public void nodeDragged(DragNode var1);

        public void nodePressed();
    }
}

