/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.control;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.swing.PhetJComboBox;
import edu.colorado.phet.eatingandexercise.control.Activity;
import edu.colorado.phet.eatingandexercise.model.Human;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.EatingAndExerciseCanvas;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class ActivityLevelComboBox
extends PhetJComboBox {
    private EatingAndExerciseCanvas canvas;
    private Human human;

    public ActivityLevelComboBox(EatingAndExerciseCanvas eatingAndExerciseCanvas, final Human human) {
        this.human = human;
        this.canvas = eatingAndExerciseCanvas;
        for (int i = 0; i < Activity.DEFAULT_ACTIVITY_LEVELS.length; ++i) {
            this.addItem(Activity.DEFAULT_ACTIVITY_LEVELS[i]);
        }
        this.updateSelectedItem();
        this.setFont(new PhetFont(13, true));
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                human.setActivityLevel((Activity)itemEvent.getItem());
            }
        });
        this.setUI(new MyComboBoxUI());
        human.addListener(new Human.Adapter(){

            public void activityLevelChanged() {
                ActivityLevelComboBox.this.updateSelectedItem();
            }
        });
    }

    private void updateSelectedItem() {
        for (int i = 0; i < Activity.DEFAULT_ACTIVITY_LEVELS.length; ++i) {
            if (Activity.DEFAULT_ACTIVITY_LEVELS[i].getValue() != this.human.getActivityLevel()) continue;
            this.setSelectedItem(Activity.DEFAULT_ACTIVITY_LEVELS[i]);
        }
    }

    protected class MyComboBoxUI
    extends BasicComboBoxUI {
        protected MyComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new MyComboPopup(this.comboBox);
        }
    }

    protected class MyComboPopup
    extends BasicComboPopup {
        public MyComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
            Rectangle rectangle = super.computePopupBounds(n, n2, n3, n4);
            double d = ActivityLevelComboBox.this.canvas.getControlPanelY();
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, d + (double)rectangle.y, 0.0, 0.0);
            return new Rectangle((int)((RectangularShape)double_).getX(), (int)double_.getMaxY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
        }
    }
}

