/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.model.IVariable;
import java.util.ArrayList;

public class DefaultVariable
implements IVariable {
    private double value;
    private ArrayList<IVariable.Listener> listeners = new ArrayList();

    public DefaultVariable(double d) {
        this.value = d;
    }

    public void setValue(double d) {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("NaN");
        }
        if (!this.equals(d, this.value)) {
            this.value = d;
            for (IVariable.Listener listener : this.listeners) {
                listener.valueChanged();
            }
        }
    }

    private boolean equals(double d, double d2) {
        return d == d2 || Double.isNaN(d) && Double.isNaN(d2);
    }

    public void addListener(IVariable.Listener listener) {
        this.listeners.add(listener);
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        return this.value + "";
    }
}

