/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;

public abstract class AbstractDoubleSquareMatrix
extends AbstractDoubleMatrix {
    protected AbstractDoubleSquareMatrix(int n) {
        super(n, n);
    }

    public AbstractDoubleSquareMatrix[] choleskyDecompose() {
        int n;
        double d;
        int n2 = this.numRows;
        double[][] dArray = new double[n2][n2];
        double[][] dArray2 = new double[n2][n2];
        double d2 = d = Math.sqrt(this.getElement(0, 0));
        dArray2[0][0] = d2;
        dArray[0][0] = d2;
        for (n = 1; n < n2; ++n) {
            double d3 = this.getElement(n, 0) / d;
            dArray2[0][n] = d3;
            dArray[n][0] = d3;
        }
        for (n = 1; n < n2; ++n) {
            int n3;
            d = this.getElement(n, n);
            for (n3 = 0; n3 < n; ++n3) {
                d -= dArray[n][n3] * dArray[n][n3];
            }
            double d4 = Math.sqrt(d);
            dArray2[n][n] = d4;
            dArray[n][n] = d4;
            for (n3 = n + 1; n3 < n2; ++n3) {
                d = this.getElement(n3, n);
                for (int i = 0; i < n3; ++i) {
                    d -= dArray[n][i] * dArray2[i][n3];
                }
                double d5 = d / dArray2[n][n];
                dArray2[n][n3] = d5;
                dArray[n3][n] = d5;
            }
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray), new DoubleSquareMatrix(dArray2)};
        return abstractDoubleSquareMatrixArray;
    }
}

