/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.control.valuenode;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.piccolophet.nodes.SliderNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class LinearValueControlNode
extends PNode {
    private PText labelNode;
    private PSwing readoutNode;
    private SliderNode sliderNode;
    private PText unitsNode;
    private int SPACING = 5;
    private double value;
    private JFormattedTextField formattedTextField;
    private NumberFormat numberFormat;
    private double min;
    private double max;
    private LayoutStrategy layoutStrategy = new DefaultLayoutStrategy();
    private ArrayList listeners = new ArrayList();
    private Timer expirationTimer;

    public LinearValueControlNode(String string, String string2, double d, double d2, double d3, NumberFormat numberFormat) {
        this.min = d;
        this.max = d2;
        this.numberFormat = numberFormat;
        this.value = d3;
        this.labelNode = new PText(string);
        this.labelNode.setFont(new JLabel().getFont());
        this.addChild(this.labelNode);
        this.formattedTextField = new JFormattedTextField(numberFormat);
        this.formattedTextField.setColumns(4);
        this.formattedTextField.setValue(new Double(d3));
        this.formattedTextField.setHorizontalAlignment(4);
        this.formattedTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    LinearValueControlNode.this.setValueAndNotifyModel(LinearValueControlNode.this.parseText(), true);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
            }
        });
        this.expirationTimer = new Timer(3000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LinearValueControlNode.this.formattedTextField.setValue(new Double(LinearValueControlNode.this.getValue()));
            }
        });
        this.expirationTimer.setRepeats(false);
        this.formattedTextField.addKeyListener(new KeyAdapter(){});
        this.formattedTextField.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LinearValueControlNode.this.formattedTextField.setSelectionEnd(0);
                        LinearValueControlNode.this.formattedTextField.setSelectionEnd(LinearValueControlNode.this.formattedTextField.getText().length());
                    }
                });
            }
        });
        this.formattedTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            double d = LinearValueControlNode.this.parseText();
                            if (d >= LinearValueControlNode.this.min && d <= LinearValueControlNode.this.max) {
                                LinearValueControlNode.this.setValueAndNotifyModel(d, false);
                            }
                        }
                        catch (ParseException parseException) {
                            parseException.printStackTrace();
                        }
                        LinearValueControlNode.this.formattedTextField.setValue(new Double(LinearValueControlNode.this.getValue()));
                    }
                });
            }
        });
        this.formattedTextField.setPreferredSize(this.formattedTextField.getPreferredSize());
        this.readoutNode = new PSwing(this.formattedTextField);
        this.addChild(this.readoutNode);
        this.unitsNode = new PText(string2);
        this.unitsNode.setFont(new JLabel().getFont());
        this.addChild(this.unitsNode);
        this.sliderNode = new SliderNode(d, d2, d3);
        this.sliderNode.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LinearValueControlNode.this.setValueAndNotifyModel(LinearValueControlNode.this.sliderNode.getValue(), true);
            }
        });
        this.addChild(this.sliderNode);
        this.setValueAndNotifyModel(d3, true);
        this.relayout();
    }

    public void setTextFieldColumns(int n) {
        this.formattedTextField.setColumns(n);
        this.readoutNode.updateBounds();
        this.relayout();
    }

    private double parseText() throws ParseException {
        return this.numberFormat.parse(this.formattedTextField.getText()).doubleValue();
    }

    public void setSliderRange(double d, double d2) {
        this.min = d;
        this.max = d2;
        this.sliderNode.setRange(d, d2);
    }

    private void setValue(double d, boolean bl) {
        String string = String.valueOf(d);
        if (this.value != (d = Double.parseDouble(string))) {
            this.value = d;
            if (bl) {
                this.formattedTextField.setValue(new Double(d));
                this.expirationTimer.stop();
            }
            this.sliderNode.setValue(d);
        }
    }

    public void setValue(double d) {
        this.setValue(d, true);
    }

    private void setValueAndNotifyModel(double d, boolean bl) {
        double d2 = this.getValue();
        if (d >= this.min && d <= this.max) {
            this.setValue(d, bl);
            if (this.getValue() != d2) {
                this.notifyListeners();
            }
        } else {
            this.setValue(d2, bl);
            if (bl) {
                this.formattedTextField.setValue(new Double(d2));
            }
        }
    }

    private void relayout() {
        this.layoutStrategy.layout(this);
    }

    private double getMaxChildHeight() {
        double d = 0.0;
        for (int i = 0; i < this.getChildrenCount(); ++i) {
            d = Math.max(this.getChild(i).getFullBounds().getHeight(), d);
        }
        return d;
    }

    public void setUnits(String string) {
        this.unitsNode.setText(string);
    }

    public void setTextFieldFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        this.formattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(numberFormat)));
    }

    public void setLayoutStrategy(LayoutStrategy layoutStrategy) {
        this.layoutStrategy = layoutStrategy;
        this.relayout();
    }

    public LayoutStrategy getGridLayout(LinearValueControlNode[] linearValueControlNodeArray) {
        return new GridLayout(linearValueControlNodeArray);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).valueChanged(this.getValue());
        }
    }

    public double getValue() {
        return this.value;
    }

    public class DefaultLayoutStrategy
    implements LayoutStrategy {
        public void layout(LinearValueControlNode linearValueControlNode) {
            double d = LinearValueControlNode.this.getMaxChildHeight();
            LinearValueControlNode.this.labelNode.setOffset(0.0, d / 2.0 - LinearValueControlNode.this.labelNode.getFullBounds().getHeight() / 2.0);
            LinearValueControlNode.this.readoutNode.setOffset(LinearValueControlNode.this.labelNode.getFullBounds().getMaxX() + (double)LinearValueControlNode.this.SPACING, d / 2.0 - LinearValueControlNode.this.readoutNode.getFullBounds().getHeight() / 2.0);
            LinearValueControlNode.this.unitsNode.setOffset(LinearValueControlNode.this.readoutNode.getFullBounds().getMaxX() + (double)LinearValueControlNode.this.SPACING, d / 2.0 - LinearValueControlNode.this.unitsNode.getFullBounds().getHeight() / 2.0);
            LinearValueControlNode.this.sliderNode.setOffset(LinearValueControlNode.this.unitsNode.getFullBounds().getMaxX() + (double)LinearValueControlNode.this.SPACING, d / 2.0 - LinearValueControlNode.this.sliderNode.getFullBounds().getHeight() / 2.0);
        }
    }

    public static interface Getter {
        public double getValue(LinearValueControlNode var1);
    }

    public class GridLayout
    implements LayoutStrategy {
        private LinearValueControlNode[] nodes;

        public GridLayout(LinearValueControlNode[] linearValueControlNodeArray) {
            this.nodes = linearValueControlNodeArray;
        }

        public void layout(LinearValueControlNode linearValueControlNode) {
            double d = LinearValueControlNode.this.getMaxChildHeight();
            double d2 = this.getMax(new Getter(){

                public double getValue(LinearValueControlNode linearValueControlNode) {
                    return linearValueControlNode.labelNode.getFullBounds().getWidth();
                }
            });
            double d3 = this.getMax(new Getter(){

                public double getValue(LinearValueControlNode linearValueControlNode) {
                    return linearValueControlNode.readoutNode.getFullBounds().getWidth();
                }
            });
            double d4 = this.getMax(new Getter(){

                public double getValue(LinearValueControlNode linearValueControlNode) {
                    return linearValueControlNode.unitsNode.getFullBounds().getWidth();
                }
            });
            double d5 = this.getMax(new Getter(){

                public double getValue(LinearValueControlNode linearValueControlNode) {
                    return linearValueControlNode.sliderNode.getFullBounds().getWidth();
                }
            });
            LinearValueControlNode.this.labelNode.setOffset(0.0, d / 2.0 - LinearValueControlNode.this.labelNode.getFullBounds().getHeight() / 2.0);
            LinearValueControlNode.this.readoutNode.setOffset(d2 + (double)LinearValueControlNode.this.SPACING, d / 2.0 - LinearValueControlNode.this.readoutNode.getFullBounds().getHeight() / 2.0);
            LinearValueControlNode.this.unitsNode.setOffset(d3 + d2 + (double)(LinearValueControlNode.this.SPACING * 2), d / 2.0 - LinearValueControlNode.this.unitsNode.getFullBounds().getHeight() / 2.0);
            LinearValueControlNode.this.sliderNode.setOffset(d4 + d2 + d3 + (double)(LinearValueControlNode.this.SPACING * 3), d / 2.0 - LinearValueControlNode.this.sliderNode.getFullBounds().getHeight() / 2.0);
        }

        private double getMax(Getter getter) {
            double[] dArray = new double[this.nodes.length];
            for (int i = 0; i < this.nodes.length; ++i) {
                dArray[i] = getter.getValue(this.nodes[i]);
            }
            return MathUtil.max(dArray);
        }
    }

    public static interface LayoutStrategy {
        public void layout(LinearValueControlNode var1);
    }

    public static interface Listener {
        public void valueChanged(double var1);
    }
}

