/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.control;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.control.CaloricItem;
import edu.colorado.phet.eatingandexercise.control.CalorieDragStrip;
import edu.colorado.phet.eatingandexercise.control.CalorieSelectionPanel;
import edu.colorado.phet.eatingandexercise.control.ICalorieSelectionPanel;
import edu.colorado.phet.eatingandexercise.control.PlateTopSummaryNode;
import edu.colorado.phet.eatingandexercise.model.CalorieSet;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.Timer;

public class CalorieNode
extends PNode {
    private Frame parentFrame;
    private CalorieSet available;
    private CalorieSet calorieSet;
    private JDialog dialog;
    private String selectedTitle;
    private String availableTitle;
    private HTMLImageButtonNode editButton;
    private ArrayList closedListeners = new ArrayList();
    private PImage dropTarget;
    private PlateTopSummaryNode plateTopSummaryNode;
    private CalorieDragStrip calorieDragStrip;
    private ArrayList itemPressedListeners = new ArrayList();
    private ArrayList overlapTargets = new ArrayList();
    Random random = new Random();

    public CalorieNode(Frame frame, String string, Color color, CalorieSet calorieSet, CalorieSet calorieSet2, String string2, String string3, String string4) {
        this.parentFrame = frame;
        this.available = calorieSet;
        this.calorieSet = calorieSet2;
        this.availableTitle = string2;
        this.selectedTitle = string3;
        this.editButton = new HTMLImageButtonNode(string, new PhetFont(1, 18), color);
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CalorieNode.this.dialog == null) {
                    CalorieNode.this.createDialog();
                }
                CalorieNode.this.dialog.setVisible(true);
                JComponent jComponent = (JComponent)CalorieNode.this.dialog.getContentPane();
                jComponent.paintImmediately(0, 0, jComponent.getWidth(), jComponent.getHeight());
            }
        });
        this.editButton.setOffset(0.0, 10.0);
        this.dropTarget = new PImage(BufferedImageUtils.multiScaleToHeight(EatingAndExerciseResources.getImage(string4), 120));
        this.addChild(this.dropTarget);
        this.plateTopSummaryNode = new PlateTopSummaryNode(calorieSet2, this.dropTarget);
        this.addChild(this.plateTopSummaryNode);
        this.calorieDragStrip = new CalorieDragStrip(calorieSet);
        this.calorieDragStrip.addListener(new CalorieDragStrip.Adapter(){

            public void nodeDragged(CalorieDragStrip.DragNode dragNode) {
                CalorieNode.this.setContainsItem(dragNode.getItem(), CalorieNode.this.nodeOverlapsDropTarget(dragNode));
            }

            public void nodePressed() {
                CalorieNode.this.notifyNodePressed();
            }

            public void nodeDropped(CalorieDragStrip.DragNode dragNode) {
                if (CalorieNode.this.shouldDispose(dragNode)) {
                    this.dispose(dragNode);
                } else if (CalorieNode.this.shouldMoveToTarget(dragNode)) {
                    CalorieNode.this.moveToDropTarget(dragNode);
                }
            }

            private void dispose(final CalorieDragStrip.DragNode dragNode) {
                final Timer timer = new Timer(30, null);
                timer.addActionListener(new ActionListener(){
                    int count = 0;

                    public void actionPerformed(ActionEvent actionEvent) {
                        dragNode.getPNode().scaleAboutPoint(0.82, dragNode.getPNodeIcon().getFullBounds().getWidth() / 2.0, dragNode.getPNodeIcon().getFullBounds().getHeight() / 2.0);
                        ++this.count;
                        if (this.count >= 20) {
                            timer.stop();
                            CalorieNode.this.setContainsItem(dragNode.getItem(), false);
                            if (dragNode.getPNode().getParent() != null) {
                                dragNode.getPNode().getParent().removeChild(dragNode.getPNode());
                            }
                        }
                    }
                });
                timer.start();
            }
        });
        this.addPreExistingItems();
        calorieSet2.addListener(new CalorieSet.Adapter(){

            public void itemRemoved(CaloricItem caloricItem) {
                CalorieNode.this.calorieDragStrip.itemRemoved(caloricItem);
            }
        });
        this.addChild(this.calorieDragStrip);
        calorieSet2.addListener(new CalorieSet.Adapter(){

            public void itemAdded(CaloricItem caloricItem) {
                CalorieNode.this.updatePlusNodeVisible();
            }

            public void itemRemoved(CaloricItem caloricItem) {
                CalorieNode.this.updatePlusNodeVisible();
            }
        });
        this.updatePlusNodeVisible();
        this.relayout();
    }

    private void moveToDropTarget(CalorieDragStrip.DragNode dragNode) {
        Point2D point2D = this.dropTarget.getGlobalFullBounds().getCenter2D();
        dragNode.getPNodeIcon().globalToLocal(point2D);
        PDimension pDimension = new PDimension(this.dropTarget.getGlobalFullBounds().getWidth() / 2.0, this.dropTarget.getGlobalFullBounds().getHeight() / 2.0);
        dragNode.getPNodeIcon().globalToLocal(pDimension);
        PDimension pDimension2 = new PDimension(dragNode.getPNodeIcon().getGlobalFullBounds().width / 2.0, dragNode.getPNodeIcon().getGlobalFullBounds().height / 2.0);
        dragNode.getPNodeIcon().globalToLocal(pDimension2);
        double d = 2.0 * (this.random.nextDouble() - 0.5) * pDimension.width * 0.75;
        double d2 = 2.0 * (this.random.nextDouble() - 0.5) * pDimension.height * 0.75;
        dragNode.getPNodeIcon().animateToPositionScaleRotation(point2D.getX() - pDimension2.width + d, point2D.getY() - pDimension2.height + d2, 1.0, 0.0, 750L);
    }

    private boolean shouldMoveToTarget(CalorieDragStrip.DragNode dragNode) {
        return this.nodeOverlapsOtherTarget(dragNode);
    }

    private void notifyNodePressed() {
        for (int i = 0; i < this.itemPressedListeners.size(); ++i) {
            ((ActionListener)this.itemPressedListeners.get(i)).actionPerformed(new ActionEvent(this, 0, "command"));
        }
    }

    private boolean shouldDispose(CalorieDragStrip.DragNode dragNode) {
        return !this.nodeOverlapsDropTarget(dragNode);
    }

    private boolean nodeOverlapsDropTarget(CalorieDragStrip.DragNode dragNode) {
        boolean bl = this.dropTarget.getGlobalFullBounds().contains(dragNode.getPNodeIcon().getGlobalFullBounds().getCenter2D());
        boolean bl2 = this.nodeOverlapsOtherTarget(dragNode);
        return bl || bl2;
    }

    private boolean nodeOverlapsOtherTarget(CalorieDragStrip.DragNode dragNode) {
        boolean bl = false;
        for (int i = 0; i < this.overlapTargets.size(); ++i) {
            PNode pNode = (PNode)this.overlapTargets.get(i);
            bl = bl || pNode.getGlobalFullBounds().contains(dragNode.getPNodeIcon().getGlobalFullBounds().getCenter2D());
        }
        return bl;
    }

    private void addPreExistingItems() {
        for (int i = 0; i < this.calorieSet.getItemCount(); ++i) {
            final PNode pNode = this.calorieDragStrip.addItemNode(this.calorieSet.getItem(i));
            this.dropTarget.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    pNode.setOffset(CalorieNode.this.dropTarget.getFullBounds().getCenterX() - pNode.getFullBounds().getWidth() / 2.0 + pNode.getFullBounds().getWidth(), CalorieNode.this.dropTarget.getFullBounds().getY() - pNode.getFullBounds().getHeight() * 1.1);
                }
            });
            pNode.setOffset(this.dropTarget.getFullBounds().getCenterX() - pNode.getFullBounds().getWidth() / 2.0 + pNode.getFullBounds().getWidth(), this.dropTarget.getFullBounds().getY() - pNode.getFullBounds().getHeight() * 1.1);
        }
    }

    public PImage getDropTarget() {
        return this.dropTarget;
    }

    private void setContainsItem(CaloricItem caloricItem, boolean bl) {
        if (!this.calorieSet.contains(caloricItem) && bl) {
            this.calorieSet.addItem(caloricItem);
        } else if (!bl) {
            while (this.calorieSet.contains(caloricItem)) {
                this.calorieSet.removeItem(caloricItem);
            }
        }
    }

    protected void createDialog() {
        this.dialog = new JDialog(this.parentFrame, false);
        ICalorieSelectionPanel iCalorieSelectionPanel = this.createCalorieSelectionPanel();
        iCalorieSelectionPanel.addListener(new CalorieSelectionPanel.Listener(){

            public void donePressed() {
                CalorieNode.this.dialog.hide();
                CalorieNode.this.notifyClosing();
            }
        });
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CalorieNode.this.notifyClosing();
            }
        });
        this.dialog.setContentPane((JPanel)((Object)iCalorieSelectionPanel));
        this.dialog.pack();
        this.dialog.setSize(1024, 400);
        Rectangle rectangle = this.parentFrame.getBounds();
        Rectangle rectangle2 = new Rectangle((int)(rectangle.getMinX() + rectangle.getWidth() / 2.0 - (double)(this.dialog.getWidth() / 2)), (int)(rectangle.getMaxY() - (double)this.dialog.getHeight()), this.dialog.getWidth(), this.dialog.getHeight());
        this.dialog.setBounds(rectangle2);
    }

    private void notifyClosing() {
        for (int i = 0; i < this.closedListeners.size(); ++i) {
            ((ActionListener)this.closedListeners.get(i)).actionPerformed(null);
        }
    }

    protected ICalorieSelectionPanel createCalorieSelectionPanel() {
        return new CalorieSelectionPanel(this.available, this.calorieSet, this.availableTitle, this.selectedTitle);
    }

    public CalorieSet getAvailable() {
        return this.available;
    }

    public CalorieSet getCalorieSet() {
        return this.calorieSet;
    }

    public String getAvailableTitle() {
        return this.availableTitle;
    }

    public String getSelectedTitle() {
        return this.selectedTitle;
    }

    private void updatePlusNodeVisible() {
    }

    public void addEditorClosedListener(ActionListener actionListener) {
        this.closedListeners.add(actionListener);
    }

    private void relayout() {
        this.dropTarget.setOffset(0.0, this.calorieDragStrip.getFullBounds().getMaxY() + 20.0);
        this.plateTopSummaryNode.relayout();
        this.calorieDragStrip.setOffset(this.dropTarget.getFullBounds().getWidth() / 2.0 - this.calorieDragStrip.getStripPanelWidth() / 2.0, 2.0);
    }

    public PNode getTooltipLayer() {
        return this.calorieDragStrip.getTooltipLayer();
    }

    public void resetAll() {
        this.calorieDragStrip.resetAll();
        this.addPreExistingItems();
    }

    public double getPlateBottomY() {
        return this.dropTarget.getFullBounds().getMaxY();
    }

    public void addItemPressedListener(ActionListener actionListener) {
        this.itemPressedListeners.add(actionListener);
    }

    public void addOverlapTarget(PNode pNode) {
        this.overlapTargets.add(pNode);
    }
}

