/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PInputManager;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PActivityScheduler;
import edu.umd.cs.piccolo.util.PDebug;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class PRoot
extends PNode {
    protected transient boolean processingInputs;
    protected transient boolean processInputsScheduled;
    private transient int interacting;
    private transient PInputManager defaultInputManager;
    private final transient List inputSources = new ArrayList();
    private transient long globalTime = System.currentTimeMillis();
    private final PActivityScheduler activityScheduler = new PActivityScheduler(this);

    public boolean addActivity(PActivity pActivity) {
        this.getActivityScheduler().addActivity(pActivity);
        return true;
    }

    public PActivityScheduler getActivityScheduler() {
        return this.activityScheduler;
    }

    public PRoot getRoot() {
        return this;
    }

    public PInputManager getDefaultInputManager() {
        if (this.defaultInputManager == null) {
            this.defaultInputManager = new PInputManager();
            this.addInputSource(this.defaultInputManager);
        }
        return this.defaultInputManager;
    }

    public boolean getInteracting() {
        return this.interacting > 0;
    }

    public void addInputSource(InputSource inputSource) {
        this.inputSources.add(inputSource);
        this.firePropertyChange(16384, "inputSources", null, this.inputSources);
    }

    public Timer createTimer(int n, ActionListener actionListener) {
        return new Timer(n, actionListener);
    }

    public long getGlobalTime() {
        return this.globalTime;
    }

    public void processInputs() {
        PDebug.startProcessingInput();
        this.processingInputs = true;
        this.globalTime = System.currentTimeMillis();
        if (this.inputSources.size() > 0) {
            for (InputSource inputSource : this.inputSources) {
                inputSource.processInput();
            }
        }
        this.activityScheduler.processActivities(this.globalTime);
        this.validateFullBounds();
        this.validateFullPaint();
        this.processingInputs = false;
        PDebug.endProcessingInput();
    }

    public void setFullBoundsInvalid(boolean bl) {
        super.setFullBoundsInvalid(bl);
        this.scheduleProcessInputsIfNeeded();
    }

    public void setChildBoundsInvalid(boolean bl) {
        super.setChildBoundsInvalid(bl);
        this.scheduleProcessInputsIfNeeded();
    }

    public void setPaintInvalid(boolean bl) {
        super.setPaintInvalid(bl);
        this.scheduleProcessInputsIfNeeded();
    }

    public void setChildPaintInvalid(boolean bl) {
        super.setChildPaintInvalid(bl);
        this.scheduleProcessInputsIfNeeded();
    }

    public void scheduleProcessInputsIfNeeded() {
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        PDebug.scheduleProcessInputs();
        if (!this.processInputsScheduled && !this.processingInputs && (this.getFullBoundsInvalid() || this.getChildBoundsInvalid() || this.getPaintInvalid() || this.getChildPaintInvalid())) {
            this.processInputsScheduled = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PRoot.this.processInputs();
                    PRoot.this.processInputsScheduled = false;
                }
            });
        }
    }

    public static interface InputSource {
        public void processInput();
    }
}

