/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.view;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.model.Human;
import edu.colorado.phet.eatingandexercise.view.HeadNode;
import edu.colorado.phet.eatingandexercise.view.HeartNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class HumanNode
extends PNode {
    private Human human;
    private HeadNode head;
    private PImage heartNode;
    private BasicStroke stroke = new BasicStroke(0.02f, 1, 0);
    private PhetPPath areaNode = new PhetPPath(Color.white, (Stroke)this.stroke, (Paint)Color.black);
    private HTMLImageButtonNode infoButton;
    private ArrayList listeners = new ArrayList();

    public HumanNode(Human human) {
        this.human = human;
        this.head = new HeadNode(human, Color.white, new BasicStroke(0.02f), Color.black);
        this.addChild(this.areaNode);
        this.heartNode = new HeartNode(human);
        this.heartNode.scale(0.25 / this.heartNode.getFullBounds().getWidth());
        this.addChild(this.heartNode);
        this.addChild(this.head);
        human.addListener(new Human.Adapter(){

            public void heightChanged() {
                HumanNode.this.update();
            }

            public void weightChanged() {
                HumanNode.this.update();
            }

            public void fatPercentChanged() {
                HumanNode.this.update();
            }
        });
        this.infoButton = new HTMLImageButtonNode(EatingAndExerciseResources.getString("question.mark"), new PhetFont(1, 12), Color.red);
        this.infoButton.setScale(0.007);
        this.infoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HumanNode.this.notifyInfoButtonPressed();
            }
        });
        this.update();
    }

    public PImage getHeartNode() {
        return this.heartNode;
    }

    private void update() {
        double d = this.human.getHeight() * 0.125;
        double d2 = this.human.getHeight() * 0.125;
        double d3 = 0.5;
        double d4 = this.human.getHeight() * 0.35;
        double d5 = -this.human.getHeight() * 0.4;
        double d6 = -this.human.getHeight() + d2;
        double d7 = d6 + d2;
        double d8 = this.getScaledMass() / this.human.getHeight() * 1.75;
        Line2D.Double double_ = new Line2D.Double(0.0, d5, -d3 / 2.0, 0.0);
        Line2D.Double double_2 = new Line2D.Double(0.0, d5, d3 / 2.0, 0.0);
        Line2D.Double double_3 = new Line2D.Double(0.0, d5, 0.0, d6);
        Line2D.Double double_4 = new Line2D.Double(0.0, d7, -d4, d7);
        Line2D.Double double_5 = new Line2D.Double(0.0, d7, d4, d7);
        Ellipse2D.Double double_6 = new Ellipse2D.Double(-d / 2.0, d6 - d2, d, d2);
        this.head.setPathTo(double_6);
        BasicStroke basicStroke = new BasicStroke((float)((double)0.08f * d8), 1, 1);
        BasicStroke basicStroke2 = new BasicStroke((float)((double)0.08f * d8 * 1.2), 1, 1);
        Area area = new Area();
        area.add(new Area(basicStroke.createStrokedShape(double_)));
        area.add(new Area(basicStroke.createStrokedShape(double_2)));
        Shape shape = basicStroke2.createStrokedShape(double_3);
        area.add(new Area(shape));
        area.add(new Area(basicStroke.createStrokedShape(double_5)));
        area.add(new Area(basicStroke.createStrokedShape(double_4)));
        area.add(new Area(this.createStomachShape(shape)));
        area.add(new Area(this.createMuscle(double_5, basicStroke)));
        area.add(new Area(this.createMuscle(double_4, basicStroke)));
        this.areaNode.setPathTo(area);
        this.areaNode.setStroke(new BasicStroke((float)Math.min((double)0.02f * d8, (double)0.025f), 1, 1));
        this.heartNode.setOffset(-this.heartNode.getFullBounds().getWidth() * 0.15, d6 + this.heartNode.getFullBounds().getHeight() * 1.25);
        this.infoButton.setOffset(this.heartNode.getFullBounds().getMaxX(), this.heartNode.getFullBounds().getMinY());
    }

    private Shape createMuscle(Line2D.Double double_, BasicStroke basicStroke) {
        double d;
        double d2 = this.human.getHeight();
        double d3 = this.human.getMass();
        double d4 = (d3 / (d2 * d2) / 17.5 - 1.0) * (40.0 / (d = this.human.getFatMassPercent()) - 1.0);
        double d5 = Math.max(d4 * 0.5, 0.0);
        if (d5 > 0.8) {
            d5 = 0.8 + (d5 - 0.8) * 0.25;
        }
        if (d5 > 1.25) {
            d5 = 1.25;
        }
        double d6 = (double)basicStroke.getLineWidth() * (1.0 + d5);
        MutableVector2D mutableVector2D = new MutableVector2D(double_.getP1(), double_.getP2());
        double d7 = 0.35;
        Ellipse2D.Double double_2 = new Ellipse2D.Double();
        Point2D.Double double_3 = mutableVector2D.times(d7).getDestination(double_.getP1());
        double_2.setFrameFromCenter(double_3, new Point2D.Double(((Point2D)double_3).getX() + d6 / 2.0, ((Point2D)double_3).getY() + d6 / 2.0));
        return double_2;
    }

    private double getScaledMass() {
        double d = this.human.getFatFreeMassPercent() / 100.0;
        return this.human.getMass() / 75.0 * 1.75 + (1.0 - d) * 0.2;
    }

    private Shape createStomachShape(Shape shape) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d = this.human.getFatMassPercent();
        double d2 = this.human.getGender().equals(Human.Gender.MALE) ? 13.0 : 20.0;
        double d3 = Math.max((d / d2 - 1.0) * 0.1, 0.0);
        return new Ellipse2D.Double(rectangle2D.getX() - d3 / 2.0, rectangle2D.getCenterY(), rectangle2D.getWidth() + d3, rectangle2D.getHeight() / 2.0);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyInfoButtonPressed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).infoButtonPressed();
        }
    }

    public static interface Listener {
        public void infoButtonPressed();
    }
}

