/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.view;

import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.eatingandexercise.model.Human;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;

public class HeadNode
extends PNode {
    private PhetPPath headPath;
    private Human human;
    private PNode eyeGraphics;
    private PhetPPath leftEye;
    private PhetPPath rightEye;

    public HeadNode(Human human, Color color, BasicStroke basicStroke, Color color2) {
        this.human = human;
        this.headPath = new PhetPPath(color, (Stroke)basicStroke, (Paint)color2);
        this.addChild(this.headPath);
        this.eyeGraphics = new PNode();
        float f = 0.015f;
        this.leftEye = new PhetPPath(this.createEyePath(), (Stroke)new BasicStroke(f), (Paint)Color.black);
        this.rightEye = new PhetPPath(this.createEyePath(), (Stroke)new BasicStroke(f), (Paint)Color.black);
        human.addListener(new Human.Adapter(){

            public void aliveChanged() {
                HeadNode.this.updateEyesVisible();
            }
        });
        this.updateEyesVisible();
        this.eyeGraphics.addChild(this.leftEye);
        this.eyeGraphics.addChild(this.rightEye);
        this.addChild(this.eyeGraphics);
    }

    private Shape createEyePath() {
        double d = 0.02;
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        doubleGeneralPath.moveTo(-d, -d);
        doubleGeneralPath.lineTo(d, d);
        doubleGeneralPath.moveTo(-d, d);
        doubleGeneralPath.lineTo(d, -d);
        return doubleGeneralPath.getGeneralPath();
    }

    private void updateEyesVisible() {
        this.eyeGraphics.setVisible(!this.human.isAlive());
    }

    public void setPathTo(Shape shape) {
        this.headPath.setPathTo(shape);
        this.updateLayout();
    }

    private void updateLayout() {
        double d = 0.03;
        double d2 = 0.4;
        this.leftEye.setOffset(this.headPath.getFullBounds().getCenterX() - d, this.headPath.getFullBounds().getY() + this.headPath.getFullBounds().getHeight() * d2);
        this.rightEye.setOffset(this.headPath.getFullBounds().getCenterX() + d, this.headPath.getFullBounds().getY() + this.headPath.getFullBounds().getHeight() * d2);
    }
}

