/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.module.eatingandexercise;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.ResetAllButton;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.help.DefaultWiggleMe;
import edu.colorado.phet.common.piccolophet.help.HelpPane;
import edu.colorado.phet.common.piccolophet.help.MotionHelpBalloon;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseStrings;
import edu.colorado.phet.eatingandexercise.control.CaloricItem;
import edu.colorado.phet.eatingandexercise.control.ChartNode;
import edu.colorado.phet.eatingandexercise.model.CalorieSet;
import edu.colorado.phet.eatingandexercise.model.EatingAndExerciseUnits;
import edu.colorado.phet.eatingandexercise.model.Human;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.DragToTargetHelpItem;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.EatingAndExerciseCanvas;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.EatingAndExerciseClock;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.EatingAndExerciseHelpButton;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.EatingAndExerciseModel;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.GameOverDialog;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.HumanAudioPlayer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;

public class EatingAndExerciseModule
extends PiccoloModule {
    private EatingAndExerciseModel _model;
    private EatingAndExerciseCanvas _canvas;
    private PiccoloClockControlPanel _clockControlPanel;
    private JFrame parentFrame;
    private boolean inited = false;
    private boolean everStarted = false;
    private EatingAndExerciseClock eatingAndExerciseClock;
    private int numAddedItems = 0;
    private boolean showedInitialDragWiggleMe = false;

    private double getAgeYears() {
        return EatingAndExerciseUnits.secondsToYears(this._model.getHuman().getAge());
    }

    public EatingAndExerciseModule(final PhetFrame phetFrame) {
        super(EatingAndExerciseStrings.TITLE_EATING_AND_EXERCISE_MODULE, new EatingAndExerciseClock(), true);
        this.parentFrame = phetFrame;
        this.eatingAndExerciseClock = (EatingAndExerciseClock)this.getClock();
        this.eatingAndExerciseClock.addClockListener(new ClockAdapter(){

            public void clockStarted(ClockEvent clockEvent) {
                EatingAndExerciseModule.this.everStarted = true;
            }
        });
        this._model = new EatingAndExerciseModel(this.eatingAndExerciseClock);
        HumanAudioPlayer humanAudioPlayer = new HumanAudioPlayer(this._model.getHuman());
        humanAudioPlayer.start();
        GameOverDialog gameOverDialog = new GameOverDialog(phetFrame, this._model.getHuman(), this);
        gameOverDialog.start();
        this._canvas = new EatingAndExerciseCanvas(this._model, phetFrame);
        this._model.addListener(new EatingAndExerciseModel.Adapter(){

            public void simulationTimeChanged() {
                if (EatingAndExerciseModule.this.getAgeYears() >= EatingAndExerciseModule.this._canvas.getChartNode().getMaxChartTime()) {
                    EatingAndExerciseModule.this._model.getClock().pause();
                    EatingAndExerciseModule.this.getClockControlPanel().setEnabled(false);
                }
            }
        });
        this._canvas.getChartNode().addListener(new ChartNode.Listener(){

            public void chartDataCleared() {
                EatingAndExerciseModule.this.getClockControlPanel().setEnabled(true);
            }
        });
        this._canvas.addEditorClosedListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EatingAndExerciseModule.this.activateStartButtonWiggleMe();
            }
        });
        this._model.getHuman().getSelectedExercise().addListener(new CalorieSet.Adapter(){

            public void itemAdded(CaloricItem caloricItem) {
                EatingAndExerciseModule.this.incrementAddedItems();
            }
        });
        this._model.getHuman().getSelectedFoods().addListener(new CalorieSet.Adapter(){

            public void itemAdded(CaloricItem caloricItem) {
                EatingAndExerciseModule.this.incrementAddedItems();
            }
        });
        this._canvas.addFoodPressedListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!EatingAndExerciseModule.this.showedInitialDragWiggleMe) {
                    EatingAndExerciseModule.this.showedInitialDragWiggleMe = true;
                    new DragToTargetHelpItem(EatingAndExerciseModule.this, EatingAndExerciseModule.this._canvas, EatingAndExerciseModule.this._canvas.getPlateNode(), EatingAndExerciseResources.getString("put.food.on.plate"), EatingAndExerciseModule.this.getHuman().getSelectedFoods()).start();
                }
            }
        });
        this._canvas.addExerciseDraggedListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!EatingAndExerciseModule.this.showedInitialDragWiggleMe) {
                    EatingAndExerciseModule.this.showedInitialDragWiggleMe = true;
                    new DragToTargetHelpItem(EatingAndExerciseModule.this, EatingAndExerciseModule.this._canvas, EatingAndExerciseModule.this._canvas.getDiaryNode(), EatingAndExerciseResources.getString("put.exercise.on.diary"), EatingAndExerciseModule.this.getHuman().getSelectedExercise()).start();
                }
            }
        });
        this.setSimulationPanel(this._canvas);
        this.setControlPanel(null);
        this.setLogoPanelVisible(false);
        this._clockControlPanel = new PiccoloClockControlPanel(this.getClock()){

            public void setTimeDisplay(double d) {
                super.setTimeDisplay(EatingAndExerciseUnits.secondsToYears(d));
            }
        };
        this._clockControlPanel.setRewindButtonVisible(true);
        this._clockControlPanel.setTimeDisplayVisible(true);
        this._clockControlPanel.setUnits(EatingAndExerciseStrings.UNITS_TIME);
        this._clockControlPanel.setTimeColumns(10);
        this._clockControlPanel.setRewindButtonVisible(false);
        this._clockControlPanel.setStepButtonTooltip(EatingAndExerciseResources.getString("time.next-month"));
        this._clockControlPanel.setTimeFormat("0.0");
        ResetAllButton resetAllButton = new ResetAllButton(new Resettable(){

            public void reset() {
                EatingAndExerciseModule.this.resetAll();
            }
        }, (Component)phetFrame);
        JButton jButton = new JButton(EatingAndExerciseResources.getString("disclaimer"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhetOptionPane.showMessageDialog(phetFrame, EatingAndExerciseStrings.DISCLAIMER);
            }
        });
        this._clockControlPanel.add((Component)new EatingAndExerciseHelpButton(), 0);
        this._clockControlPanel.add((Component)jButton, 1);
        this._clockControlPanel.add(Box.createHorizontalStrut(100), 2);
        this._clockControlPanel.add((Component)resetAllButton, 3);
        this.setClockControlPanel(this._clockControlPanel);
        this.setHelpEnabled(true);
        this.setHelpPane(new HelpPane(phetFrame));
        this.reset();
    }

    public void resetAll() {
        this._model.resetAll();
        this._canvas.resetAll();
        this.getClockControlPanel().setEnabled(true);
    }

    private void incrementAddedItems() {
        ++this.numAddedItems;
        if (this.numAddedItems >= 3) {
            this.activateStartButtonWiggleMe();
        }
    }

    private void activateStartButtonWiggleMe() {
        if (!this.inited && !this.everStarted) {
            final DefaultWiggleMe defaultWiggleMe = new DefaultWiggleMe(this._canvas, EatingAndExerciseResources.getString("time.start"));
            this.eatingAndExerciseClock.addClockListener(new ClockAdapter(){

                public void clockStarted(ClockEvent clockEvent) {
                    EatingAndExerciseModule.this.hideWiggleMe(defaultWiggleMe);
                }

                public void simulationTimeChanged(ClockEvent clockEvent) {
                    EatingAndExerciseModule.this.hideWiggleMe(defaultWiggleMe);
                }
            });
            defaultWiggleMe.setArrowTailPosition(MotionHelpBalloon.BOTTOM_CENTER);
            defaultWiggleMe.setOffset(800.0, 0.0);
            this.getDefaultHelpPane().add(defaultWiggleMe);
            defaultWiggleMe.animateTo(this._clockControlPanel.getButtonCanvas(), 15.0);
            this.inited = true;
        }
    }

    private void hideWiggleMe(MotionHelpBalloon motionHelpBalloon) {
        if (this.getDefaultHelpPane().getLayer().indexOfChild(motionHelpBalloon) >= 0) {
            this.getDefaultHelpPane().remove(motionHelpBalloon);
        }
    }

    public Human getHuman() {
        return this._model.getHuman();
    }

    public void applicationStarted() {
        this._canvas.applicationStarted();
    }
}

