/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.module.eatingandexercise;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.control.CalorieDragStrip;
import edu.colorado.phet.eatingandexercise.control.UserSpecifiedBodyParameters;
import edu.colorado.phet.eatingandexercise.model.CalorieSet;
import edu.colorado.phet.eatingandexercise.model.Diet;
import edu.colorado.phet.eatingandexercise.model.EatingAndExerciseUnits;
import edu.colorado.phet.eatingandexercise.model.Human;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.CaloricFoodItem;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.EatingAndExerciseClock;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.FoodCalorieSet;
import edu.colorado.phet.eatingandexercise.util.EatingAndExerciseFileParser;
import java.util.ArrayList;

public class EatingAndExerciseModel {
    private UserSpecifiedBodyParameters userSpecifiedBodyParameters = new UserSpecifiedBodyParameters();
    private Units units = Units.ENGLISH;
    public static final Units[] availableUnits = new Units[]{Units.ENGLISH, Units.METRIC};
    private final EatingAndExerciseClock clock;
    private final Human human = new Human();
    private final FoodCalorieSet availableFoods = new FoodCalorieSet(EatingAndExerciseFileParser.getFoodItems(this.human));
    private final CalorieSet availableExercise = new CalorieSet(EatingAndExerciseFileParser.getExerciseItems(this.human));
    public static final Diet BALANCED_DIET = new Diet(EatingAndExerciseResources.getString("diet.balanced"), 30.0, 40.0, 30.0).getInstanceOfMagnitude(2000.0);
    public static final Diet FAST_FOOD_ONLY = new Diet(EatingAndExerciseResources.getString("diet.fast-food"), 3000.0, 300.0, 150.0);
    public static final Diet[] availableDiets = new Diet[]{BALANCED_DIET, FAST_FOOD_ONLY};
    private boolean paused = false;
    private ArrayList listeners = new ArrayList();

    public UserSpecifiedBodyParameters getUserSpecifiedBodyParameters() {
        return this.userSpecifiedBodyParameters;
    }

    public void autoUpdatePercentFat() {
        this.human.setFatMassPercent(this.getUserSpecifiedBodyParameters().getAutoFatMassPercent(this.human));
    }

    public EatingAndExerciseModel(EatingAndExerciseClock eatingAndExerciseClock) {
        this.availableFoods.insertItem(CalorieDragStrip.ITEMS_PER_PAGE, new CaloricFoodItem(EatingAndExerciseResources.getString("diet.healthy"), "food-pyramid.png", BALANCED_DIET.getFat() / 9.0, BALANCED_DIET.getCarb() / 4.0, BALANCED_DIET.getProtein() / 4.0));
        this.clock = eatingAndExerciseClock;
        this.clock.addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                if (!EatingAndExerciseModel.this.paused) {
                    EatingAndExerciseModel.this.human.simulationTimeChanged(clockEvent.getSimulationTimeChange());
                    EatingAndExerciseModel.this.notifySimulationTimeChanged();
                }
            }
        });
        this.resetAll();
    }

    private void notifySimulationTimeChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).simulationTimeChanged();
        }
    }

    public EatingAndExerciseClock getClock() {
        return this.clock;
    }

    public CalorieSet getAvailableFoods() {
        return this.availableFoods;
    }

    public CalorieSet getAvailableExercise() {
        return this.availableExercise;
    }

    public Human getHuman() {
        return this.human;
    }

    public void resetAll() {
        this.clock.setSimulationTime(0.0);
        this.human.resetAll();
        this.setUnits(Units.ENGLISH);
        this.getClock().pause();
        this.autoUpdatePercentFat();
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        if (this.units != units) {
            this.units = units;
            this.notifyUnitsChanged();
        }
    }

    private void notifyUnitsChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).unitsChanged();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static class Adapter
    implements Listener {
        public void unitsChanged() {
        }

        public void simulationTimeChanged() {
        }
    }

    public static interface Listener {
        public void unitsChanged();

        public void simulationTimeChanged();
    }

    public static class Units {
        public static final Units ENGLISH = new Units(EatingAndExerciseResources.getString("units.english"), EatingAndExerciseResources.getString("units.lbs"), EatingAndExerciseResources.getString("units.feet.in")){

            public double modelToViewMass(double d) {
                return EatingAndExerciseUnits.kgToPounds(d);
            }

            public double viewToModelMass(double d) {
                return EatingAndExerciseUnits.poundsToKg(d);
            }

            public double modelToViewDistance(double d) {
                return EatingAndExerciseUnits.metersToFeet(d);
            }

            public double viewToModelDistance(double d) {
                return EatingAndExerciseUnits.feetToMeters(d);
            }
        };
        public static final Units METRIC = new Units(EatingAndExerciseResources.getString("units.metric"), EatingAndExerciseResources.getString("units.kg"), EatingAndExerciseResources.getString("units.meters"));
        private String shortName;
        private String massUnit;
        private String distanceUnit;

        public Units(String string, String string2, String string3) {
            this.shortName = string;
            this.massUnit = string2;
            this.distanceUnit = string3;
        }

        public String toString() {
            return this.shortName;
        }

        public String getShortName() {
            return this.shortName;
        }

        public double modelToViewMass(double d) {
            return d;
        }

        public String getMassUnit() {
            return this.massUnit;
        }

        public double viewToModelMass(double d) {
            return d;
        }

        public String getDistanceUnit() {
            return this.distanceUnit;
        }

        public double modelToViewDistance(double d) {
            return d;
        }

        public double viewToModelDistance(double d) {
            return d;
        }
    }
}

