/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.control;

import edu.colorado.phet.common.motion.graphs.ControlGraph;
import edu.colorado.phet.common.motion.graphs.ControlGraphSeries;
import edu.colorado.phet.common.motion.graphs.GraphSuiteSet;
import edu.colorado.phet.common.motion.graphs.MinimizableControlGraph;
import edu.colorado.phet.common.motion.model.DefaultTemporalVariable;
import edu.colorado.phet.common.motion.model.ITemporalVariable;
import edu.colorado.phet.common.motion.model.MotionTimeSeriesModel;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.timeseries.model.TestTimeSeries;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseStrings;
import edu.colorado.phet.eatingandexercise.model.EatingAndExerciseUnits;
import edu.colorado.phet.eatingandexercise.model.Human;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.EatingAndExerciseModel;
import edu.colorado.phet.eatingandexercise.util.YearMonthFormat;
import edu.colorado.phet.eatingandexercise.view.EatingAndExercisePText;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.data.Range;

public class ChartNode
extends PNode {
    private MinimizableControlGraph weightChart;
    private MinimizableControlGraph calorieChart;
    private DefaultTemporalVariable massVar = new DefaultTemporalVariable();
    private DefaultTemporalVariable calIntakeVar = new DefaultTemporalVariable();
    private DefaultTemporalVariable calBurnVar = new DefaultTemporalVariable();
    private EatingAndExerciseModel model;
    private EatingAndExerciseControlGraph weightGraph;
    private EatingAndExerciseControlGraph calorieGraph;
    private EatingAndExerciseModel.Units previousUnits;
    private ArrayList listeners = new ArrayList();

    public ChartNode(final EatingAndExerciseModel eatingAndExerciseModel, PhetPCanvas phetPCanvas) {
        this.model = eatingAndExerciseModel;
        GraphSuiteSet graphSuiteSet = new GraphSuiteSet();
        MotionTimeSeriesModel motionTimeSeriesModel = new MotionTimeSeriesModel(new TestTimeSeries.MyRecordableModel(), new ConstantDtClock(30, 1.0));
        eatingAndExerciseModel.addListener(new EatingAndExerciseModel.Adapter(){

            public void simulationTimeChanged() {
                ChartNode.this.updateVars();
            }
        });
        this.updateVars();
        eatingAndExerciseModel.addListener(new EatingAndExerciseModel.Adapter(){

            public void unitsChanged() {
                ChartNode.this.updateWeightMassLabel();
                ChartNode.this.syncVerticalRanges();
            }
        });
        eatingAndExerciseModel.getHuman().addListener(new Human.Adapter(){

            public void weightChanged() {
                ChartNode.this.massVar.setValue(ChartNode.this.getMassDisplayValue());
            }
        });
        eatingAndExerciseModel.getHuman().addListener(new Human.Adapter(){

            public void caloricIntakeChanged() {
                ChartNode.this.calIntakeVar.setValue(eatingAndExerciseModel.getHuman().getDailyCaloricIntake());
            }

            public void caloricBurnChanged() {
                ChartNode.this.calBurnVar.setValue(eatingAndExerciseModel.getHuman().getDailyCaloricBurn());
            }
        });
        final ControlGraphSeries controlGraphSeries = new ControlGraphSeries(EatingAndExerciseResources.getString("weight"), Color.blue, EatingAndExerciseResources.getString("weight"), EatingAndExerciseResources.getString("units.lbs"), "", this.massVar);
        controlGraphSeries.setDecimalFormat(new DefaultDecimalFormat("0"));
        eatingAndExerciseModel.addListener(new EatingAndExerciseModel.Adapter(){

            public void unitsChanged() {
                controlGraphSeries.setUnits(eatingAndExerciseModel.getUnits().getMassUnit());
            }
        });
        this.weightGraph = new EatingAndExerciseControlGraph(phetPCanvas, controlGraphSeries, EatingAndExerciseResources.getString("weight"), 0, 250, motionTimeSeriesModel);
        this.weightGraph.setEditable(false);
        this.updateWeightMassLabel();
        this.weightChart = new MinimizableControlGraph(EatingAndExerciseResources.getString("weight"), this.weightGraph);
        this.weightChart.setAvailableBounds(600.0, 125.0);
        ControlGraphSeries controlGraphSeries2 = new ControlGraphSeries(EatingAndExerciseResources.getString("calories.intake"), Color.green, EatingAndExerciseResources.getString("calories.intake"), EatingAndExerciseStrings.KCAL_PER_DAY, new BasicStroke(4.0f, 0, 0), "", this.calIntakeVar);
        controlGraphSeries2.setDecimalFormat(new DefaultDecimalFormat(EatingAndExerciseStrings.KCAL_PER_DAY_FORMAT));
        ControlGraphSeries controlGraphSeries3 = new ControlGraphSeries(EatingAndExerciseResources.getString("calories.burned"), Color.red, EatingAndExerciseResources.getString("calories.burned"), EatingAndExerciseStrings.KCAL_PER_DAY, new BasicStroke(2.0f, 0, 0), "", this.calBurnVar);
        controlGraphSeries3.setDecimalFormat(new DefaultDecimalFormat(EatingAndExerciseStrings.KCAL_PER_DAY_FORMAT));
        this.calorieGraph = new EatingAndExerciseControlGraph(phetPCanvas, controlGraphSeries2, EatingAndExerciseResources.getString("units.calories"), 0, 6000, motionTimeSeriesModel);
        this.calorieGraph.getJFreeChartNode().getChart().getXYPlot().getRangeAxis().setLabel(EatingAndExerciseResources.getString("units.cal-day"));
        this.calorieGraph.addSeries(controlGraphSeries3);
        this.updateGraphDomains(2.0);
        this.calorieGraph.setEditable(false);
        eatingAndExerciseModel.addListener(new EatingAndExerciseModel.Adapter(){

            public void simulationTimeChanged() {
                ChartNode.this.calorieGraph.forceUpdateAll();
            }
        });
        this.calorieChart = new MinimizableControlGraph(EatingAndExerciseResources.getString("units.calories"), this.calorieGraph);
        this.calorieChart.setAvailableBounds(600.0, 125.0);
        this.calorieGraph.addListener(new ControlGraph.Adapter(){

            public void zoomChanged() {
                ChartNode.this.weightGraph.setDomain(ChartNode.this.calorieGraph.getMinDataX(), ChartNode.this.calorieGraph.getMaxDataX());
            }
        });
        this.weightGraph.addListener(new ControlGraph.Adapter(){

            public void zoomChanged() {
                ChartNode.this.calorieGraph.setDomain(ChartNode.this.weightGraph.getMinDataX(), ChartNode.this.weightGraph.getMaxDataX());
            }
        });
        MinimizableControlGraph[] minimizableControlGraphArray = new MinimizableControlGraph[]{this.weightChart, this.calorieChart};
        this.weightChart.setAlignedLayout(minimizableControlGraphArray);
        this.calorieChart.setAlignedLayout(minimizableControlGraphArray);
        graphSuiteSet.addGraphSuite(minimizableControlGraphArray);
        this.addChild(this.weightChart);
        this.addChild(this.calorieChart);
        this.resetChartVerticalRanges();
        this.syncVerticalRanges();
    }

    public double getMaxChartTime() {
        return this.weightGraph.getLowerBound() + 2.0;
    }

    public void clearAndResetDomains() {
        this.clearData();
        this.updateGraphDomains();
    }

    private void updateWeightMassLabel() {
        String string = EatingAndExerciseResources.getString("weight");
        this.weightGraph.getJFreeChartNode().getChart().getXYPlot().getRangeAxis().setLabel(string + " (" + this.model.getUnits().getMassUnit() + ")");
    }

    private void syncVerticalRanges() {
        if (this.previousUnits == null) {
            this.previousUnits = this.model.getUnits();
        }
        if (this.previousUnits != this.model.getUnits()) {
            double d = this.weightGraph.getJFreeChartNode().getChart().getXYPlot().getRangeAxis().getUpperBound();
            double d2 = this.previousUnits.viewToModelMass(d);
            double d3 = this.model.getUnits().modelToViewMass(d2);
            this.weightGraph.setVerticalRange(0.0, d3);
            this.syncMassVar();
        }
        this.previousUnits = this.model.getUnits();
    }

    private void resetChartVerticalRanges() {
        this.weightGraph.setVerticalRange(0.0, 250.0);
        this.calorieGraph.setVerticalRange(0.0, 6000.0);
    }

    private void updateGraphDomains() {
        double d = this.weightGraph.getJFreeChartNode().getChart().getXYPlot().getDomainAxis().getLowerBound();
        double d2 = this.weightGraph.getJFreeChartNode().getChart().getXYPlot().getDomainAxis().getUpperBound();
        double d3 = d2 - d;
        this.updateGraphDomains(d3);
    }

    private void updateGraphDomains(double d) {
        double d2 = this.model.getHuman().getAge();
        this.calorieGraph.setDomain(EatingAndExerciseUnits.secondsToYears(d2), EatingAndExerciseUnits.secondsToYears(d2 + EatingAndExerciseUnits.yearsToSeconds(d)));
        this.weightGraph.setDomain(EatingAndExerciseUnits.secondsToYears(d2), EatingAndExerciseUnits.secondsToYears(d2 + EatingAndExerciseUnits.yearsToSeconds(d)));
    }

    private void resetChartArea() {
        this.clearAndResetDomains();
    }

    private void syncMassVar() {
        this.massVar.clear();
        ITemporalVariable iTemporalVariable = this.model.getHuman().getMassVariable();
        for (int i = 0; i < iTemporalVariable.getSampleCount(); ++i) {
            this.massVar.addValue(this.model.getUnits().modelToViewMass(iTemporalVariable.getData(i).getValue()), EatingAndExerciseUnits.secondsToYears(iTemporalVariable.getData(i).getTime()));
        }
    }

    private void updateVars() {
        this.updateMassVar();
        this.updateCalIntakeVar();
        this.updateCalBurnVar();
    }

    private void updateCalBurnVar() {
        double d = this.model.getHuman().getCaloricBurnVariable().getValue();
        this.calBurnVar.setValue(d);
        this.calBurnVar.addValue(d, this.getAgeYears());
    }

    private void updateCalIntakeVar() {
        double d = this.model.getHuman().getCaloricIntakeVariable().getValue();
        this.calIntakeVar.setValue(d);
        this.calIntakeVar.addValue(d, this.getAgeYears());
    }

    private void updateMassVar() {
        this.massVar.setValue(this.getMassDisplayValue());
        this.massVar.addValue(this.getMassDisplayValue(), this.getAgeYears());
    }

    private double getMassDisplayValue() {
        return this.model.getUnits().modelToViewMass(this.model.getHuman().getMass());
    }

    private double getAgeYears() {
        return EatingAndExerciseUnits.secondsToYears(this.model.getHuman().getAge());
    }

    public void relayout(double d, double d2) {
        this.weightChart.setAvailableBounds(d, d2 / 2.0);
        this.calorieChart.setAvailableBounds(d, d2 / 2.0);
        this.weightChart.setOffset(0.0, d2 - this.weightChart.getFullBounds().getHeight() - this.calorieChart.getFullBounds().getHeight());
        this.calorieChart.setOffset(0.0, this.weightChart.getFullBounds().getMaxY());
        this.weightChart.relayoutControlGraph();
        this.calorieChart.relayoutControlGraph();
    }

    public void resetAll() {
        this.clearData();
        this.updateGraphDomains(2.0);
        this.resetChartVerticalRanges();
    }

    private void clearData() {
        this.massVar.clear();
        this.model.getHuman().clearMassData();
        this.calBurnVar.clear();
        this.calIntakeVar.clear();
        this.notifyChartDataCleared();
    }

    public void notifyChartDataCleared() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).chartDataCleared();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private class EatingAndExerciseControlGraph
    extends ControlGraph {
        private HTMLImageButtonNode gradientButtonNode;
        private PNode axisLabel;

        public EatingAndExerciseControlGraph(PhetPCanvas phetPCanvas, ControlGraphSeries controlGraphSeries, String string, int n, int n2, TimeSeriesModel timeSeriesModel) {
            super(phetPCanvas, controlGraphSeries, string, n, n2, timeSeriesModel);
            this.gradientButtonNode = new HTMLImageButtonNode(EatingAndExerciseResources.getString("time.reset"), new PhetFont(1, 12), Color.green);
            this.gradientButtonNode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ChartNode.this.resetChartArea();
                }
            });
            this.addChild(this.gradientButtonNode);
            this.axisLabel = new PNode();
            EatingAndExercisePText eatingAndExercisePText = new EatingAndExercisePText(EatingAndExerciseResources.getString("units.time.yrs"));
            this.axisLabel.addChild(eatingAndExercisePText);
            this.axisLabel.addChild(new PhetPPath((Shape)new Arrow((Point2D)new Point2D.Double(eatingAndExercisePText.getFullBounds().getMaxX(), eatingAndExercisePText.getFullBounds().getCenterY()), new MutableVector2D(20.0, 0.0), 6.0, 6.0, 2.0, 0.5, true).getShape(), (Paint)Color.black));
            this.addChild(this.axisLabel);
            NumberAxis numberAxis = (NumberAxis)this.getJFreeChartNode().getChart().getXYPlot().getDomainAxis();
            numberAxis.setTickUnit(new NumberTickUnit(0.3333333333333333));
            numberAxis.setNumberFormatOverride(new YearMonthFormat());
            this.relayout();
        }

        public void relayout() {
            super.relayout();
            if (this.gradientButtonNode != null) {
                int n = 2;
                this.gradientButtonNode.setOffset(this.getJFreeChartNode().getDataArea().getMaxX() - this.gradientButtonNode.getFullBounds().getWidth() - (double)n + this.getJFreeChartNode().getOffset().getX(), this.getJFreeChartNode().getDataArea().getMaxY() - this.gradientButtonNode.getFullBounds().getHeight());
                this.axisLabel.setOffset(this.getJFreeChartNode().getDataArea().getCenterX() - this.axisLabel.getFullBounds().getWidth() - (double)n + this.getJFreeChartNode().getOffset().getX(), this.getJFreeChartNode().getDataArea().getMaxY() - this.axisLabel.getFullBounds().getHeight());
            }
        }

        protected void zoomHorizontal(double d) {
            double d2 = this.getLowerBound();
            double d3 = this.getJFreeChartNode().getChart().getXYPlot().getDomainAxis().getUpperBound();
            double d4 = d3 - d2;
            double d5 = Math.min(2.0, d4 * d);
            this.setDomain(d2, d2 + d5);
            this.forceUpdateAll();
        }

        private double getLowerBound() {
            return this.getJFreeChartNode().getChart().getXYPlot().getDomainAxis().getLowerBound();
        }

        public void setDomain(double d, double d2) {
            super.setDomain(d, d2);
            if (this.getZoomControl() != null) {
                double d3 = d2 - d;
                double d4 = 1.0E-6;
                this.getZoomControl().setHorizontalZoomOutEnabled(d3 <= 2.0 - d4);
            }
            ChartNode.this.syncMassVar();
        }

        protected void zoomVertical(double d) {
            Range range = this.getVerticalRange(d);
            this.setVerticalRange(0.0, range.getUpperBound());
            this.notifyZoomChanged();
            this.forceUpdateAll();
        }
    }

    public static interface Listener {
        public void chartDataCleared();
    }
}

