/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.MotionMath;
import edu.colorado.phet.common.motion.model.DefaultTimeSeries;
import edu.colorado.phet.common.motion.model.DefaultVariable;
import edu.colorado.phet.common.motion.model.ITemporalVariable;
import edu.colorado.phet.common.motion.model.IVariable;
import edu.colorado.phet.common.motion.model.TimeData;
import edu.colorado.phet.common.phetcommon.math.Function;

public class DefaultTemporalVariable
implements ITemporalVariable {
    private DefaultVariable variable;
    private DefaultTimeSeries series;

    public DefaultTemporalVariable() {
        this(0.0);
    }

    public DefaultTemporalVariable(double d) {
        this(new DefaultVariable(d), new DefaultTimeSeries());
    }

    public DefaultTemporalVariable(DefaultVariable defaultVariable, DefaultTimeSeries defaultTimeSeries) {
        this.variable = defaultVariable;
        this.series = defaultTimeSeries;
    }

    public String toString() {
        return "value=" + this.variable + ", series=" + this.series;
    }

    public void addValue(double d, double d2) {
        this.variable.setValue(d);
        this.series.addValue(d, d2);
    }

    public void setValue(double d) {
        this.doSetValue(d);
    }

    public void doSetValue(double d) {
        this.variable.setValue(d);
    }

    public double getValue() {
        return this.variable.getValue();
    }

    public void addListener(IVariable.Listener listener) {
        this.variable.addListener(listener);
    }

    public TimeData getData(int n) {
        return this.series.getData(n);
    }

    public int getSampleCount() {
        return this.series.getSampleCount();
    }

    public void clear() {
        this.series.clear();
    }

    public void addListener(ITemporalVariable.Listener listener) {
        this.series.addListener(listener);
        this.variable.addListener(listener);
    }

    public double estimateAverage(double d, double d2) {
        TimeData[] timeDataArray = this.getData(d, d2);
        if (timeDataArray.length == 0) {
            throw new RuntimeException("Insufficient data");
        }
        if (timeDataArray.length == 1) {
            return timeDataArray[0].getValue();
        }
        Function.LinearFunction linearFunction = MotionMath.getLinearFit(timeDataArray);
        if (Double.isNaN(linearFunction.getMinOutput()) || Double.isNaN(linearFunction.getMaxOutput())) {
            return timeDataArray[0].getValue();
        }
        return linearFunction.evaluate((d2 + d) / 2.0);
    }

    public TimeData[] getData(double d, double d2) {
        return this.series.getData(d, d2);
    }
}

