/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.motion.graphs.ControlGraphSeries;
import edu.colorado.phet.common.motion.graphs.GraphControlSeriesNode;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.colorado.phet.common.timeseries.ui.TimeseriesResources;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class GraphTimeControlNode
extends PNode {
    private PSwing goStopButton;
    private PSwing clearButton;
    private PNode seriesLayer = new PNode();
    private boolean editable = true;
    private boolean constructed = false;

    public GraphTimeControlNode(TimeSeriesModel timeSeriesModel) {
        this.addChild(this.seriesLayer);
        this.goStopButton = new PSwing(new GoStopButton(timeSeriesModel));
        this.addChild(this.goStopButton);
        this.clearButton = new PSwing(new ClearButton(timeSeriesModel));
        this.addChild(this.clearButton);
        this.constructed = true;
        this.relayout();
    }

    public GraphControlSeriesNode addVariable(ControlGraphSeries controlGraphSeries) {
        GraphControlSeriesNode graphControlSeriesNode = this.createGraphControlSeriesNode(controlGraphSeries);
        graphControlSeriesNode.setEditable(this.editable);
        graphControlSeriesNode.setOffset(0.0, this.seriesLayer.getFullBounds().getHeight() + 5.0);
        this.seriesLayer.addChild(graphControlSeriesNode);
        this.relayout();
        return graphControlSeriesNode;
    }

    protected GraphControlSeriesNode createGraphControlSeriesNode(ControlGraphSeries controlGraphSeries) {
        return new GraphControlSeriesNode(controlGraphSeries);
    }

    private void relayout() {
        if (this.constructed) {
            double d = 5.0;
            this.seriesLayer.setOffset(0.0, 0.0);
            for (int i = 0; i < this.seriesLayer.getChildrenCount(); ++i) {
                GraphControlSeriesNode graphControlSeriesNode = (GraphControlSeriesNode)this.seriesLayer.getChild(i);
                graphControlSeriesNode.relayout(d);
            }
            this.goStopButton.setOffset(0.0, this.seriesLayer.getFullBounds().getMaxY() + d);
            this.clearButton.setOffset(0.0, this.goStopButton.getFullBounds().getMaxY() + d);
        }
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        for (int i = 0; i < this.seriesLayer.getChildrenCount(); ++i) {
            GraphControlSeriesNode graphControlSeriesNode = (GraphControlSeriesNode)this.seriesLayer.getChild(i);
            graphControlSeriesNode.setEditable(bl);
        }
        this.setHasChild(this.goStopButton, bl);
        this.setHasChild(this.clearButton, bl);
    }

    private void setHasChild(PNode pNode, boolean bl) {
        if (bl && !this.getChildrenReference().contains(pNode)) {
            this.addChild(pNode);
        } else if (!bl && this.getChildrenReference().contains(pNode)) {
            this.removeChild(pNode);
        }
    }

    public static class ClearButton
    extends JButton {
        private TimeSeriesModel graphTimeSeries;

        public ClearButton(final TimeSeriesModel timeSeriesModel) {
            super(PhetCommonResources.getString("Common.clear"));
            this.graphTimeSeries = timeSeriesModel;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    timeSeriesModel.clear();
                }
            });
            timeSeriesModel.addListener(new TimeSeriesModel.Adapter(){

                public void dataSeriesChanged() {
                    ClearButton.this.updateEnabledState();
                }
            });
            this.updateEnabledState();
        }

        private void updateEnabledState() {
            this.setEnabled(this.graphTimeSeries.isThereRecordedData());
        }
    }

    public static class GoStopButton
    extends JButton {
        private boolean goButton = true;
        private TimeSeriesModel timeSeriesModel;

        public GoStopButton(final TimeSeriesModel timeSeriesModel) {
            super(PhetCommonResources.getString("chart-time-control.go"));
            this.timeSeriesModel = timeSeriesModel;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (GoStopButton.this.isGoButton()) {
                        if (timeSeriesModel.getRecordTime() >= timeSeriesModel.getMaxRecordTime()) {
                            timeSeriesModel.startLiveMode();
                        } else {
                            timeSeriesModel.startRecording();
                        }
                    } else {
                        timeSeriesModel.setPaused(true);
                    }
                }
            });
            timeSeriesModel.addListener(new TimeSeriesModel.Adapter(){

                public void modeChanged() {
                    GoStopButton.this.updateGoState();
                }

                public void pauseChanged() {
                    GoStopButton.this.updateGoState();
                }
            });
            this.updateGoState();
        }

        private void updateGoState() {
            this.setGoButton(!this.timeSeriesModel.isRecording() && !this.timeSeriesModel.isLiveAndNotPaused());
        }

        private void setGoButton(boolean bl) {
            this.goButton = bl;
            this.setText(this.goButton ? PhetCommonResources.getString("chart-time-control.go") : PhetCommonResources.getString("Common.StopwatchPanel.stop"));
            this.setIcon(new ImageIcon(TimeseriesResources.loadBufferedImage(this.goButton ? "icons/go.png" : "icons/stop.png")));
        }

        private boolean isGoButton() {
            return this.goButton;
        }
    }
}

