/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.BufferedSeriesView;
import edu.colorado.phet.common.motion.model.ITemporalVariable;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import java.awt.Color;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class ControlGraphSeries {
    private String title;
    private Color color;
    private String abbr;
    private ITemporalVariable temporalVariable;
    private String units;
    private boolean visible = true;
    private Stroke stroke;
    private boolean editable;
    private String character;
    private ArrayList<Listener> listeners = new ArrayList();
    private DefaultDecimalFormat decimalFormat = new DefaultDecimalFormat("0.00");

    public ControlGraphSeries(String string, Color color, String string2, String string3, String string4, ITemporalVariable iTemporalVariable) {
        this(string, color, string2, string3, BufferedSeriesView.DEFAULT_STROKE, string4, iTemporalVariable);
    }

    public ControlGraphSeries(String string, Color color, String string2, String string3, Stroke stroke, String string4, ITemporalVariable iTemporalVariable) {
        this(string, color, string2, string3, stroke, string4, iTemporalVariable, false);
    }

    public ControlGraphSeries(String string, Color color, String string2, String string3, Stroke stroke, String string4, ITemporalVariable iTemporalVariable, boolean bl) {
        this.units = string3;
        this.editable = bl;
        this.stroke = stroke;
        this.title = string;
        this.color = color;
        this.abbr = string2;
        this.temporalVariable = iTemporalVariable;
        this.character = string4;
        if (color == null) {
            new RuntimeException("null color").printStackTrace();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public Color getColor() {
        return this.color;
    }

    public String getAbbr() {
        return this.abbr;
    }

    public void setDecimalFormat(DefaultDecimalFormat defaultDecimalFormat) {
        this.decimalFormat = defaultDecimalFormat;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String string) {
        if (this.units == null && string != null || !this.units.equals(string)) {
            this.units = string;
            this.notifyUnitsChanged();
        }
    }

    private void notifyUnitsChanged() {
        for (Listener listener : this.listeners) {
            listener.unitsChanged();
        }
    }

    public String getCharacterName() {
        return this.character;
    }

    public ITemporalVariable getTemporalVariable() {
        return this.temporalVariable;
    }

    public DecimalFormat getNumberFormat() {
        return this.decimalFormat;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public static class Adapter
    implements Listener {
        public void unitsChanged() {
        }
    }

    public static interface Listener {
        public void unitsChanged();
    }
}

