/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.jfreechartphet.piccolo;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.SwingPropertyChangeSupport;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeEventType;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;

public class JFreeChartNode
extends PNode
implements ChartChangeListener {
    private JFreeChart _chart;
    private ChartRenderingInfo _info;
    private boolean _buffered;
    private BufferedImage _chartImage;
    private AffineTransform _imageTransform;
    private int _bufferedImageType;
    private SwingPropertyChangeSupport _changeSupport = new SwingPropertyChangeSupport(this);

    public JFreeChartNode(JFreeChart jFreeChart) {
        this(jFreeChart, false);
    }

    public JFreeChartNode(JFreeChart jFreeChart, boolean bl) {
        this(jFreeChart, bl, 2);
    }

    public JFreeChartNode(JFreeChart jFreeChart, boolean bl, int n) {
        this._bufferedImageType = n;
        this._chart = jFreeChart;
        this._chart.addChangeListener(this);
        this._info = new ChartRenderingInfo();
        this._buffered = bl;
        this._chartImage = null;
        this._imageTransform = new AffineTransform();
        this.addPNodeUpdateHandler();
        this.updateAll();
    }

    public void updateChartRenderingInfo() {
        BufferedImage bufferedImage = new BufferedImage(1, 1, this._bufferedImageType);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this._chart.draw(graphics2D, this.getBounds(), this._info);
        this._changeSupport.firePropertyChange("chartRenderingInfo", null, this.getChartRenderingInfo());
    }

    protected void addPNodeUpdateHandler() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JFreeChartNode.this.updateAll();
            }
        });
    }

    protected void updateAll() {
        this.rebuildBuffer();
        this.updateChartRenderingInfo();
        this.repaint();
    }

    public JFreeChart getChart() {
        return this._chart;
    }

    public ChartRenderingInfo getChartRenderingInfo() {
        return this._info;
    }

    public Rectangle2D getDataArea() {
        ChartRenderingInfo chartRenderingInfo = this.getChartRenderingInfo();
        PlotRenderingInfo plotRenderingInfo = chartRenderingInfo.getPlotInfo();
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        ((Rectangle2D)double_).setRect(rectangle2D);
        return double_;
    }

    private XYPlot getXYPlot() {
        XYPlot xYPlot = null;
        if (!(this._chart.getPlot() instanceof XYPlot)) {
            throw new UnsupportedOperationException("only works for charts whose primary plot is an XYPlot");
        }
        xYPlot = (XYPlot)this._chart.getPlot();
        return xYPlot;
    }

    public void setBuffered(boolean bl) {
        if (this._buffered != bl) {
            this._buffered = bl;
            this.updateAll();
            this._changeSupport.firePropertyChange("buffered", !this._buffered, this._buffered);
        }
    }

    protected BufferedImage getBuffer() {
        return this._chartImage;
    }

    public void addBufferedPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changeSupport.addPropertyChangeListener("buffered", propertyChangeListener);
    }

    protected void addBufferedImagePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changeSupport.addPropertyChangeListener("bufferedImage", propertyChangeListener);
    }

    protected void removeBufferedImagePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changeSupport.removePropertyChangeListener("bufferedImage", propertyChangeListener);
    }

    public void addChartRenderingInfoPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changeSupport.addPropertyChangeListener("chartRenderingInfo", propertyChangeListener);
    }

    public void removeChartRenderingInfoPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changeSupport.removePropertyChangeListener("chartRenderingInfo", propertyChangeListener);
    }

    public Point2D nodeToPlot(Point2D point2D) {
        XYPlot xYPlot = this.getXYPlot();
        Rectangle2D rectangle2D = this.getDataArea();
        Point2D point2D2 = this.nodeToPlot(point2D, xYPlot, rectangle2D);
        return point2D2;
    }

    public Rectangle2D plotToNode(Rectangle2D rectangle2D) {
        Point2D point2D = this.plotToNode(new Point2D.Double(rectangle2D.getX(), rectangle2D.getY()));
        Point2D point2D2 = this.plotToNode(new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMaxY()));
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        double_.setFrameFromDiagonal(point2D, point2D2);
        return double_;
    }

    public Point2D plotToNode(Point2D point2D) {
        XYPlot xYPlot = this.getXYPlot();
        Rectangle2D rectangle2D = this.getDataArea();
        Point2D point2D2 = this.plotToNode(point2D, xYPlot, rectangle2D);
        return point2D2;
    }

    private Point2D nodeToPlot(Point2D point2D, XYPlot xYPlot, Rectangle2D rectangle2D) {
        double d = xYPlot.getDomainAxis().java2DToValue(point2D.getX(), rectangle2D, xYPlot.getDomainAxisEdge());
        double d2 = xYPlot.getRangeAxis().java2DToValue(point2D.getY(), rectangle2D, xYPlot.getRangeAxisEdge());
        return new Point2D.Double(d, d2);
    }

    private Point2D plotToNode(Point2D point2D, XYPlot xYPlot, Rectangle2D rectangle2D) {
        double d = xYPlot.getDomainAxis().valueToJava2D(point2D.getX(), rectangle2D, xYPlot.getDomainAxisEdge());
        double d2 = xYPlot.getRangeAxis().valueToJava2D(point2D.getY(), rectangle2D, xYPlot.getRangeAxisEdge());
        return new Point2D.Double(d, d2);
    }

    protected void internalUpdateBounds(double d, double d2, double d3, double d4) {
        super.internalUpdateBounds(d, d2, d3, d4);
        this.updateAll();
    }

    protected void paint(PPaintContext pPaintContext) {
        if (this._buffered) {
            this.paintBuffered(pPaintContext);
        } else {
            this.paintDirect(pPaintContext);
        }
    }

    private void paintDirect(PPaintContext pPaintContext) {
        Graphics2D graphics2D = pPaintContext.getGraphics();
        this._chart.draw(graphics2D, this.getBoundsReference(), this._info);
    }

    private void paintBuffered(PPaintContext pPaintContext) {
        PBounds pBounds = this.getBoundsReference();
        if (this._chartImage == null) {
            this.rebuildBuffer();
        }
        Graphics2D graphics2D = pPaintContext.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        this._imageTransform.setToTranslation(((RectangularShape)pBounds).getX(), ((RectangularShape)pBounds).getY());
        graphics2D.drawRenderedImage(this._chartImage, this._imageTransform);
    }

    private void rebuildBuffer() {
        PBounds pBounds = this.getBoundsReference();
        BufferedImage bufferedImage = this._chartImage;
        int n = (int)((RectangularShape)pBounds).getWidth();
        int n2 = (int)((RectangularShape)pBounds).getHeight();
        if (n > 0 && n2 > 0) {
            this._chartImage = this._chart.createBufferedImage(n, n2, this._bufferedImageType, this._info);
            this._changeSupport.firePropertyChange("bufferedImage", bufferedImage, this._chartImage);
        }
    }

    public void chartChanged(ChartChangeEvent chartChangeEvent) {
        if (chartChangeEvent.getType() == ChartChangeEventType.DATASET_UPDATED) {
            this.repaint();
        } else if (chartChangeEvent.getType() == ChartChangeEventType.NEW_DATASET) {
            this.repaint();
        } else {
            this.updateAll();
        }
    }
}

